/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.report;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.xml.transform.TransformerException;
import org.openide.util.NbBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import uk.gov.nationalarchives.droid.gui.report.ExportReportAction;
import uk.gov.nationalarchives.droid.report.ReportTransformer;

public class ReportViewFrame
extends JFrame {
    private static final long serialVersionUID = 9212026527186933180L;
    private static final String UTF8 = "UTF-8";
    private ReportTransformer reportTransformer;
    private ExportReportAction exportAction;
    private Path reportFile;
    private List<Path> xslTransforms;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private JButton closeButton;
    private JButton exportButton;
    private FSScrollPane fSScrollPane1;
    private XHTMLPanel xHTMLPanel1;

    public ReportViewFrame(Frame parent) {
        this.initComponents();
        URL icon = this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/DROID16.gif");
        this.setIconImage(new ImageIcon(icon).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (ReportViewFrame.this.reportFile != null && Files.exists(ReportViewFrame.this.reportFile, new LinkOption[0])) {
                    try {
                        Files.deleteIfExists(ReportViewFrame.this.reportFile);
                    }
                    catch (IOException ex) {
                        String message = String.format("Could not delete report file: %s. Will try to delete on exit.", ReportViewFrame.this.reportFile.toAbsolutePath().toString());
                        ReportViewFrame.this.log.warn(message);
                        ReportViewFrame.this.reportFile.toFile().deleteOnExit();
                    }
                }
            }
        });
    }

    public void renderReport(Path reportXml, List<Path> transforms) {
        this.reportFile = reportXml;
        this.xslTransforms = transforms;
        try (BufferedReader reader = Files.newBufferedReader(reportXml, StandardCharsets.UTF_8);
             StringWriter out = new StringWriter();){
            this.reportTransformer.transformUsingXsl((Reader)reader, "Web page.html.xsl", (Writer)out);
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.getBuffer().toString().getBytes(UTF8));){
                this.xHTMLPanel1.setDocument((InputStream)in, "");
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (IOException | TransformerException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.exportButton = new JButton();
        this.closeButton = new JButton();
        this.fSScrollPane1 = new FSScrollPane();
        this.xHTMLPanel1 = new XHTMLPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ReportViewFrame.class, (String)"ReportViewDialog.title"));
        this.exportButton.setText(NbBundle.getMessage(ReportViewFrame.class, (String)"ReportViewDialog.exportButton.text"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportViewFrame.this.exportButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText(NbBundle.getMessage(ReportViewFrame.class, (String)"ReportViewDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportViewFrame.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout xHTMLPanel1Layout = new GroupLayout((Container)this.xHTMLPanel1);
        this.xHTMLPanel1.setLayout((LayoutManager)xHTMLPanel1Layout);
        xHTMLPanel1Layout.setHorizontalGroup(xHTMLPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 627, Short.MAX_VALUE));
        xHTMLPanel1Layout.setVerticalGroup(xHTMLPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 505, Short.MAX_VALUE));
        this.fSScrollPane1.setViewportView((Component)this.xHTMLPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.fSScrollPane1, -1, 646, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.exportButton).addGap(18, 18, 18).addComponent(this.closeButton, -2, 78, -2).addGap(9, 9, 9)))));
        layout.linkSize(0, this.closeButton, this.exportButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent((Component)this.fSScrollPane1, -1, 524, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportButton).addComponent(this.closeButton)).addContainerGap()));
        layout.linkSize(1, this.closeButton, this.exportButton);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        this.exportAction.setDroidReportXml(this.reportFile);
        this.exportAction.execute(this, this.xslTransforms);
    }

    public void setReportTransformer(ReportTransformer reportTransformer) {
        this.reportTransformer = reportTransformer;
    }

    public void setExportAction(ExportReportAction exportAction) {
        this.exportAction = exportAction;
    }
}

