/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.signature;

import java.awt.Cursor;
import java.awt.Frame;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManagerException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.gui.DialogUtils;
import uk.gov.nationalarchives.droid.gui.signature.SignatureUpdateProgressDialog;

public class CheckSignatureUpdateAction
extends SwingWorker<Map<SignatureType, SignatureFileInfo>, Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SignatureManager signatureManager;
    private Map<SignatureType, SignatureFileInfo> signatureFileInfos;
    private SignatureUpdateProgressDialog progressDialog;
    private Frame parent;
    private boolean error;

    public CheckSignatureUpdateAction() {
    }

    public CheckSignatureUpdateAction(SignatureManager signatureManager) {
        this.setSignatureManager(signatureManager);
    }

    @Override
    protected Map<SignatureType, SignatureFileInfo> doInBackground() throws SignatureManagerException {
        this.signatureFileInfos = this.signatureManager.getLatestSignatureFiles();
        return this.signatureFileInfos;
    }

    public void start(Frame parentFrame) {
        this.parent = parentFrame;
        this.progressDialog = new SignatureUpdateProgressDialog(this.parent);
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        this.execute();
        this.progressDialog.setVisible(true);
        if (this.progressDialog.isCancelled()) {
            this.cancel(true);
        }
    }

    @Override
    protected void done() {
        try {
            this.signatureFileInfos = (Map)this.get();
        }
        catch (ExecutionException e) {
            this.error = true;
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
            this.log.warn(e.getCause().toString(), (Throwable)e);
            DialogUtils.showSignatureUpdateErrorDialog(this.parent, e.getCause());
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        catch (CancellationException e) {
            this.log.warn(e.getMessage());
        }
        finally {
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
                this.progressDialog.dispose();
            }
            if (this.parent != null) {
                this.parent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    public void setProgressDialog(SignatureUpdateProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    public Map<SignatureType, SignatureFileInfo> getSignatureFileInfos() {
        return this.signatureFileInfos;
    }

    public boolean hasError() {
        return this.error;
    }
}

