/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import uk.gov.nationalarchives.droid.gui.treemodel.DirectoryComparableObject;
import uk.gov.nationalarchives.droid.gui.treemodel.TreeUtils;

public class DefaultCellRenderer
implements TableCellRenderer {
    private JLabel renderer = new JLabel();
    private Color backColor;
    private Color darkerColor;

    public DefaultCellRenderer(Color backColor) {
        this.renderer.setOpaque(true);
        this.renderer.setHorizontalAlignment(0);
        this.backColor = backColor;
        this.darkerColor = TreeUtils.getDarkerColor(backColor);
    }

    public DefaultCellRenderer(Color backColor, int alignment) {
        this(backColor);
        this.renderer.setHorizontalAlignment(alignment);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.renderer.setBackground(table.getSelectionBackground());
            this.renderer.setForeground(table.getSelectionForeground());
        } else {
            this.renderer.setBackground(this.getBackgroundColor(table, row, column));
            this.renderer.setForeground(table.getForeground());
        }
        if (this.getFilterStatus(value) == 1) {
            this.renderer.setText(this.getDisplayValue(value));
            this.renderer.setIcon(this.getIcon(value));
        } else {
            this.renderer.setText("");
            this.renderer.setIcon(null);
        }
        return this.renderer;
    }

    public String getDisplayValue(Object value) {
        return value.toString();
    }

    public Icon getIcon(Object value) {
        return null;
    }

    protected JLabel getRenderer() {
        return this.renderer;
    }

    protected Icon getIconResource(String resourceName) {
        String resourcePath = String.format("uk/gov/nationalarchives/droid/icons/%s.gif", resourceName);
        URL imgURL = this.getClass().getClassLoader().getResource(resourcePath);
        return imgURL == null ? null : new ImageIcon(imgURL);
    }

    public int getFilterStatus(Object value) {
        DirectoryComparableObject o = (DirectoryComparableObject)value;
        return o.getFilterStatus();
    }

    private Color getBackgroundColor(JTable table, int row, int column) {
        Color theColor = row % 2 == 0 ? this.backColor : this.darkerColor;
        return theColor;
    }
}

