/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.treemodel;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.nio.file.Paths;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.gui.treemodel.TreeUtils;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class NodeRenderer
extends DefaultOutlineCellRenderer {
    private static final long serialVersionUID = -574370296768932560L;
    private Icon folderResourceTypeIcon = this.getIconResource("folderResourceType");
    private Icon folderResourceTypeNotDoneIcon;
    private Icon folderResourceTypeNotFoundIcon;
    private Icon folderResourceTypeAccessDeniedIcon;
    private Icon folderResourceTypeEmptyIcon;
    private Icon folderResourceTypeErrorIcon;
    private Icon containerResourceTypeIcon = this.getIconResource("containerResourceType");
    private Icon containerResourceTypeNotDoneIcon;
    private Icon containerResourceTypeNotFoundIcon;
    private Icon containerResourceTypeAccessDeniedIcon;
    private Icon containerResourceTypeErrorIcon;
    private Icon fileResourceTypeIcon = this.getIconResource("fileResourceType");
    private Icon fileResourceTypeNotDoneIcon;
    private Icon fileResourceTypeNotFoundIcon;
    private Icon fileResourceTypeAccessDeniedIcon;
    private Icon fileResourceTypeErrorIcon;
    private Color backColor;
    private Color darkerColor;

    public NodeRenderer(Color backColor) {
        this.folderResourceTypeNotDoneIcon = this.getIconResource("folderResourceType_NOT_DONE");
        this.containerResourceTypeNotDoneIcon = this.getIconResource("containerResourceType_NOT_DONE");
        this.fileResourceTypeNotDoneIcon = this.getIconResource("fileResourceType_NOT_DONE");
        this.folderResourceTypeNotFoundIcon = this.getIconResource("folderResourceType_NOTFOUND");
        this.containerResourceTypeNotFoundIcon = this.getIconResource("containerResourceType_NOTFOUND");
        this.fileResourceTypeNotFoundIcon = this.getIconResource("fileResourceType_NOTFOUND");
        this.folderResourceTypeEmptyIcon = this.getIconResource("folderResourceType_EMPTY");
        this.folderResourceTypeAccessDeniedIcon = this.getIconResource("folderResourceType_ACCESSDENIED");
        this.containerResourceTypeAccessDeniedIcon = this.getIconResource("containerResourceType_ACCESSDENIED");
        this.fileResourceTypeAccessDeniedIcon = this.getIconResource("fileResourceType_ACCESSDENIED");
        this.folderResourceTypeErrorIcon = this.getIconResource("folderResourceType_ERROR");
        this.containerResourceTypeErrorIcon = this.getIconResource("containerResourceType_ERROR");
        this.fileResourceTypeErrorIcon = this.getIconResource("fileResourceType_ERROR");
        this.backColor = backColor;
        this.darkerColor = TreeUtils.getDarkerColor(backColor);
    }

    private Icon getIconResource(String resourceName) {
        String resourcePath = String.format("uk/gov/nationalarchives/droid/icons/%s.gif", resourceName);
        URL imgURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
        return imgURL == null ? null : new ImageIcon(imgURL);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            renderer.setBackground(table.getSelectionBackground());
            renderer.setForeground(table.getSelectionForeground());
        } else {
            renderer.setBackground(this.getBackgroundColor(table, row, column));
            renderer.setForeground(this.getForegroundColor(value, table));
        }
        renderer.setText(this.getDisplayName(value));
        renderer.setIcon(this.getIcon(value));
        return renderer;
    }

    public String getDisplayName(Object node) {
        ProfileResourceNode profileNode = (ProfileResourceNode)((DefaultMutableTreeNode)node).getUserObject();
        return profileNode.getParentId() == null ? Paths.get(profileNode.getUri()).toString() : profileNode.getMetaData().getName();
    }

    public Icon getIcon(Object node) {
        ProfileResourceNode profileNode = this.getNode(node);
        NodeMetaData metadata = profileNode.getMetaData();
        ResourceType nodeType = metadata.getResourceType();
        NodeStatus status = metadata.getNodeStatus();
        Icon icon = null;
        block0 : switch (nodeType) {
            case FOLDER: {
                if (profileNode.getFilterStatus() != 1) {
                    icon = this.folderResourceTypeNotDoneIcon;
                    break;
                }
                switch (status) {
                    case NOT_DONE: {
                        icon = this.folderResourceTypeNotDoneIcon;
                        break block0;
                    }
                    case ACCESS_DENIED: {
                        icon = this.folderResourceTypeAccessDeniedIcon;
                        break block0;
                    }
                    case EMPTY: {
                        icon = this.folderResourceTypeEmptyIcon;
                        break block0;
                    }
                    case NOT_FOUND: {
                        icon = this.folderResourceTypeNotFoundIcon;
                        break block0;
                    }
                    case ERROR: {
                        icon = this.folderResourceTypeErrorIcon;
                        break block0;
                    }
                }
                icon = this.folderResourceTypeIcon;
                break;
            }
            case FILE: {
                if (profileNode.getFilterStatus() != 1) {
                    icon = this.fileResourceTypeNotDoneIcon;
                    break;
                }
                switch (status) {
                    case NOT_DONE: {
                        icon = this.fileResourceTypeNotDoneIcon;
                        break block0;
                    }
                    case ACCESS_DENIED: {
                        icon = this.fileResourceTypeAccessDeniedIcon;
                        break block0;
                    }
                    case NOT_FOUND: {
                        icon = this.fileResourceTypeNotFoundIcon;
                        break block0;
                    }
                    case ERROR: {
                        icon = this.fileResourceTypeErrorIcon;
                        break block0;
                    }
                }
                icon = this.fileResourceTypeIcon;
                break;
            }
            case CONTAINER: {
                if (profileNode.getFilterStatus() != 1) {
                    icon = this.containerResourceTypeNotDoneIcon;
                    break;
                }
                switch (status) {
                    case NOT_DONE: {
                        icon = this.containerResourceTypeNotDoneIcon;
                        break block0;
                    }
                    case ACCESS_DENIED: {
                        icon = this.containerResourceTypeAccessDeniedIcon;
                        break block0;
                    }
                    case NOT_FOUND: {
                        icon = this.containerResourceTypeNotFoundIcon;
                        break block0;
                    }
                    case ERROR: {
                        icon = this.containerResourceTypeErrorIcon;
                        break block0;
                    }
                }
                icon = this.containerResourceTypeIcon;
                break;
            }
        }
        return icon;
    }

    private Color getBackgroundColor(JTable table, int row, int column) {
        Color theColor = row % 2 == 0 ? this.backColor : this.darkerColor;
        return theColor;
    }

    private Color getForegroundColor(Object obj, JTable table) {
        return table.getForeground();
    }

    private ProfileResourceNode getNode(Object node) {
        return (ProfileResourceNode)((DefaultMutableTreeNode)node).getUserObject();
    }
}

