/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.planets.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class PlanetXMLFileFilter
extends FileFilter {
    private Hashtable filters = new Hashtable();
    private String description;
    private String fullDescription;
    private boolean useExtensionsInDescription = true;

    public PlanetXMLFileFilter() {
    }

    public PlanetXMLFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        boolean accept = false;
        if (f != null) {
            String extension;
            if (f.isDirectory()) {
                accept = true;
            }
            if ((extension = this.getExtension(f)) != null && this.filters.get(this.getExtension(f)) != null) {
                accept = true;
            }
        }
        return accept;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

