/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.planets.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import uk.gov.nationalarchives.droid.report.interfaces.ReportManager;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class PlanetsXMLGenerationSwingWorker
extends SwingWorker {
    private ClassPathXmlApplicationContext context;
    private JProgressBar planetXMLGenerationProgressBar;
    private String filePath;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel label;
    private String profileId;
    private ReportManager reportManager;

    public PlanetsXMLGenerationSwingWorker(String profileId, JProgressBar planetXMLGenerationProgressBar, String filePath, JButton cancelButton, JButton okButton, JLabel label, ReportManager reportManager) {
        this.planetXMLGenerationProgressBar = planetXMLGenerationProgressBar;
        this.filePath = filePath;
        this.cancelButton = cancelButton;
        this.okButton = okButton;
        this.label = label;
        this.profileId = profileId;
        this.reportManager = reportManager;
    }

    protected Integer doInBackground() {
        ProgressObserver observer = new ProgressObserver(){

            public void onProgress(Integer progress) {
                PlanetsXMLGenerationSwingWorker.this.setProgress(progress);
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    Integer value = (Integer)evt.getNewValue();
                    PlanetsXMLGenerationSwingWorker.this.planetXMLGenerationProgressBar.setValue(value);
                }
            }
        });
        this.reportManager.setObserver(observer);
        this.reportManager.generatePlanetsXML(this.profileId, this.filePath);
        return null;
    }

    @Override
    protected void done() {
        this.cancelButton.hide();
        this.okButton.show();
        this.label.setText("PLANETS XML is at : ");
    }

    public void setReportManager(ReportManager reportManager) {
        this.reportManager = reportManager;
    }
}

