/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import java.io.IOException;
import java.io.InputStream;

class EntryInputStream
extends InputStream {
    private Iso9660FileEntry entry;
    private Iso9660FileSystem fileSystem;
    private int pos;
    private int rem;

    EntryInputStream(Iso9660FileEntry entry, Iso9660FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.entry = entry;
        this.pos = 0;
        this.rem = (int)entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        this.ensureOpen();
        if (this.rem <= 0) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        int toRead = len;
        if (toRead > this.rem) {
            toRead = this.rem;
        }
        Iso9660FileSystem iso9660FileSystem = this.fileSystem;
        synchronized (iso9660FileSystem) {
            if (this.fileSystem.isClosed()) {
                throw new IOException("ISO file closed.");
            }
            read = this.fileSystem.readBytes(this.entry, this.pos, b, off, toRead);
        }
        if (read > 0) {
            this.pos += len;
            this.rem -= len;
        }
        return read;
    }

    public int read() throws IOException {
        this.ensureOpen();
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    public long skip(long n) {
        this.ensureOpen();
        int len = n > (long)this.rem ? this.rem : (int)n;
        this.pos += len;
        this.rem -= len;
        if (this.rem <= 0) {
            this.close();
        }
        return len;
    }

    public int available() {
        return Math.max(this.rem, 0);
    }

    public int size() {
        this.ensureOpen();
        return (int)this.entry.getSize();
    }

    public void close() {
        this.rem = 0;
        this.entry = null;
        this.fileSystem = null;
    }

    private void ensureOpen() {
        if (null == this.entry) {
            throw new IllegalStateException("stream has been closed");
        }
    }
}

