/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata.serializer;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import net.byteseek.automata.Automata;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.automata.serializer.AutomataSerializer;

public final class DotSerializer<T>
implements AutomataSerializer<T, String> {
    private static final String DOT_HEADER = "digraph {\n";
    private static final String DOT_TITLE = "label=\"%s\"\n";
    private static final String DOT_FOOTER = "\n}";
    private static final String FINAL_STATE_SHAPE = "doublecircle";
    private static final String NON_FINAL_STATE_SHAPE = "circle";
    private static final String STATE_DEFINITION = "%s [label=\"%s\", shape=\"%s\"]\n";
    private static final String TRANSITION_DEFINITION = "%s->%s [label=\"%s\"]\n";

    @Override
    public String serialize(Automata<T> automata, boolean includeAssociatedObjects, String title) {
        StringBuilder stringBuilder = new StringBuilder(256);
        this.buildHeader(stringBuilder, title);
        this.buildStates(stringBuilder, automata, includeAssociatedObjects);
        this.buildFooter(stringBuilder);
        return stringBuilder.toString();
    }

    private void buildHeader(StringBuilder builder, String title) {
        builder.append(DOT_HEADER);
        String onelineTitle = title.replaceAll("\\s", " ");
        builder.append(String.format(DOT_TITLE, onelineTitle));
    }

    private void buildStates(StringBuilder builder, Automata<T> automata, boolean includeAssociatedObjects) {
        IdentityHashMap<State<T>, Integer> visitedStates = new IdentityHashMap<State<T>, Integer>();
        this.buildDot(automata.getInitialState(), includeAssociatedObjects, visitedStates, 0, builder);
    }

    private void buildFooter(StringBuilder builder) {
        builder.append(DOT_FOOTER);
    }

    private int buildDot(State<T> state, boolean includeAssociatedObjects, Map<State<T>, Integer> visitedStates, int nextStateNumber, StringBuilder builder) {
        if (!visitedStates.containsKey(state)) {
            visitedStates.put(state, nextStateNumber);
            String shapeDef = Integer.toString(nextStateNumber);
            StringBuilder label = new StringBuilder();
            label.append(nextStateNumber);
            if (includeAssociatedObjects) {
                Collection<T> associatedObjects = state.getAssociations();
                for (T t : associatedObjects) {
                    label.append(" [").append(t.toString()).append(']');
                }
            }
            String shape = state.isFinal() ? FINAL_STATE_SHAPE : NON_FINAL_STATE_SHAPE;
            builder.append(String.format(STATE_DEFINITION, shapeDef, label.toString(), shape));
            for (Transition transition : state) {
                State toState = transition.getToState();
                int processedNumber = this.buildDot(toState, includeAssociatedObjects, visitedStates, nextStateNumber + 1, builder);
                nextStateNumber = processedNumber > nextStateNumber ? processedNumber : nextStateNumber;
                String toStateLabel = Integer.toString(visitedStates.get(toState));
                String transitionLabel = transition.toString();
                builder.append(String.format(TRANSITION_DEFINITION, label, toStateLabel, transitionLabel));
            }
        }
        return nextStateNumber;
    }
}

