/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.byteseek.io.IOUtils;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.windows.SoftWindow;
import net.byteseek.io.reader.windows.SoftWindowRecovery;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.io.reader.windows.WindowMissingException;

public final class TempFileCache
extends AbstractFreeNotificationCache
implements SoftWindowRecovery {
    private final TLongObjectMap<WindowInfo> windowPositions = new TLongObjectHashMap();
    private final File tempDir;
    private File tempFile;
    private RandomAccessFile file;
    private long nextFilePos;

    public TempFileCache() {
        this(null);
    }

    public TempFileCache(File tempDir) {
        this.tempDir = tempDir;
        if (tempDir != null && !tempDir.isDirectory()) {
            throw new IllegalArgumentException("The temp dir file supplied is not a directory: " + tempDir.getAbsolutePath());
        }
    }

    @Override
    public Window getWindow(long position) throws IOException {
        SoftWindow window = null;
        WindowInfo info = (WindowInfo)this.windowPositions.get(position);
        if (info != null) {
            byte[] array = new byte[info.length];
            IOUtils.readBytes(this.file, array, info.filePosition);
            window = new SoftWindow(array, position, info.length, this);
        }
        return window;
    }

    @Override
    public void addWindow(Window window) throws IOException {
        long windowPosition = window.getWindowPosition();
        WindowInfo info = (WindowInfo)this.windowPositions.get(windowPosition);
        if (info == null) {
            this.createFileIfNotExists();
            this.file.seek(this.nextFilePos);
            this.file.write(window.getArray(), 0, window.length());
            this.windowPositions.put(windowPosition, (Object)new WindowInfo(window.length(), this.nextFilePos));
            this.nextFilePos += (long)window.length();
        }
    }

    @Override
    public void clear() throws IOException {
        this.windowPositions.clear();
        this.deleteFileIfExists();
    }

    public File getTempFile() {
        return this.tempFile;
    }

    private void createFileIfNotExists() throws IOException {
        if (this.tempFile == null) {
            this.windowPositions.clear();
            this.nextFilePos = 0L;
            this.tempFile = this.tempDir == null ? IOUtils.createTempFile() : IOUtils.createTempFile(this.tempDir);
            this.file = new RandomAccessFile(this.tempFile, "rw");
        }
    }

    private void deleteFileIfExists() throws IOException {
        if (this.tempFile != null) {
            IOException fileCloseException = null;
            try {
                this.file.close();
            }
            catch (IOException ex) {
                fileCloseException = ex;
            }
            finally {
                this.file = null;
                this.tempFile.delete();
                this.tempFile = null;
                this.nextFilePos = 0L;
            }
            if (fileCloseException != null) {
                throw fileCloseException;
            }
        }
    }

    @Override
    public byte[] reloadWindowBytes(Window window) throws IOException {
        WindowInfo info = (WindowInfo)this.windowPositions.get(window.getWindowPosition());
        if (info != null) {
            byte[] array = new byte[info.length];
            IOUtils.readBytes(this.file, array, info.filePosition);
            return array;
        }
        throw new WindowMissingException("No window exists in the cache for the window: " + window);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[temp file: " + this.tempFile + " window positions recorded:" + this.windowPositions.size() + ']';
    }

    private static final class WindowInfo {
        final int length;
        final long filePosition;

        public WindowInfo(int limit, long filePosition) {
            this.length = limit;
            this.filePosition = filePosition;
        }
    }
}

