/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.windows;

import java.io.IOException;
import java.lang.ref.SoftReference;
import net.byteseek.io.reader.windows.SoftWindowRecovery;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public final class SoftWindow
implements Window {
    private SoftReference<byte[]> bytes;
    private final long windowPosition;
    private final int length;
    private final SoftWindowRecovery recovery;

    public SoftWindow(byte[] bytes, long windowPosition, int length, SoftWindowRecovery recovery) {
        ArgUtils.checkNullByteArray(bytes, "bytes");
        this.bytes = new SoftReference<byte[]>(bytes);
        this.windowPosition = windowPosition;
        this.recovery = recovery;
        this.length = length;
    }

    @Override
    public byte getByte(int position) throws IOException {
        return this.getByteArray()[position];
    }

    @Override
    public byte[] getArray() throws IOException {
        return this.getByteArray();
    }

    @Override
    public long getWindowPosition() {
        return this.windowPosition;
    }

    @Override
    public long getWindowEndPosition() {
        return this.windowPosition + (long)this.length - 1L;
    }

    @Override
    public long getNextWindowPosition() {
        return this.windowPosition + (long)this.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[window length:" + this.length + " window pos:" + this.windowPosition + ']';
    }

    private byte[] getByteArray() throws IOException {
        byte[] array = this.bytes.get();
        if (array == null) {
            array = this.recovery.reloadWindowBytes(this);
            this.bytes = new SoftReference<byte[]>(array);
        }
        return array;
    }
}

