/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.AbstractByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.ByteMatcherSequenceMatcher;
import net.byteseek.matcher.sequence.ByteSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class TwoByteMatcher
extends AbstractByteMatcher {
    private final byte firstByteToMatch;
    private final byte secondByteToMatch;

    public TwoByteMatcher(byte firstByteToMatch, byte secondByteToMatch) {
        this.firstByteToMatch = firstByteToMatch;
        this.secondByteToMatch = secondByteToMatch;
    }

    public TwoByteMatcher(String firstHexByte, String secondHexByte) {
        this.firstByteToMatch = ByteUtils.byteFromHex(firstHexByte);
        this.secondByteToMatch = ByteUtils.byteFromHex(secondHexByte);
    }

    public TwoByteMatcher(Collection<Byte> twoBytes) {
        ArgUtils.checkCollectionSizeNoNullElements(twoBytes, 2);
        Iterator<Byte> byteIterator = twoBytes.iterator();
        this.firstByteToMatch = byteIterator.next();
        this.secondByteToMatch = byteIterator.next();
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        if (window != null) {
            byte windowByte = window.getByte(reader.getWindowOffset(matchPosition));
            return windowByte == this.firstByteToMatch || windowByte == this.secondByteToMatch;
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        if (matchPosition >= 0 && matchPosition < bytes.length) {
            byte theByte = bytes[matchPosition];
            return theByte == this.firstByteToMatch || theByte == this.secondByteToMatch;
        }
        return false;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        byte theByte = bytes[matchPosition];
        return theByte == this.firstByteToMatch || theByte == this.secondByteToMatch;
    }

    @Override
    public boolean matches(byte theByte) {
        return theByte == this.firstByteToMatch || theByte == this.secondByteToMatch;
    }

    @Override
    public byte[] getMatchingBytes() {
        byte[] byArray;
        if (this.firstByteToMatch != this.secondByteToMatch) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = this.firstByteToMatch;
            byArray = byArray2;
            byArray2[1] = this.secondByteToMatch;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = this.firstByteToMatch;
        }
        return byArray;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        if (this.getNumberOfMatchingBytes() == 1) {
            return String.format("%02x", this.firstByteToMatch & 0xFF);
        }
        String format = prettyPrint ? "%02x %02x" : "%02x%02x";
        return '[' + String.format(format, this.firstByteToMatch & 0xFF, this.secondByteToMatch & 0xFF) + ']';
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return this.firstByteToMatch != this.secondByteToMatch ? 2 : 1;
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats);
        if (numberOfRepeats == 1) {
            return this;
        }
        if (this.getNumberOfMatchingBytes() == 1) {
            return new ByteSequenceMatcher(this.firstByteToMatch, numberOfRepeats);
        }
        return new ByteMatcherSequenceMatcher(numberOfRepeats, (ByteMatcher)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.format("%02x", this.firstByteToMatch & 0xFF) + ' ' + String.format("%02x", this.secondByteToMatch & 0xFF) + ']';
    }
}

