/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata.walker;

import java.util.ArrayDeque;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.automata.walker.Action;
import net.byteseek.automata.walker.Step;
import net.byteseek.automata.walker.Walker;
import net.byteseek.utils.collections.IdentityHashSet;

public final class StateChildWalker<T>
implements Walker<T> {
    public static <T> void walkAutomata(State<T> startState, Action<T> action) {
        StateChildWalker<T> walker = new StateChildWalker<T>();
        walker.walk(startState, action);
    }

    @Override
    public void walk(State<T> startState, Action<T> action) {
        IdentityHashSet visitedStates = new IdentityHashSet();
        ArrayDeque walkSteps = new ArrayDeque();
        walkSteps.addFirst(new Step<T>(null, null, startState));
        while (!walkSteps.isEmpty()) {
            Step step = (Step)walkSteps.removeFirst();
            State state = step.currentState;
            if (visitedStates.contains(state)) continue;
            visitedStates.add(state);
            for (Transition transition : state) {
                walkSteps.addFirst(new Step(state, transition, transition.getToState()));
            }
            boolean keepWalking = action.process(step);
            if (keepWalking) continue;
            return;
        }
    }
}

