/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public abstract class AbstractReader
implements WindowReader {
    protected static final int NO_BYTE_AT_POSITION = -1;
    protected static final long UNKNOWN_LENGTH = -1L;
    protected static final int DEFAULT_WINDOW_SIZE = 4096;
    protected static final int DEFAULT_CAPACITY = 32;
    protected final int windowSize;
    protected final WindowCache cache;
    private Window lastWindow;

    public AbstractReader(WindowCache cache) {
        this(4096, cache);
    }

    public AbstractReader(int windowSize, WindowCache cache) {
        ArgUtils.checkPositiveInteger(windowSize, "windowSize");
        ArgUtils.checkNullObject(cache, "cache");
        this.windowSize = windowSize;
        this.cache = cache;
    }

    @Override
    public int readByte(long position) throws IOException {
        Window window = this.getWindow(position);
        int offset = (int)(position % (long)this.windowSize);
        if (window == null || offset >= window.length()) {
            return -1;
        }
        return window.getByte(offset) & 0xFF;
    }

    @Override
    public Window getWindow(long position) throws IOException {
        if (position >= 0L) {
            Window window;
            int offset = (int)(position % (long)this.windowSize);
            long windowStart = position - (long)offset;
            if (this.lastWindow != null && this.lastWindow.getWindowPosition() == windowStart) {
                window = this.lastWindow;
            } else {
                window = this.cache.getWindow(windowStart);
                if (window != null) {
                    this.lastWindow = window;
                } else {
                    window = this.createWindow(windowStart);
                    if (window != null) {
                        this.lastWindow = window;
                        this.cache.addWindow(window);
                    }
                }
            }
            if (window != null && offset >= window.length()) {
                window = null;
            }
            return window;
        }
        return null;
    }

    @Override
    public Iterator<Window> iterator() {
        return new WindowIterator();
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
    }

    @Override
    public int getWindowOffset(long position) {
        return (int)(position % (long)this.windowSize);
    }

    protected abstract Window createWindow(long var1) throws IOException;

    private class WindowIterator
    implements Iterator<Window> {
        private int position = 0;

        private WindowIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                return AbstractReader.this.getWindow(this.position) != null;
            }
            catch (IOException ex) {
                return false;
            }
        }

        @Override
        public Window next() {
            try {
                Window window = AbstractReader.this.getWindow(this.position);
                if (window != null) {
                    this.position = (int)((long)this.position + (long)window.length());
                    return window;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a window from a reader.");
        }
    }
}

