/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.InvertibleMatcher;
import net.byteseek.utils.ByteUtils;

public final class AnyBitmaskMatcher
extends InvertibleMatcher {
    final byte mBitMaskValue;

    public AnyBitmaskMatcher(byte bitMaskValue) {
        super(false);
        this.mBitMaskValue = bitMaskValue;
    }

    public AnyBitmaskMatcher(byte bitMaskValue, boolean inverted) {
        super(inverted);
        this.mBitMaskValue = bitMaskValue;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        return window == null ? false : (window.getByte(reader.getWindowOffset(matchPosition)) & this.mBitMaskValue) != 0 ^ this.inverted;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return matchPosition >= 0 && matchPosition < bytes.length && (bytes[matchPosition] & this.mBitMaskValue) != 0 ^ this.inverted;
    }

    @Override
    public boolean matches(byte theByte) {
        return (theByte & this.mBitMaskValue) != 0 ^ this.inverted;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        String wrapper = this.inverted ? "^~%02x" : "~%02x";
        return String.format(wrapper, 0xFF & this.mBitMaskValue);
    }

    @Override
    public byte[] getMatchingBytes() {
        return this.inverted ? ByteUtils.getBytesNotMatchingAnyBitMask(this.mBitMaskValue) : ByteUtils.getBytesMatchingAnyBitMask(this.mBitMaskValue);
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return this.inverted ? 256 - ByteUtils.countBytesMatchingAnyBit(this.mBitMaskValue) : ByteUtils.countBytesMatchingAnyBit(this.mBitMaskValue);
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return (bytes[matchPosition] & this.mBitMaskValue) != 0 ^ this.inverted;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bitmask:" + String.format("%02x", this.mBitMaskValue & 0xFF) + " inverted:" + this.inverted + ']';
    }
}

