/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.parser;

import net.byteseek.parser.ParseException;
import net.byteseek.utils.ArgUtils;

public class StringParseReader {
    protected final String string;
    protected final int length;
    protected int position;

    public StringParseReader(String string) {
        ArgUtils.checkNullString(string);
        this.string = string;
        this.length = string.length();
    }

    public final int getPosition() {
        return this.position;
    }

    public final String getString() {
        return this.string;
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean atEnd() {
        return this.position >= this.length;
    }

    public final int read() {
        return this.position < this.length ? (int)this.string.charAt(this.position++) : -1;
    }

    public final int peekBehind() {
        return this.position > 0 ? (int)this.string.charAt(this.position - 1) : -1;
    }

    public final int peekAhead() {
        return this.position < this.length ? (int)this.string.charAt(this.position) : -1;
    }

    public final byte readHexByte() throws ParseException {
        return (byte)this.hexByteValue(this.readBoundsChecked(), this.readBoundsChecked());
    }

    public final byte readHexByte(int firstHexChar) throws ParseException {
        return (byte)this.hexByteValue(firstHexChar, this.readBoundsChecked());
    }

    public final int readInt() throws ParseException {
        long value = 0L;
        int digit = this.read();
        int numDigits = 0;
        while (digit >= 48 && digit <= 57) {
            if ((value = value * 10L + (long)digit - 48L) > Integer.MAX_VALUE) {
                throw new ParseException("Integer overflow - the digits ending at position " + this.position + " are bigger than Integer.MAX_VALUE");
            }
            ++numDigits;
            digit = this.read();
        }
        if (numDigits > 0) {
            if (digit >= 0) {
                --this.position;
            }
            return (int)value;
        }
        throw new ParseException("No digits found at position " + this.position);
    }

    public final String readString(char closingChar) throws ParseException {
        int endStringPosition = this.string.indexOf(closingChar, this.position);
        if (endStringPosition >= 0) {
            String result = this.string.substring(this.position, endStringPosition);
            this.position = endStringPosition + 1;
            return result;
        }
        throw new ParseException("A closing string marker [" + closingChar + "] was not found up to position " + this.position);
    }

    public final void readPastChar(char toChar) {
        int charIndex = this.string.indexOf(toChar, this.position);
        this.position = charIndex >= 0 ? charIndex + 1 : this.length;
    }

    public final int readBoundsChecked() throws ParseException {
        if (this.position < this.length) {
            return this.string.charAt(this.position++);
        }
        throw new ParseException("The end of the string has been reached at position " + this.position);
    }

    public String toString() {
        return "StringParseReader[" + this.string + ']';
    }

    protected final int hexByteValue(int firstHexChar, int secondHexChar) throws ParseException {
        return (this.hexDigitValue(firstHexChar) << 4) + this.hexDigitValue(secondHexChar);
    }

    protected final int hexDigitValue(int digit) throws ParseException {
        if (digit >= 48 && digit <= 57) {
            return digit - 48;
        }
        if (digit >= 97 && digit <= 102) {
            return digit - 97 + 10;
        }
        if (digit >= 65 && digit <= 70) {
            return digit - 65 + 10;
        }
        throw new ParseException("The character " + digit + " is not a hex digit at position " + this.position + " in expression " + this.string);
    }
}

