/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.utils;

import java.util.Collection;

public final class ArgUtils {
    private static final String OBJECT_CANNOT_BE_NULL = "The object cannot be null";
    private static final String COLLECTION_CANNOT_BE_NULL = "The collection cannot be null";
    private static final String COLLECTION_MUST_BE_RIGHT_SIZE = "The collection of size %d must be exactly %d in size";
    private static final String COLLECTION_CANNOT_BE_EMPTY = "The collection cannot be empty";
    private static final String COLLECTION_ELEMENT_CANNOT_BE_NULL = "Elements cannot be null";
    private static final String ARRAY_CANNOT_BE_NULL = "The array cannot be null";
    private static final String ARRAY_CANNOT_BE_EMPTY = "The array cannot be empty";
    private static final String STRING_CANNOT_BE_NULL = "The string cannot be null";
    private static final String STRING_CANNOT_BE_EMPTY = "The string cannot be empty";
    private static final String END_PAST_LENGTH_ERROR = "The end %d is past the end, length = %d";
    private static final String START_LESS_THAN_ZERO_ERROR = "The start %d is less than zero.";
    private static final String START_PAST_END_INDEX_ERROR = "The start index %d is equal to or greater than the end index %d";
    private static final String START_PAST_LENGTH_ERROR = "Start position %d is past the end, length = %d.";
    private static final String POSITIVE_INTEGER = "The number %d should be a positive integer.";
    private static final String NUMBER_OUT_OF_RANGE = "The number %d is outside the range %d to %d : %s";

    public static void checkNullObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(OBJECT_CANNOT_BE_NULL);
        }
    }

    public static void checkNullObject(Object object, String description) {
        if (object == null) {
            throw new IllegalArgumentException("The object cannot be null " + description);
        }
    }

    public static <T> void checkNullCollection(Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(COLLECTION_CANNOT_BE_NULL);
        }
    }

    public static <T> void checkNullCollection(Collection<T> collection, String description) {
        if (collection == null) {
            throw new IllegalArgumentException("The collection cannot be null " + description);
        }
    }

    public static <T> void checkNullOrEmptyCollection(Collection<T> collection) {
        ArgUtils.checkNullCollection(collection);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(COLLECTION_CANNOT_BE_EMPTY);
        }
    }

    public static <T> void checkCollectionSize(Collection<T> collection, int size) {
        ArgUtils.checkNullCollection(collection);
        if (collection.size() != size) {
            throw new IllegalArgumentException(String.format(COLLECTION_MUST_BE_RIGHT_SIZE, collection.size(), size));
        }
    }

    public static <T> void checkCollectionSizeNoNullElements(Collection<T> collection, int size) {
        ArgUtils.checkCollectionSize(collection, size);
        for (T element : collection) {
            ArgUtils.checkNullObject(element, COLLECTION_ELEMENT_CANNOT_BE_NULL);
        }
    }

    public static <T> void checkNullOrEmptyCollection(Collection<T> collection, String description) {
        ArgUtils.checkNullCollection(collection, description);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("The collection cannot be empty " + description);
        }
    }

    public static <T> void checkNullCollectionElements(Collection<T> collection) {
        ArgUtils.checkNullCollection(collection);
        for (T element : collection) {
            ArgUtils.checkNullObject(element, COLLECTION_ELEMENT_CANNOT_BE_NULL);
        }
    }

    public static <T> void checkNullCollectionElements(Collection<T> collection, String description) {
        ArgUtils.checkNullCollection(collection, description);
        for (T element : collection) {
            ArgUtils.checkNullObject(element, "Elements cannot be null " + description);
        }
    }

    public static <T> void checkNullOrEmptyCollectionNoNullElements(Collection<T> collection) {
        ArgUtils.checkNullOrEmptyCollection(collection);
        for (T element : collection) {
            ArgUtils.checkNullObject(element, COLLECTION_ELEMENT_CANNOT_BE_NULL);
        }
    }

    public static <T> void checkNullOrEmptyCollectionNoNullElements(Collection<T> collection, String description) {
        ArgUtils.checkNullOrEmptyCollection(collection, description);
        for (T element : collection) {
            ArgUtils.checkNullObject(element, "Elements cannot be null " + description);
        }
    }

    public static void checkNullByteArray(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(ARRAY_CANNOT_BE_NULL);
        }
    }

    public static void checkNullByteArray(byte[] bytes, String description) {
        if (bytes == null) {
            throw new IllegalArgumentException("The array cannot be null " + description);
        }
    }

    public static void checkNullOrEmptyByteArray(byte[] bytes) {
        ArgUtils.checkNullByteArray(bytes);
        if (bytes.length == 0) {
            throw new IllegalArgumentException(ARRAY_CANNOT_BE_EMPTY);
        }
    }

    public static void checkNullOrEmptyByteArray(byte[] bytes, String description) {
        ArgUtils.checkNullByteArray(bytes);
        if (bytes.length == 0) {
            throw new IllegalArgumentException("The array cannot be empty " + description);
        }
    }

    public static <T> void checkNullArray(T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(ARRAY_CANNOT_BE_NULL);
        }
    }

    public static <T> void checkNullArray(T[] array, String description) {
        if (array == null) {
            throw new IllegalArgumentException("The array cannot be null " + description);
        }
    }

    public static <T> void checkNullOrEmptyArray(T[] array) {
        ArgUtils.checkNullArray(array);
        if (array.length == 0) {
            throw new IllegalArgumentException(ARRAY_CANNOT_BE_EMPTY);
        }
    }

    public static <T> void checkNullOrEmptyArray(T[] array, String description) {
        ArgUtils.checkNullArray(array, description);
        if (array.length == 0) {
            throw new IllegalArgumentException("The array cannot be empty " + description);
        }
    }

    public static <T> void checkNullOrEmptyArrayNoNullElements(T[] array, String description) {
        ArgUtils.checkNullOrEmptyArray(array, description);
        for (T element : array) {
            ArgUtils.checkNullObject(element, "Elements cannot be null " + description);
        }
    }

    public static <T> void checkNullOrEmptyArrayNoNullElements(T[] array) {
        ArgUtils.checkNullOrEmptyArray(array);
        for (T element : array) {
            ArgUtils.checkNullObject(element, COLLECTION_ELEMENT_CANNOT_BE_NULL);
        }
    }

    public static void checkRangeInclusive(int number, int start, int end, String description) {
        if (number < start || number > end) {
            throw new IllegalArgumentException(String.format(NUMBER_OUT_OF_RANGE, number, start, end, description));
        }
    }

    public static void checkNullString(String string) {
        if (string == null) {
            throw new IllegalArgumentException(STRING_CANNOT_BE_NULL);
        }
    }

    public static void checkNullString(String string, String description) {
        if (string == null) {
            throw new IllegalArgumentException("The string cannot be null " + description);
        }
    }

    public static void checkNullOrEmptyString(String string) {
        if (string == null) {
            throw new IllegalArgumentException(STRING_CANNOT_BE_NULL);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException(STRING_CANNOT_BE_EMPTY);
        }
    }

    public static void checkNullOrEmptyString(String string, String description) {
        if (string == null) {
            throw new IllegalArgumentException("The string cannot be null " + description);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The string cannot be empty " + description);
        }
    }

    public static void checkIndexOutOfBounds(int length, int position) {
        if (position < 0) {
            throw new IndexOutOfBoundsException(String.format(START_LESS_THAN_ZERO_ERROR, position));
        }
        if (position >= length) {
            throw new IndexOutOfBoundsException(String.format(START_PAST_LENGTH_ERROR, position, length));
        }
    }

    public static void checkIndexOutOfBounds(int length, int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException(String.format(START_LESS_THAN_ZERO_ERROR, startIndex));
        }
        if (startIndex >= endIndex) {
            throw new IndexOutOfBoundsException(String.format(START_PAST_END_INDEX_ERROR, startIndex, endIndex));
        }
        if (startIndex >= length) {
            throw new IndexOutOfBoundsException(String.format(START_PAST_LENGTH_ERROR, startIndex, length));
        }
        if (endIndex > length) {
            throw new IndexOutOfBoundsException(String.format(END_PAST_LENGTH_ERROR, endIndex, length));
        }
    }

    public static void checkPositiveInteger(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("The number " + number + " should be a positive integer.");
        }
    }

    public static void checkPositiveInteger(int number, String description) {
        if (number < 1) {
            throw new IllegalArgumentException(String.format("The number %d should be a positive integer. " + description, number));
        }
    }
}

