/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.utils.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.utils.ArgUtils;

public class BytePermutationIterator
implements Iterator<byte[]> {
    private final List<byte[]> byteArrays;
    private final int[] permutationState;
    private final int length;
    private final byte[] permutation;

    public BytePermutationIterator(List<byte[]> byteArrays) {
        ArgUtils.checkNullOrEmptyCollection(byteArrays);
        this.byteArrays = new ArrayList<byte[]>(byteArrays);
        for (byte[] array : this.byteArrays) {
            ArgUtils.checkNullOrEmptyByteArray(array);
        }
        this.length = byteArrays.size();
        this.permutationState = new int[this.length];
        this.permutation = new byte[this.length];
    }

    @Override
    public boolean hasNext() {
        return this.permutationState[0] < this.byteArrays.get(0).length;
    }

    @Override
    public byte[] next() {
        if (this.hasNext()) {
            this.buildCurrentPermutation();
            this.buildNextPermutationState();
            return (byte[])this.permutation.clone();
        }
        throw new NoSuchElementException("No more permutations available for the byte arrays.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Permutation iterator cannot remove generated permutations.");
    }

    private void buildCurrentPermutation() {
        byte[] localperm = this.permutation;
        for (int arrayIndex = 0; arrayIndex < this.length; ++arrayIndex) {
            int permutationIndex = this.permutationState[arrayIndex];
            byte[] array = this.byteArrays.get(arrayIndex);
            localperm[arrayIndex] = array[permutationIndex];
        }
    }

    private void buildNextPermutationState() {
        boolean finished = false;
        int stateIndex = this.length - 1;
        while (!finished) {
            int state = this.permutationState[stateIndex] + 1;
            byte[] array = this.byteArrays.get(stateIndex);
            boolean bl = finished = state < array.length || stateIndex == 0;
            if (finished) {
                this.permutationState[stateIndex] = state;
                continue;
            }
            this.permutationState[stateIndex] = 0;
            --stateIndex;
        }
    }
}

