/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report;

import com.itextpdf.text.DocumentException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.report.ReportTransformException;
import uk.gov.nationalarchives.droid.report.ReportTransformer;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class ReportTransformerImpl
implements ReportTransformer {
    private static final String UTF8 = "UTF-8";
    private DroidGlobalConfig globalConfig;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ReportTransformerImpl() {
    }

    public ReportTransformerImpl(DroidGlobalConfig config) {
        this.globalConfig = config;
    }

    @Override
    public void transformUsingXsl(Reader sourceReader, String xslScriptLocation, Writer out) throws TransformerException {
        try (BufferedInputStream transform = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(xslScriptLocation));){
            this.transform(sourceReader, transform, out);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    @Override
    public void transformUsingXsl(Reader sourceReader, Path xslFile, Writer out) throws TransformerException {
        try (BufferedInputStream transform = new BufferedInputStream(Files.newInputStream(xslFile, new OpenOption[0]));){
            this.transform(sourceReader, transform, out);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    private void transform(Reader sourceReader, InputStream xsl, Writer out) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource transformSource = new StreamSource(new BufferedReader(new InputStreamReader(xsl, StandardCharsets.UTF_8)));
        Transformer transformer = transformerFactory.newTransformer(transformSource);
        StreamSource source = new StreamSource(sourceReader);
        StreamResult result = new StreamResult(out);
        transformer.setParameter("reportDir", this.getReportDir());
        transformer.transform(source, result);
    }

    private String getReportDir() {
        String dir = "";
        if (this.globalConfig != null) {
            Path reportDir = this.globalConfig.getReportDefinitionDir();
            dir = reportDir == null ? "" : reportDir.toAbsolutePath().toString();
        }
        return dir;
    }

    @Override
    public void transformToPdf(Reader in, String transformLocation, OutputStream out) throws ReportTransformException {
        try {
            Path tmpXhtml = Files.createTempFile(this.globalConfig.getTempDir(), "xhtml~", null, new FileAttribute[0]);
            tmpXhtml.toFile().deleteOnExit();
            try (BufferedWriter buffer = Files.newBufferedWriter(tmpXhtml, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.transformUsingXsl(in, transformLocation, (Writer)buffer);
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocument(tmpXhtml.toFile());
                renderer.layout();
                renderer.createPDF(out);
            }
            catch (DocumentException | TransformerException e) {
                throw new ReportTransformException(e);
            }
            finally {
                FileUtil.deleteQuietly((Path)tmpXhtml);
            }
        }
        catch (IOException e) {
            throw new ReportTransformException(e);
        }
    }

    public void setConfig(DroidGlobalConfig config) {
        this.globalConfig = config;
    }
}

