/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.report.planets.xml;

import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import uk.gov.nationalarchives.droid.planet.xml.dao.GroupByPuidSizeAndCountRow;
import uk.gov.nationalarchives.droid.planet.xml.dao.GroupByYearSizeAndCountRow;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLData;
import uk.gov.nationalarchives.droid.report.planets.domain.ByFormatType;
import uk.gov.nationalarchives.droid.report.planets.domain.ByYearType;
import uk.gov.nationalarchives.droid.report.planets.domain.FileProfileType;
import uk.gov.nationalarchives.droid.report.planets.domain.FormatItemType;
import uk.gov.nationalarchives.droid.report.planets.domain.ObjectFactory;
import uk.gov.nationalarchives.droid.report.planets.domain.PathsProcessedType;
import uk.gov.nationalarchives.droid.report.planets.domain.YearItemType;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

@Deprecated
public class PlanetsXMLGenerator {
    private static final int TWENTY = 20;
    private static final int FOURTY = 40;
    private static final int SIXTY = 60;
    private static final int EIGHTY = 80;
    private static final int HUNDRED = 100;
    private static final int THOUSAND = 1000;
    private static final int YEAROFFSET = 1900;
    private String filePath;
    private ProgressObserver observer;
    private PlanetsXMLData planetsData;

    public PlanetsXMLGenerator(ProgressObserver observer, String filePath, PlanetsXMLData planetsData) {
        this.observer = observer;
        this.filePath = filePath;
        this.planetsData = planetsData;
    }

    public PlanetsXMLGenerator(String filePath, PlanetsXMLData planetsData) {
        this.filePath = filePath;
        this.planetsData = planetsData;
    }

    public PlanetsXMLGenerator() {
    }

    public void generate() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            FileProfileType fileProfileType = objFactory.createFileProfileType();
            JAXBElement<FileProfileType> fileProfile = objFactory.createFileProfile(fileProfileType);
            PathsProcessedType pathProcessedType = this.getPathProcessed(objFactory);
            ByFormatType byFormatType = this.getGroupByPuid(objFactory);
            ByYearType byYearType = this.getGroupByYear(objFactory);
            this.getFileProfileType(fileProfileType, pathProcessedType, byFormatType, byYearType);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"uk.gov.nationalarchives.droid.report.planets.domain");
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (this.observer != null) {
                this.observer.onProgress(Integer.valueOf(100));
            }
            m.marshal(fileProfile, Paths.get(this.filePath, new String[0]).toFile());
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error  while writing to an xml file.");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error while writing to an xml file.");
        }
    }

    private PathsProcessedType getPathProcessed(ObjectFactory objFactory) throws InterruptedException {
        PathsProcessedType pathProcessedType = objFactory.createPathsProcessedType();
        List<String> pathItemsList = pathProcessedType.getPathItem();
        for (String item : this.planetsData.getTopLevelItems()) {
            pathItemsList.add(item);
        }
        if (this.observer != null) {
            this.observer.onProgress(Integer.valueOf(20));
        }
        return pathProcessedType;
    }

    private void getFileProfileType(FileProfileType fileProfileType, PathsProcessedType pathProcessedType, ByFormatType byFormatType, ByYearType byYearType) throws InterruptedException {
        fileProfileType.setPathsProcessed(pathProcessedType);
        fileProfileType.setByFormat(byFormatType);
        fileProfileType.setByYear(byYearType);
        fileProfileType.setProfilingEndDate(this.getXMLGregorianCalendar(this.planetsData.getProfileStat().getProfileEndDate()));
        fileProfileType.setProfilingSaveDate(this.getXMLGregorianCalendar(this.planetsData.getProfileStat().getProfileSaveDate()));
        fileProfileType.setProfilingStartDate(this.getXMLGregorianCalendar(this.planetsData.getProfileStat().getProfileStartDate()));
        fileProfileType.setTotalSize(new BigDecimal(this.planetsData.getProfileStat().getProfileTotalSize()));
        fileProfileType.setSmallestSize(new BigDecimal(this.planetsData.getProfileStat().getProfileSmallestSize()));
        fileProfileType.setMeanSize(this.planetsData.getProfileStat().getProfileMeanSize());
        fileProfileType.setLargestSize(new BigDecimal(this.planetsData.getProfileStat().getProfileLargestSize()));
        fileProfileType.setTotalUnreadableFiles(this.planetsData.getProfileStat().getProfileTotalUnReadableFiles());
        fileProfileType.setTotalReadableFiles(this.planetsData.getProfileStat().getProfileTotalReadableFiles());
        fileProfileType.setTotalUnreadableFolders(this.planetsData.getProfileStat().getProfileTotalUnReadableFolders());
        if (this.observer != null) {
            this.observer.onProgress(Integer.valueOf(80));
        }
    }

    private ByFormatType getGroupByPuid(ObjectFactory objFactory) throws InterruptedException {
        ByFormatType byFormatType = objFactory.createByFormatType();
        List<FormatItemType> formatItemList = byFormatType.getFormatItem();
        for (GroupByPuidSizeAndCountRow byPuid : this.planetsData.getGroupByPuid()) {
            FormatItemType formatItemType = objFactory.createFormatItemType();
            formatItemType.setFormatName(byPuid.getFormatName());
            formatItemType.setFormatVersion(byPuid.getFormatVersion());
            formatItemType.setMIME(byPuid.getMimeType());
            formatItemType.setNumFiles(byPuid.getCount());
            formatItemType.setPUID(byPuid.getPuid());
            formatItemType.setTotalFileSize(byPuid.getSize());
            if ("NULL".equals(byPuid.getPuid())) continue;
            formatItemList.add(formatItemType);
        }
        if (this.observer != null) {
            this.observer.onProgress(Integer.valueOf(40));
        }
        return byFormatType;
    }

    private ByYearType getGroupByYear(ObjectFactory objFactory) throws InterruptedException {
        ByYearType byYearType = objFactory.createByYearType();
        List<YearItemType> byeYearTypeList = byYearType.getYearItem();
        if (this.planetsData.getGroupByYear() == null) {
            byeYearTypeList = null;
            return null;
        }
        for (GroupByYearSizeAndCountRow byYear : this.planetsData.getGroupByYear()) {
            YearItemType yearItemType = objFactory.createYearItemType();
            yearItemType.setNumFiles(byYear.getCount());
            yearItemType.setTotalFileSize(byYear.getSize());
            try {
                XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
                xmlCalendar.setYear(byYear.getYear());
                yearItemType.setYear(xmlCalendar);
                byeYearTypeList.add(yearItemType);
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        if (this.observer != null) {
            this.observer.onProgress(Integer.valueOf(60));
        }
        return byYearType;
    }

    private XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        XMLGregorianCalendar xmlCalendar = null;
        try {
            xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            if (date != null) {
                xmlCalendar.setDay(date.getDate());
                xmlCalendar.setMonth(date.getMonth() + 1);
                xmlCalendar.setYear(date.getYear() + 1900);
                xmlCalendar.setHour(date.getHours());
                xmlCalendar.setMinute(date.getMinutes());
                xmlCalendar.setSecond(date.getSeconds());
            }
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return xmlCalendar;
    }
}

