/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.AbstractFsObject;
import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.Fat;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

final class ClusterChain
extends AbstractFsObject {
    private final Fat fat;
    private final BlockDevice device;
    private final int clusterSize;
    private final long dataOffset;
    private long startCluster;

    public ClusterChain(Fat fat, boolean readOnly) {
        this(fat, 0L, readOnly);
    }

    public ClusterChain(Fat fat, long startCluster, boolean readOnly) {
        super(readOnly);
        this.fat = fat;
        if (startCluster != 0L) {
            this.fat.testCluster(startCluster);
            if (this.fat.isFreeCluster(startCluster)) {
                throw new IllegalArgumentException("cluster " + startCluster + " is free");
            }
        }
        this.device = fat.getDevice();
        this.dataOffset = fat.getBootSector().getFilesOffset();
        this.startCluster = startCluster;
        this.clusterSize = fat.getBootSector().getBytesPerCluster();
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public Fat getFat() {
        return this.fat;
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    public long getStartCluster() {
        return this.startCluster;
    }

    private long getDevOffset(long cluster, int clusterOffset) {
        return this.dataOffset + (long)clusterOffset + (cluster - 2L) * (long)this.clusterSize;
    }

    public long getLengthOnDisk() {
        if (this.getStartCluster() == 0L) {
            return 0L;
        }
        return this.getChainLength() * this.clusterSize;
    }

    public long setSize(long size) throws IOException {
        long nrClusters = (size + (long)this.clusterSize - 1L) / (long)this.clusterSize;
        if (nrClusters > Integer.MAX_VALUE) {
            throw new IOException("too many clusters");
        }
        this.setChainLength((int)nrClusters);
        return (long)this.clusterSize * nrClusters;
    }

    public int getChainLength() {
        if (this.getStartCluster() == 0L) {
            return 0;
        }
        long[] chain = this.getFat().getChain(this.getStartCluster());
        return chain.length;
    }

    public void setChainLength(int nrClusters) throws IOException {
        if (nrClusters < 0) {
            throw new IllegalArgumentException("negative cluster count");
        }
        if (this.startCluster != 0L || nrClusters != 0) {
            if (this.startCluster == 0L && nrClusters > 0) {
                long[] chain = this.fat.allocNew(nrClusters);
                this.startCluster = chain[0];
            } else {
                long[] chain = this.fat.getChain(this.startCluster);
                if (nrClusters != chain.length) {
                    if (nrClusters > chain.length) {
                        for (int count = nrClusters - chain.length; count > 0; --count) {
                            this.fat.allocAppend(this.getStartCluster());
                        }
                    } else if (nrClusters > 0) {
                        this.fat.setEof(chain[nrClusters - 1]);
                        for (int i = nrClusters; i < chain.length; ++i) {
                            this.fat.setFree(chain[i]);
                        }
                    } else {
                        for (int i = 0; i < chain.length; ++i) {
                            this.fat.setFree(chain[i]);
                        }
                        this.startCluster = 0L;
                    }
                }
            }
        }
    }

    public void readData(long offset, ByteBuffer dest) throws IOException {
        int len = dest.remaining();
        if (this.startCluster == 0L && len > 0) {
            throw new EOFException("cannot read from empty cluster chain");
        }
        long[] chain = this.getFat().getChain(this.startCluster);
        BlockDevice dev = this.getDevice();
        int chainIdx = (int)(offset / (long)this.clusterSize);
        if (offset % (long)this.clusterSize != 0L) {
            int clusOfs = (int)(offset % (long)this.clusterSize);
            int size = Math.min(len, (int)((long)this.clusterSize - offset % (long)this.clusterSize));
            dest.limit(dest.position() + size);
            dev.read(this.getDevOffset(chain[chainIdx], clusOfs), dest);
            len -= size;
            ++chainIdx;
        }
        while (len > 0) {
            int size = Math.min(this.clusterSize, len);
            dest.limit(dest.position() + size);
            dev.read(this.getDevOffset(chain[chainIdx], 0), dest);
            len -= size;
            ++chainIdx;
        }
    }

    public void writeData(long offset, ByteBuffer srcBuf) throws IOException {
        int len = srcBuf.remaining();
        if (len == 0) {
            return;
        }
        long minSize = offset + (long)len;
        if (this.getLengthOnDisk() < minSize) {
            this.setSize(minSize);
        }
        long[] chain = this.fat.getChain(this.getStartCluster());
        int chainIdx = (int)(offset / (long)this.clusterSize);
        if (offset % (long)this.clusterSize != 0L) {
            int clusOfs = (int)(offset % (long)this.clusterSize);
            int size = Math.min(len, (int)((long)this.clusterSize - offset % (long)this.clusterSize));
            srcBuf.limit(srcBuf.position() + size);
            this.device.write(this.getDevOffset(chain[chainIdx], clusOfs), srcBuf);
            len -= size;
            ++chainIdx;
        }
        while (len > 0) {
            int size = Math.min(this.clusterSize, len);
            srcBuf.limit(srcBuf.position() + size);
            this.device.write(this.getDevOffset(chain[chainIdx], 0), srcBuf);
            len -= size;
            ++chainIdx;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterChain)) {
            return false;
        }
        ClusterChain other = (ClusterChain)obj;
        if (!(this.fat == other.fat || this.fat != null && this.fat.equals(other.fat))) {
            return false;
        }
        return this.startCluster == other.startCluster;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.fat != null ? this.fat.hashCode() : 0);
        hash = 79 * hash + (int)(this.startCluster ^ this.startCluster >>> 32);
        return hash;
    }
}

