/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.filter.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.QueryBuilder;

public abstract class Junction
implements Criterion {
    private static final String SPACE = " ";
    private List<Criterion> criteria = new ArrayList<Criterion>();
    private String op;

    protected Junction(String op) {
        this.op = op;
    }

    public Junction add(Criterion criterion) {
        this.criteria.add(criterion);
        return this;
    }

    @Override
    public Object[] getValues() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Criterion criterion : this.criteria) {
            params.addAll(Arrays.asList(criterion.getValues()));
        }
        return params.toArray();
    }

    @Override
    public String toEjbQl(QueryBuilder parent) {
        if (this.criteria.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Iterator<Criterion> it = this.criteria.iterator();
        while (it.hasNext()) {
            Criterion criterion = it.next();
            sb.append(criterion.toEjbQl(parent));
            if (!it.hasNext()) continue;
            sb.append(SPACE + this.op + SPACE);
        }
        sb.append(")");
        return sb.toString();
    }
}

