/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.byteseek.io.reader.ReaderInputStream;
import net.byteseek.io.reader.WindowReader;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class WebArchiveEntryIdentificationRequest
implements IdentificationRequest<InputStream> {
    private static final int BUFFER_CACHE_CAPACITY = 16;
    private static final int CAPACITY = 32768;
    private static final int TOP_TAIL_CAPACITY = 0x200000;
    private final String extension;
    private final String fileName;
    private final RequestMetaData requestMetaData;
    private final RequestIdentifier identifier;
    private Path tempDir;
    private Long size;
    private WindowReader reader;

    public WebArchiveEntryIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, Path tempDir) {
        this.identifier = identifier;
        this.size = metaData.getSize();
        this.fileName = metaData.getName();
        this.extension = ResourceUtils.getExtension(this.fileName);
        this.tempDir = tempDir;
        this.requestMetaData = metaData;
    }

    @Override
    public final void open(InputStream in) throws IOException {
        this.reader = ResourceUtils.getStreamReader(in, this.tempDir, 0x200000);
        this.size = this.reader.length();
    }

    @Override
    public final void close() throws IOException {
        this.reader.close();
    }

    @Override
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return new ReaderInputStream(this.reader, false);
    }

    @Override
    public final RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public final RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public byte getByte(long position) throws IOException {
        int result = this.reader.readByte(position);
        if (result < 0) {
            throw new IOException("No byte at position " + position);
        }
        return (byte)result;
    }

    @Override
    public WindowReader getWindowReader() {
        return this.reader;
    }
}

