/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jwat.arc.ArcRecordBase;
import org.jwat.arc.ArcWriter;

public class ArcWriterUncompressed
extends ArcWriter {
    ArcWriterUncompressed(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        this.out = out;
        this.init();
    }

    ArcWriterUncompressed(OutputStream out, int buffer_size) {
        if (out == null) {
            throw new IllegalArgumentException("The 'out' parameter is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' parameter is less than or equal to zero!");
        }
        this.out = new BufferedOutputStream(out, buffer_size);
        this.init();
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.state == 1 || this.state == 2) {
            this.closeRecord();
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    @Override
    public void closeRecord() throws IOException {
        if (this.state == 1 || this.state == 2) {
            this.closeRecord_impl();
            this.state = 3;
        } else if (this.state == 0) {
            throw new IllegalStateException("Write a record before closing it!");
        }
    }

    @Override
    public byte[] writeHeader(ArcRecordBase record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The 'record' parameter is null!");
        }
        if (this.state == 1) {
            throw new IllegalStateException("Headers written back to back!");
        }
        if (this.state == 2) {
            this.closeRecord_impl();
        }
        return this.writeHeader_impl(record);
    }
}

