/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.export;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReader;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReaderCallback;
import uk.gov.nationalarchives.droid.export.interfaces.ItemWriter;
import uk.gov.nationalarchives.droid.export.interfaces.JobCancellationException;
import uk.gov.nationalarchives.droid.profile.ProfileContextLocator;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class ExportTask
implements Runnable {
    private static final String PROJECT_NOT_AVAILABLE_FOR_EXPORT = "Profile not available for export: %s";
    private static final int BOM_1 = 239;
    private static final int BOM_2 = 187;
    private static final int BOM_3 = 191;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String destination;
    private final List<String> profileIds;
    private final Filter filterOverride;
    private final ExportOptions options;
    private final String outputEncoding;
    private final boolean bom;
    private final ItemWriter<ProfileResourceNode> itemWriter;
    private final ProfileContextLocator profileContextLocator;
    private volatile boolean cancelled;

    public ExportTask(String destination, List<String> profileIds, Filter filterOverride, ExportOptions options, String outputEncoding, boolean bom, ItemWriter<ProfileResourceNode> itemWriter, ProfileContextLocator profileContextLocator) {
        this.destination = destination;
        this.profileIds = profileIds;
        this.filterOverride = filterOverride;
        this.options = options;
        this.outputEncoding = outputEncoding;
        this.bom = bom;
        this.itemWriter = itemWriter;
        this.profileContextLocator = profileContextLocator;
    }

    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void run() {
        Writer writer;
        String destinationDescription;
        String string = destinationDescription = this.destination == null ? "System.out" : this.destination;
        if (this.destination == null) {
            writer = new PrintWriter(System.out);
        } else {
            try {
                writer = this.newOutputFileWriter();
            }
            catch (IOException e) {
                String message = String.format("IO exception occurred trying to read from: %s", destinationDescription);
                this.log.error(message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        this.doExport(writer, destinationDescription);
    }

    protected Writer newOutputFileWriter() throws IOException {
        Writer writer = this.outputEncoding != null ? this.newOutputFileWriterEncoded(this.outputEncoding, Paths.get(this.destination, new String[0])) : this.newOutputFileWriterEncoded(Charset.defaultCharset().name(), Paths.get(this.destination, new String[0]));
        return writer;
    }

    protected Writer newOutputFileWriterEncoded(String encoding, Path f) throws IOException {
        OutputStream outputStream = Files.newOutputStream(f, new OpenOption[0]);
        if (this.bom) {
            outputStream.write(239);
            outputStream.write(187);
            outputStream.write(191);
            outputStream.flush();
        }
        return new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(Writer writer, String destinationDescription) {
        Path toDelete;
        this.log.info(String.format("Exporting profiles to: [%s]", destinationDescription));
        Map<String, String> headerCustomisations = this.getHeaderCustomisationsFromProfiles();
        this.itemWriter.setHeaders(headerCustomisations);
        this.itemWriter.setOptions(this.options);
        this.itemWriter.open(writer);
        StopWatch stopWatch = new StopWatch();
        try {
            for (String profileId : this.profileIds) {
                stopWatch.start();
                if (!this.profileContextLocator.hasProfileContext(profileId)) {
                    String message = String.format(PROJECT_NOT_AVAILABLE_FOR_EXPORT, profileId);
                    this.log.warn(message);
                    throw new RuntimeException(message);
                }
                ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
                ProfileInstanceManager profileContext = this.profileContextLocator.openProfileInstanceManager(profile);
                ItemReader reader = profileContext.getNodeItemReader();
                ItemReaderCallback<ProfileResourceNode> callback = new ItemReaderCallback<ProfileResourceNode>(){

                    public void onItem(List<? extends ProfileResourceNode> itemChunk) throws JobCancellationException {
                        ExportTask.this.itemWriter.write(itemChunk);
                        if (ExportTask.this.cancelled) {
                            ExportTask.this.log.info("Export interrupted");
                            throw new JobCancellationException("Cancelled");
                        }
                    }
                };
                Filter filter = this.filterOverride != null ? this.filterOverride : profile.getFilter();
                reader.readAll((ItemReaderCallback)callback, filter);
                stopWatch.stop();
                this.log.info(String.format("Time for export [%s]: %s ms", profileId, stopWatch.getTime()));
                stopWatch.reset();
            }
        }
        catch (JobCancellationException e) {
            Path toDelete2;
            try {
                String message = String.format("Export cancelled - deleting export destination: %s", destinationDescription);
                this.log.info(message);
                this.cancelled = true;
            }
            catch (Throwable throwable) {
                Path toDelete3;
                this.log.info(String.format("Closing export file: %s", destinationDescription));
                this.itemWriter.close();
                if (this.cancelled && this.destination != null && Files.exists(toDelete3 = Paths.get(this.destination, new String[0]), new LinkOption[0])) {
                    try {
                        Files.deleteIfExists(toDelete3);
                    }
                    catch (IOException ioe) {
                        this.log.warn(String.format("Could not delete export file: %s. Will try to delete on exit.", this.destination));
                        toDelete3.toFile().deleteOnExit();
                    }
                }
                throw throwable;
            }
            this.log.info(String.format("Closing export file: %s", destinationDescription));
            this.itemWriter.close();
            if (this.cancelled && this.destination != null && Files.exists(toDelete2 = Paths.get(this.destination, new String[0]), new LinkOption[0])) {
                try {
                    Files.deleteIfExists(toDelete2);
                }
                catch (IOException ioe) {
                    this.log.warn(String.format("Could not delete export file: %s. Will try to delete on exit.", this.destination));
                    toDelete2.toFile().deleteOnExit();
                }
            }
        }
        this.log.info(String.format("Closing export file: %s", destinationDescription));
        this.itemWriter.close();
        if (this.cancelled && this.destination != null && Files.exists(toDelete = Paths.get(this.destination, new String[0]), new LinkOption[0])) {
            try {
                Files.deleteIfExists(toDelete);
            }
            catch (IOException ioe) {
                this.log.warn(String.format("Could not delete export file: %s. Will try to delete on exit.", this.destination));
                toDelete.toFile().deleteOnExit();
            }
        }
    }

    private Map<String, String> getHeaderCustomisationsFromProfiles() {
        HashMap<String, String> map = new HashMap<String, String>();
        String hashAlgorithmHeader = "HASH";
        HashSet<String> algorithmsFound = new HashSet<String>();
        for (String profileId : this.profileIds) {
            if (!this.profileContextLocator.hasProfileContext(profileId)) {
                String message = String.format(PROJECT_NOT_AVAILABLE_FOR_EXPORT, profileId);
                this.log.warn(message);
                throw new RuntimeException(message);
            }
            ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
            if (!profile.getGenerateHash().booleanValue()) continue;
            algorithmsFound.add(profile.getHashAlgorithm().toUpperCase());
        }
        if (algorithmsFound.size() == 1) {
            hashAlgorithmHeader = (String)algorithmsFound.iterator().next() + "_HASH";
        }
        map.put("hash", hashAlgorithmHeader);
        return map;
    }
}

