/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import uk.gov.nationalarchives.droid.command.action.CommandFactory;
import uk.gov.nationalarchives.droid.command.action.CommandLineException;
import uk.gov.nationalarchives.droid.command.action.CommandLineSyntaxException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.i18n.I18N;

public enum CommandLineParam {
    HELP("h", "help", "help.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getHelpCommand();
        }
    }
    ,
    VERSION("v", "version", "version.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getVersionCommand();
        }
    }
    ,
    EXPORT_ONE_ROW_PER_FILE("e", "export-file", false, 1, "export.file.help", CommandLineParam.filename()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineSyntaxException {
            return commandFactory.getExportFileCommand(cli);
        }
    }
    ,
    EXPORT_ONE_ROW_PER_FORMAT("E", "export-format", false, 1, "export.format.help", CommandLineParam.filename()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineSyntaxException {
            return commandFactory.getExportFormatCommand(cli);
        }
    }
    ,
    PROFILES("p", "profile(s)", true, -1, "profiles.help", "filename(s)"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    ALL_FILTER("f", "filter-all", true, -1, "all.filter.help", CommandLineParam.filters()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    ANY_FILTER("F", "filter-any", true, -1, "any.filter.help", CommandLineParam.filters()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    BOM("B", "bom", "help.bom"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineException {
            return null;
        }
    }
    ,
    REPORT("r", "report", true, 1, "report.help", CommandLineParam.filename()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineSyntaxException {
            return commandFactory.getReportCommand(cli);
        }
    }
    ,
    REPORT_NAME("n", "report-name", true, 1, "report.name.help", "report name"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    REPORT_OUTPUT_TYPE("t", "report-type", true, 1, "report.type.help", "report type"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    LIST_REPORTS("l", "list-reports", "report.list.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getListReportCommand();
        }
    }
    ,
    LIST_FILTER_FIELD("k", "filter-fields", "filter.field.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getFilterFieldCommand();
        }
    }
    ,
    RUN_PROFILE("a", "profile-resources", true, -1, "profile.run.help", "resources"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineSyntaxException {
            return commandFactory.getProfileCommand(cli);
        }
    }
    ,
    RUN_NO_PROFILE("Nr", "no-profile-resource", true, -1, "no_profile.run.help", "folder"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineSyntaxException {
            return commandFactory.getNoProfileCommand(cli);
        }
    }
    ,
    SIGNATURE_FILE("Ns", "signature-file", true, 1, "signature_file.help", CommandLineParam.filename()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    CONTAINER_SIGNATURE_FILE("Nc", "container-file", true, 1, "container_signature_file.help", CommandLineParam.filename()){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    EXTENSION_LIST("Nx", "extension-list", true, -1, "extension_list.help", "extensions"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    RECURSIVE("R", "recurse", "recurse.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    ARCHIVES("A", "open-all-archives", "archives.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    ARCHIVE_TYPES("At", "open-archive-types", true, -1, "archive_types.help", "archive types"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    WEB_ARCHIVES("W", "open-all-webarchives", "web_archives.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    WEB_ARCHIVE_TYPES("Wt", "open-webarchive-types", true, 2, "web_archive_types.help", "web archive types"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    QUIET("q", "quiet", "quiet.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return null;
        }
    }
    ,
    CHECK_SIGNATURE_UPDATE("c", "check-signature-update", "signature_update.check.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getCheckSignatureUpdateCommand();
        }
    }
    ,
    DOWNLOAD_SIGNATURE_UPDATE("d", "download-signature-update", "signature_update.download.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getDownloadSignatureUpdateCommand();
        }
    }
    ,
    LIST_SIGNATURE_VERSIONS("X", "list-signature-files", "signature.list_all.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getListAllSignatureVersionsCommand();
        }
    }
    ,
    DEFAULT_SIGNATURE_VERSION("x", "display-signature-file", "signature.display_default.help"){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) {
            return commandFactory.getDisplayDefaultSignatureVersionCommand();
        }
    }
    ,
    CONFIGURE_DEFAULT_SIGNATURE_VERSION("s", "set-signature-file", true, 1, "signature.configure_default.help", I18N.getResource("version")){

        @Override
        public DroidCommand getCommand(CommandFactory commandFactory, CommandLine cli) throws CommandLineException {
            return commandFactory.getConfigureDefaultSignatureVersionCommand(cli);
        }
    };

    public static final Map<String, CommandLineParam> TOP_LEVEL_COMMANDS;
    private static final String FILENAME = "filename";
    private String shortName;
    private String longName;
    private String resourceKey;
    private boolean argsRequired;
    private int maxArgs;
    private String argName;

    private CommandLineParam(String shortName, String longName, String resourceKey) {
        this.shortName = shortName;
        this.longName = longName;
        this.resourceKey = resourceKey;
    }

    private CommandLineParam(String shortName, String longName, boolean argsRequired, int maxArgs, String resourceKey, String argName) {
        this(shortName, longName, resourceKey);
        this.maxArgs = maxArgs;
        this.argName = argName;
        this.argsRequired = argsRequired;
    }

    private static String filename() {
        return FILENAME;
    }

    private static void addTopLevelCommand(CommandLineParam command) {
        TOP_LEVEL_COMMANDS.put(command.toString(), command);
    }

    public abstract DroidCommand getCommand(CommandFactory var1, CommandLine var2) throws CommandLineException;

    public String toString() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    Option newOption() {
        Option option = new Option(this.shortName, this.longName, this.maxArgs != 0, I18N.getResource(this.resourceKey));
        option.setArgs(this.maxArgs == -1 ? -2 : this.maxArgs);
        if (this.maxArgs != 0) {
            option.setOptionalArg(!this.argsRequired);
        }
        option.setArgName(this.argName);
        return option;
    }

    private static String filters() {
        return "filter ...";
    }

    public static Options options() {
        Options options = new Options();
        OptionGroup topGroup = new OptionGroup();
        for (CommandLineParam param : TOP_LEVEL_COMMANDS.values()) {
            topGroup.addOption(param.newOption());
        }
        options.addOption(PROFILES.newOption());
        options.addOption(REPORT_NAME.newOption());
        options.addOption(REPORT_OUTPUT_TYPE.newOption());
        options.addOption(SIGNATURE_FILE.newOption());
        options.addOption(CONTAINER_SIGNATURE_FILE.newOption());
        options.addOption(EXTENSION_LIST.newOption());
        options.addOption(ARCHIVES.newOption());
        options.addOption(ARCHIVE_TYPES.newOption());
        options.addOption(WEB_ARCHIVES.newOption());
        options.addOption(WEB_ARCHIVE_TYPES.newOption());
        options.addOption(RECURSIVE.newOption());
        options.addOption(QUIET.newOption());
        options.addOption(BOM.newOption());
        OptionGroup filterOptions = new OptionGroup();
        filterOptions.addOption(ALL_FILTER.newOption());
        filterOptions.addOption(ANY_FILTER.newOption());
        options.addOptionGroup(filterOptions);
        options.addOptionGroup(topGroup);
        return options;
    }

    public static Options singleOptions() {
        Options options = new Options();
        options.addOption(CHECK_SIGNATURE_UPDATE.newOption());
        options.addOption(DOWNLOAD_SIGNATURE_UPDATE.newOption());
        options.addOption(HELP.newOption());
        options.addOption(LIST_REPORTS.newOption());
        options.addOption(CONFIGURE_DEFAULT_SIGNATURE_VERSION.newOption());
        options.addOption(VERSION.newOption());
        options.addOption(DEFAULT_SIGNATURE_VERSION.newOption());
        options.addOption(LIST_SIGNATURE_VERSIONS.newOption());
        return options;
    }

    public static Options noProfileRunSubOptions() {
        Options options = new Options();
        options.addOption(SIGNATURE_FILE.newOption());
        options.addOption(CONTAINER_SIGNATURE_FILE.newOption());
        options.addOption(EXTENSION_LIST.newOption());
        options.addOption(ARCHIVES.newOption());
        options.addOption(ARCHIVE_TYPES.newOption());
        options.addOption(WEB_ARCHIVES.newOption());
        options.addOption(WEB_ARCHIVE_TYPES.newOption());
        options.addOption(RECURSIVE.newOption());
        options.addOption(QUIET.newOption());
        return options;
    }

    public static Options profileRunSubOptions() {
        Options options = new Options();
        options.addOption(PROFILES.newOption());
        options.addOption(RECURSIVE.newOption());
        options.addOption(QUIET.newOption());
        return options;
    }

    public static Options exportSubOptions() {
        Options options = new Options();
        options.addOption(PROFILES.newOption());
        options.addOption(ANY_FILTER.newOption());
        options.addOption(ALL_FILTER.newOption());
        options.addOption(BOM.newOption());
        return options;
    }

    public static Options reportSubOptions() {
        Options options = new Options();
        options.addOption(PROFILES.newOption());
        options.addOption(REPORT_NAME.newOption());
        options.addOption(REPORT_OUTPUT_TYPE.newOption());
        return options;
    }

    public static Options getOptions(CommandLineParam commandLineParam) {
        Options options = new Options();
        options.addOption(commandLineParam.newOption());
        return options;
    }

    static {
        TOP_LEVEL_COMMANDS = new HashMap<String, CommandLineParam>();
        CommandLineParam.addTopLevelCommand(HELP);
        CommandLineParam.addTopLevelCommand(VERSION);
        CommandLineParam.addTopLevelCommand(EXPORT_ONE_ROW_PER_FILE);
        CommandLineParam.addTopLevelCommand(EXPORT_ONE_ROW_PER_FORMAT);
        CommandLineParam.addTopLevelCommand(REPORT);
        CommandLineParam.addTopLevelCommand(LIST_FILTER_FIELD);
        CommandLineParam.addTopLevelCommand(RUN_PROFILE);
        CommandLineParam.addTopLevelCommand(RUN_NO_PROFILE);
        CommandLineParam.addTopLevelCommand(CHECK_SIGNATURE_UPDATE);
        CommandLineParam.addTopLevelCommand(DOWNLOAD_SIGNATURE_UPDATE);
        CommandLineParam.addTopLevelCommand(DEFAULT_SIGNATURE_VERSION);
        CommandLineParam.addTopLevelCommand(CONFIGURE_DEFAULT_SIGNATURE_VERSION);
        CommandLineParam.addTopLevelCommand(LIST_SIGNATURE_VERSIONS);
        CommandLineParam.addTopLevelCommand(LIST_REPORTS);
    }
}

