/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.archive.ArchiveConfiguration;
import uk.gov.nationalarchives.droid.command.archive.ArchiveContentIdentifier;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.TarEntryIdentificationRequest;

public class TarArchiveContentIdentifier
extends ArchiveContentIdentifier {
    public TarArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1, ArchiveConfiguration archiveConfiguration) {
        super(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash, archiveConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = this.makeContainerURI("tar", request.getFileName());
        this.setSlash1("");
        InputStream tarIn = null;
        try {
            tarIn = request.getSourceInputStream();
            try (TarArchiveInputStream in = new TarArchiveInputStream(tarIn);){
                TarArchiveEntry entry = null;
                while ((entry = in.getNextTarEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    RequestMetaData metaData = new RequestMetaData(Long.valueOf(entry.getSize()), Long.valueOf(2L), name);
                    RequestIdentifier identifier = new RequestIdentifier(uri);
                    TarEntryIdentificationRequest tarRequest = new TarEntryIdentificationRequest(metaData, identifier, this.getTmpDir());
                    this.expandContainer((IdentificationRequest)tarRequest, (InputStream)in, newPath);
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe + " (" + newPath + ")");
        }
        finally {
            if (tarIn != null) {
                try {
                    tarIn.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
        }
    }
}

