/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.util.FileUtil;

@XmlRootElement(name="File")
public class FileProfileResource
extends AbstractProfileResource {
    FileProfileResource() {
    }

    public FileProfileResource(Path file) {
        this.setUri(file.toUri());
        this.setName(FileUtil.fileName(file));
        this.setSize(file);
        FileTime lastModified = FileUtil.lastModifiedQuietly(file);
        this.setLastModifiedDate(lastModified == null ? new Date(0L) : new Date(lastModified.toMillis()));
        this.setExtension(ResourceUtils.getExtension((String)FileUtil.fileName(file)));
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void setSize(Path filePath) {
        this.setSize(FileUtil.sizeQuietly(filePath));
    }
}

