/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterValue;
import uk.gov.nationalarchives.droid.profile.FilterCriterionImpl;

@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterImpl
implements Cloneable,
Filter {
    private List<FilterCriterionImpl> unmashalingCriteriaList;
    private boolean unmarshalingInprogress;
    @XmlElement(name="Enabled", required=true)
    private boolean enabled;
    @XmlElement(name="Narrowed", required=true)
    private boolean narrowed;
    private Map<Integer, FilterCriterionImpl> filterCriteriaMap = new TreeMap<Integer, FilterCriterionImpl>();

    public FilterImpl() {
    }

    public FilterImpl(List<FilterCriterionImpl> criteria, boolean enabled, boolean narrowed) {
        this.setCriteria(criteria);
        this.setEnabled(enabled);
        this.setNarrowed(narrowed);
    }

    public List<FilterCriterion> getCriteria() {
        return new ArrayList<FilterCriterion>(this.filterCriteriaMap.values());
    }

    @XmlElement(name="Criteria", required=true)
    List<FilterCriterionImpl> getFilterCriteria() {
        if (this.unmarshalingInprogress) {
            return this.unmashalingCriteriaList;
        }
        return Collections.unmodifiableList(new ArrayList<FilterCriterionImpl>(this.filterCriteriaMap.values()));
    }

    void beforeUnmarshal(Unmarshaller u, Object parent) {
        this.unmarshalingInprogress = true;
        this.unmashalingCriteriaList = new ArrayList<FilterCriterionImpl>();
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        if (!this.unmarshalingInprogress || this.unmashalingCriteriaList == null) {
            throw new RuntimeException("unmarshalling is not in progress.");
        }
        this.filterCriteriaMap = new TreeMap<Integer, FilterCriterionImpl>();
        int index = 0;
        for (FilterCriterionImpl criterion : this.unmashalingCriteriaList) {
            this.filterCriteriaMap.put(index++, criterion);
        }
        this.unmashalingCriteriaList = null;
        this.unmarshalingInprogress = false;
    }

    public void setCriteria(List<FilterCriterionImpl> criteria) {
        int index = 0;
        for (FilterCriterionImpl criterion : criteria) {
            this.filterCriteriaMap.put(index++, criterion);
        }
    }

    public void addFilterCiterion(FilterCriterionImpl filterCriteria, int index) {
        if (this.getFilterCriterion(index) == null) {
            this.filterCriteriaMap.put(index, filterCriteria);
        } else {
            this.filterCriteriaMap.remove(index);
            this.filterCriteriaMap.put(index, filterCriteria);
        }
    }

    public void removeFilterCriterion(int rowNumber) {
        this.filterCriteriaMap.remove(rowNumber);
    }

    public Map<Integer, FilterCriterionImpl> getFilterCriteriaMap() {
        return this.filterCriteriaMap;
    }

    private void setFilterCriteriaMap(Map<Integer, FilterCriterionImpl> filterCriteriaMap) {
        this.filterCriteriaMap = filterCriteriaMap;
    }

    public FilterCriterionImpl getFilterCriterion(int rowNumber) {
        return this.filterCriteriaMap.get(rowNumber);
    }

    public Filter clone() {
        TreeMap<Integer, FilterCriterionImpl> clonedFilterCriteriaMap = new TreeMap<Integer, FilterCriterionImpl>();
        try {
            super.clone();
            FilterImpl clone = new FilterImpl();
            for (int i = 0; i < this.filterCriteriaMap.size(); ++i) {
                FilterCriterionImpl cloneFilterCriteria = new FilterCriterionImpl();
                FilterCriterionImpl filterCriteria = this.filterCriteriaMap.get(i);
                cloneFilterCriteria.setField(filterCriteria.getField());
                cloneFilterCriteria.setOperator(filterCriteria.getOperator());
                cloneFilterCriteria.setValueFreeText(new String(filterCriteria.getValueFreeText()));
                cloneFilterCriteria.setRowNumber(new Integer(filterCriteria.getRowNumber()));
                List<FilterValue> selectedValues = filterCriteria.getSelectedValues();
                if (selectedValues != null) {
                    ArrayList<FilterValue> clonedSelectedValues = new ArrayList<FilterValue>();
                    for (int j = 0; j < selectedValues.size(); ++j) {
                        FilterValue values = selectedValues.get(j);
                        FilterValue clonedValues = new FilterValue(values.getId(), values.getDescription(), values.getQueryParameter());
                        clonedSelectedValues.add(clonedValues);
                    }
                    cloneFilterCriteria.setSelectedValues(clonedSelectedValues);
                }
                clonedFilterCriteriaMap.put(i, cloneFilterCriteria);
            }
            clone.setFilterCriteriaMap(clonedFilterCriteriaMap);
            clone.setEnabled(new Boolean(this.enabled));
            clone.setNarrowed(new Boolean(this.narrowed));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isNarrowed() {
        return this.narrowed;
    }

    public void setNarrowed(boolean narrowed) {
        this.narrowed = narrowed;
    }

    public boolean hasCriteria() {
        boolean hasCriteria = false;
        if (this.filterCriteriaMap != null && !this.filterCriteriaMap.isEmpty()) {
            hasCriteria = true;
        }
        return hasCriteria;
    }

    public int getNumberOfFilterCriterion() {
        return this.filterCriteriaMap.size();
    }
}

