/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.FilterSpec;
import uk.gov.nationalarchives.droid.profile.FilterSpecDao;

public class JaxbFilterSpecDao
implements FilterSpecDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FilterSpec.class});

    @Override
    public FilterImpl loadFilter(InputStream in) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            FilterSpec spec = (FilterSpec)unmarshaller.unmarshal(in);
            return spec.getFilter();
        }
        catch (JAXBException e) {
            this.log.error(e.getErrorCode(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveFilter(FilterImpl filter, OutputStream output) {
        BufferedOutputStream out = null;
        try {
            Marshaller m = this.context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            out = new BufferedOutputStream(output);
            FilterSpec spec = new FilterSpec(filter);
            m.marshal((Object)spec, (OutputStream)out);
            this.closeOutputStream(out);
            return;
        }
        catch (PropertyException e) {
            try {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
                catch (JAXBException e2) {
                    this.log.error(e2.getErrorCode(), (Throwable)e2);
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                this.closeOutputStream(out);
                throw throwable;
            }
        }
    }

    private void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                this.log.error("Error closing output stream: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

