/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.map.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.profile.ProfileDiskAction;
import uk.gov.nationalarchives.droid.profile.ProfileException;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceLocator;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.results.handlers.JDBCBatchResultHandlerDao;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class ProfileContextLocator {
    private static final String HIBERNATE_GENERATE_DDL = "hibernate.generateDdl";
    private static final String DATABASE_URL = "datasource.url";
    private static final String CREATE_URL = "datasource.createUrl";
    private static final String HIBERNATE_CREATE = "hibernate.hbm2ddl.auto";
    private static final String BLANK_PROFILE = "profile.template";
    private static final String SIG_PROFILE = "profile\\.\\d+\\.template";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DroidGlobalConfig globalConfig;
    private Map<String, ProfileInstance> profileInstances = LazyMap.lazyMap(new HashMap(), (Transformer)new ProfileTransformer());
    private ProfileInstanceLocator profileInstanceLocator;

    public ProfileContextLocator() {
    }

    public ProfileContextLocator(DroidGlobalConfig config, ProfileInstanceLocator instanceLocator) {
        this.setGlobalConfig(config);
        this.setProfileInstanceLocator(instanceLocator);
    }

    public ProfileInstance getProfileInstance(String id) {
        return this.profileInstances.get(id);
    }

    public void addProfileContext(ProfileInstance profileInstance) {
        this.profileInstances.put(profileInstance.getUuid(), profileInstance);
    }

    public void removeProfileContext(String id) {
        this.profileInstances.remove(id);
        this.profileInstanceLocator.closeProfileInstance(id);
    }

    public void freezeDatabase(String profileId) {
        this.profileInstanceLocator.freezeDatabase(profileId);
    }

    public void thawDatabase(String profileId) {
        this.profileInstanceLocator.thawDatabase(profileId);
    }

    public ProfileInstanceManager openProfileInstanceManager(ProfileInstance profile) {
        boolean newDatabase;
        Path profileHome = this.globalConfig.getProfilesDir().resolve(profile.getUuid());
        Path databasePath = profileHome.resolve("db");
        Path signatureFile = profileHome.resolve(profile.getSignatureFileName());
        Path containerSignatureFile = profileHome.resolve(profile.getContainerSignatureFileName());
        Path submissionQueueFile = profileHome.resolve("submissionQueue.xml");
        Properties props = new Properties();
        props.setProperty("defaultThrottle", String.valueOf(profile.getThrottle()));
        props.setProperty("signatureFilePath", signatureFile.toAbsolutePath().toString());
        props.setProperty("submissionQueueFile", submissionQueueFile.toAbsolutePath().toString());
        props.setProperty("tempDirLocation", this.globalConfig.getTempDir().toAbsolutePath().toString());
        props.setProperty("profileHome", profileHome.toAbsolutePath().toString());
        props.setProperty("containerSigPath", containerSignatureFile.toAbsolutePath().toString());
        props.setProperty("processTar", String.valueOf(profile.getProcessTarFiles()));
        props.setProperty("processZip", String.valueOf(profile.getProcessZipFiles()));
        props.setProperty("processGzip", String.valueOf(profile.getProcessGzipFiles()));
        props.setProperty("processRar", String.valueOf(profile.getProcessRarFiles()));
        props.setProperty("process7zip", String.valueOf(profile.getProcess7zipFiles()));
        props.setProperty("processIso", String.valueOf(profile.getProcessIsoFiles()));
        props.setProperty("processBzip2", String.valueOf(profile.getProcessBzip2Files()));
        props.setProperty("processArc", String.valueOf(profile.getProcessArcFiles()));
        props.setProperty("processWarc", String.valueOf(profile.getProcessWarcFiles()));
        props.setProperty("generateHash", String.valueOf(profile.getGenerateHash()));
        props.setProperty("hashAlgorithm", String.valueOf(profile.getHashAlgorithm()));
        props.setProperty("maxBytesToScan", String.valueOf(profile.getMaxBytesToScan()));
        props.setProperty("matchAllExtensions", String.valueOf(profile.getMatchAllExtensions()));
        String createUrl = this.globalConfig.getProperties().getString("database.createUrl");
        if (createUrl == null || createUrl.isEmpty()) {
            createUrl = "{none}";
        }
        props.setProperty(CREATE_URL, createUrl);
        props.setProperty(DATABASE_URL, String.format("jdbc:derby:%s", databasePath.toAbsolutePath().toString()));
        TemplateStatus status = null;
        boolean bl = newDatabase = !Files.exists(databasePath, new LinkOption[0]);
        if (newDatabase) {
            Path profileTemplate = this.getProfileTemplateFile(profile);
            status = this.getTemplateStatus(profileTemplate);
            status = this.setupDatabaseTemplate(status, profileTemplate, databasePath);
        }
        if (status == TemplateStatus.NO_TEMPLATE) {
            JDBCBatchResultHandlerDao.setIsFreshTemplate(true);
        }
        ProfileInstanceManager profileManager = this.profileInstanceLocator.getProfileInstanceManager(profile, props);
        JDBCBatchResultHandlerDao.setIsFreshTemplate(false);
        if (newDatabase) {
            this.generateNewDatabaseAndTemplates(profile, profileManager, databasePath, signatureFile, status);
        }
        return profileManager;
    }

    private void setCreateSchemaProperties(boolean create, Properties props) {
        if (create) {
            props.setProperty(HIBERNATE_GENERATE_DDL, "true");
            props.setProperty(HIBERNATE_CREATE, "create");
        } else {
            props.setProperty(HIBERNATE_CREATE, "none");
            props.setProperty(HIBERNATE_GENERATE_DDL, "false");
        }
    }

    private TemplateStatus setupDatabaseTemplate(TemplateStatus status, Path profileTemplate, Path databasePath) {
        TemplateStatus result = status;
        if (status != TemplateStatus.NO_TEMPLATE) {
            try {
                this.unpackProfileTemplate(profileTemplate, databasePath);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result = TemplateStatus.NO_TEMPLATE;
            }
        }
        return result;
    }

    private void generateNewDatabaseAndTemplates(ProfileInstance profile, ProfileInstanceManager profileManager, Path databasePath, Path signatureFile, TemplateStatus status) {
        if (status == TemplateStatus.NO_TEMPLATE) {
            this.freezeDatabase(profile.getUuid());
            this.packProfileTemplate(databasePath, this.getTemplateFile(BLANK_PROFILE));
            this.thawDatabase(profile.getUuid());
        }
        if (status != TemplateStatus.SIGNATURE_TEMPLATE) {
            try {
                profileManager.initProfile(signatureFile.toUri());
                String name = this.getTemplateNameForSignatureVersion(profile.getSignatureFileVersion());
                Path templateFile = this.getTemplateFile(name);
                this.freezeDatabase(profile.getUuid());
                this.packProfileTemplate(databasePath, templateFile);
                this.thawDatabase(profile.getUuid());
            }
            catch (SignatureFileException e) {
                String message = "Error reading signature file";
                this.log.error(message, (Throwable)e);
                throw new ProfileException(message, e);
            }
        }
    }

    private TemplateStatus getTemplateStatus(Path profileTemplateFile) {
        TemplateStatus status = TemplateStatus.NO_TEMPLATE;
        if (profileTemplateFile != null) {
            if (BLANK_PROFILE.equals(FileUtil.fileName(profileTemplateFile))) {
                status = TemplateStatus.BLANK_TEMPLATE;
            } else if (FileUtil.fileName(profileTemplateFile).matches(SIG_PROFILE)) {
                status = TemplateStatus.SIGNATURE_TEMPLATE;
            }
        }
        return status;
    }

    private Path getProfileTemplateFile(ProfileInstance profile) {
        String sigTemplateName = this.getTemplateNameForSignatureVersion(profile.getSignatureFileVersion());
        Path profileTemplate = this.getTemplateFile(sigTemplateName);
        if (!Files.exists(profileTemplate, new LinkOption[0]) && !Files.exists(profileTemplate = this.getTemplateFile(BLANK_PROFILE), new LinkOption[0])) {
            profileTemplate = null;
        }
        return profileTemplate;
    }

    private String getTemplateNameForSignatureVersion(Integer signatureVersion) {
        return String.format("profile.%d.template", signatureVersion);
    }

    private Path getTemplateFile(String templateFileName) {
        Path templateDir = this.globalConfig.getProfileTemplateDir();
        return templateDir.resolve(templateFileName);
    }

    private void unpackProfileTemplate(Path profileTemplate, Path copyToDirectory) throws IOException {
        Files.createDirectories(copyToDirectory, new FileAttribute[0]);
        ProfileDiskAction unpacker = new ProfileDiskAction();
        ProgressObserver observe = new ProgressObserver(){

            @Override
            public void onProgress(Integer progress) {
            }
        };
        unpacker.load(profileTemplate, copyToDirectory, observe);
    }

    private void packProfileTemplate(Path databaseDir, Path profileTemplate) {
        ProfileDiskAction packer = new ProfileDiskAction();
        ProgressObserver observe = new ProgressObserver(){

            @Override
            public void onProgress(Integer progress) {
            }
        };
        try {
            packer.saveProfile(databaseDir, profileTemplate, observe);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setProfileInstanceLocator(ProfileInstanceLocator profileInstanceLocator) {
        this.profileInstanceLocator = profileInstanceLocator;
    }

    public boolean hasProfileContext(String profileName) {
        return this.profileInstances.containsKey(profileName);
    }

    public void setGlobalConfig(DroidGlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    private final class ProfileTransformer
    implements Transformer {
        private ProfileTransformer() {
        }

        public Object transform(Object id) {
            ProfileInstance profileInstance = new ProfileInstance(ProfileState.INITIALISING);
            profileInstance.setUuid((String)id);
            profileInstance.setThrottle(ProfileContextLocator.this.globalConfig.getProperties().getInt(DroidGlobalProperty.DEFAULT_THROTTLE.getName()));
            profileInstance.setHashAlgorithm(ProfileContextLocator.this.globalConfig.getProperties().getString(DroidGlobalProperty.HASH_ALGORITHM.getName()));
            profileInstance.setGenerateHash(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.GENERATE_HASH.getName()));
            profileInstance.setProcessTarFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_TAR.getName()));
            profileInstance.setProcessZipFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_ZIP.getName()));
            profileInstance.setProcessGzipFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_GZIP.getName()));
            profileInstance.setProcessRarFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_RAR.getName()));
            profileInstance.setProcess7zipFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_7ZIP.getName()));
            profileInstance.setProcessIsoFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_ISO.getName()));
            profileInstance.setProcessBzip2Files(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_BZIP2.getName()));
            profileInstance.setProcessArcFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_ARC.getName()));
            profileInstance.setProcessWarcFiles(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.PROCESS_WARC.getName()));
            profileInstance.setMaxBytesToScan(ProfileContextLocator.this.globalConfig.getProperties().getLong(DroidGlobalProperty.MAX_BYTES_TO_SCAN.getName()));
            profileInstance.setMatchAllExtensions(ProfileContextLocator.this.globalConfig.getProperties().getBoolean(DroidGlobalProperty.EXTENSION_ALL.getName()));
            return profileInstance;
        }
    }

    private static enum TemplateStatus {
        NO_TEMPLATE,
        BLANK_TEMPLATE,
        SIGNATURE_TEMPLATE;

    }
}

