/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class ProfileDiskAction {
    private static final int UNITY_PERCENT = 100;
    private static final int BUFFER_SIZE = 8192;
    private static final char FORWARD_SLASH = '/';
    private static final char BACKWARD_SLASH = '\\';
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfile(Path baseDir, Path destination, ProgressObserver callback) throws IOException {
        this.log.info(String.format("Saving profile [%s] to [%s]", baseDir, destination));
        Path output = destination.resolveSibling(destination.getFileName().toString() + ".tmp~");
        if (!FileUtil.deleteQuietly(output)) {
            String message = String.format("Could not delete original profile file: %s. Will try to delete on exit.", output.toAbsolutePath().toString());
            this.log.warn(message);
            output.toFile().deleteOnExit();
        }
        if (!Files.exists(output, new LinkOption[0])) {
            try {
                Files.createFile(output, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                throw new IOException(String.format("Error creating tmp file [%s]", output));
            }
        }
        try (ProfileWalker profileWalker = new ProfileWalker(baseDir, output, callback);){
            profileWalker.save();
            callback.onProgress(100);
            if (Files.exists(destination, new LinkOption[0]) && !FileUtil.deleteQuietly(destination)) {
                throw new IOException(String.format("Error removing old file [%s]", destination));
            }
            if (!Files.exists(Files.move(output, destination, new CopyOption[0]), new LinkOption[0])) {
                throw new IOException(String.format("Error creating saved file [%s]", destination));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Path source, Path destination, ProgressObserver observer) throws IOException {
        if (Files.exists(destination, new LinkOption[0])) {
            FileUtil.deleteQuietly(destination);
        }
        try (ZipFile zip = new ZipFile(source.toFile());){
            long totalSize = 0L;
            Enumeration it = zip.entries();
            while (it.hasMoreElements()) {
                ZipEntry e = (ZipEntry)it.nextElement();
                totalSize += e.getSize();
            }
            long bytesSoFar = 0L;
            Enumeration it2 = zip.entries();
            while (it2.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)it2.nextElement();
                String entryName = this.getPlatformSpecificPath(entry.getName());
                Path expandedFile = destination.resolve(entryName);
                Files.createDirectories(expandedFile.getParent(), new FileAttribute[0]);
                try (BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
                     BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(expandedFile, new OpenOption[0]));){
                    bytesSoFar = this.readFile(in, out, observer, bytesSoFar, totalSize);
                }
            }
            observer.onProgress(100);
        }
    }

    private String getPlatformSpecificPath(String path) {
        String platformPath = null;
        switch (File.separatorChar) {
            case '\\': {
                platformPath = path.replace('/', '\\');
                break;
            }
            case '/': {
                platformPath = path.replace('\\', '/');
                break;
            }
            default: {
                platformPath = path.replaceAll("[\\\\/]", File.separator);
            }
        }
        return platformPath;
    }

    private String getUnixStylePath(String path) {
        return path.replace('\\', '/');
    }

    private long readFile(InputStream in, OutputStream out, ProgressObserver observer, long bytesSoFar, long totalSize) throws IOException {
        long totalBytesRead = bytesSoFar;
        int bytesIn = 0;
        byte[] buffer = new byte[8192];
        while ((bytesIn = in.read(buffer)) != -1) {
            int progressSoFar = (int)(100L * (totalBytesRead += (long)bytesIn) / totalSize);
            observer.onProgress(progressSoFar);
            out.write(buffer, 0, bytesIn);
        }
        return totalBytesRead;
    }

    private long writeFile(InputStream in, ZipOutputStream out, ProgressObserver observer, long bytesSoFar, long totalSize) throws IOException {
        long totalBytesWritten = bytesSoFar;
        int bytesIn = 0;
        byte[] buffer = new byte[8192];
        while ((bytesIn = in.read(buffer)) != -1) {
            int progressSoFar = (int)(100L * (totalBytesWritten += (long)bytesIn) / totalSize);
            observer.onProgress(progressSoFar);
            out.write(buffer, 0, bytesIn);
        }
        return totalBytesWritten;
    }

    private final class ProfileWalker
    extends DirectoryWalker {
        private Path destination;
        private ZipOutputStream out;
        private Path source;
        private ProgressObserver callback;
        private final long bytesToProcess;
        private long bytesProcessed;

        public ProfileWalker(Path source, Path destination, ProgressObserver callback) {
            this.source = source;
            this.destination = destination;
            this.callback = callback;
            this.bytesToProcess = FileUtil.sizeQuietly(source);
        }

        public void close() throws IOException {
            this.out.close();
        }

        protected void handleStart(File startDirectory, Collection results) throws IOException {
            this.out = new ZipOutputStream(Files.newOutputStream(this.destination, new OpenOption[0]));
            this.out.setMethod(8);
        }

        protected void handleEnd(Collection results) throws IOException {
            this.out.close();
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) {
            return true;
        }

        protected void handleDirectoryStart(File directory, int depth, Collection results) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleFile(File file, int depth, Collection results) throws IOException {
            String entryPath = ProfileDiskAction.this.getUnixStylePath(StringUtils.substringAfter((String)file.getAbsolutePath(), (String)(this.source.toAbsolutePath().toString() + File.separator)));
            ZipEntry entry = new ZipEntry(entryPath);
            this.out.putNextEntry(entry);
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                this.bytesProcessed = ProfileDiskAction.this.writeFile(in, this.out, this.callback, this.bytesProcessed, this.bytesToProcess);
            }
            finally {
                this.out.closeEntry();
            }
        }

        protected void save() throws IOException {
            this.walk(this.source.toFile(), Collections.EMPTY_LIST);
        }
    }
}

