/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.control.PauseAspect;
import uk.gov.nationalarchives.droid.core.interfaces.control.ThreadWaitingHandler;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.export.interfaces.ItemReader;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLDao;
import uk.gov.nationalarchives.droid.planet.xml.dao.PlanetsXMLData;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileDao;
import uk.gov.nationalarchives.droid.profile.ProfileException;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileResultObserver;
import uk.gov.nationalarchives.droid.profile.ProgressState;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.profile.referencedata.ReferenceData;
import uk.gov.nationalarchives.droid.profile.referencedata.ReferenceDataService;
import uk.gov.nationalarchives.droid.profile.throttle.SubmissionThrottle;
import uk.gov.nationalarchives.droid.report.dao.GroupByField;
import uk.gov.nationalarchives.droid.report.dao.ReportDao;
import uk.gov.nationalarchives.droid.report.dao.ReportFieldEnum;
import uk.gov.nationalarchives.droid.report.dao.ReportLineItem;
import uk.gov.nationalarchives.droid.results.handlers.ProgressMonitor;
import uk.gov.nationalarchives.droid.signature.FormatCallback;
import uk.gov.nationalarchives.droid.signature.SaxSignatureFileParser;
import uk.gov.nationalarchives.droid.submitter.ProfileSpecJobCounter;
import uk.gov.nationalarchives.droid.submitter.ProfileSpecWalker;
import uk.gov.nationalarchives.droid.submitter.ProfileWalkState;
import uk.gov.nationalarchives.droid.submitter.ProfileWalkerDao;

public class ProfileInstanceManagerImpl
implements ProfileInstanceManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ProfileDao profileDao;
    private ReportDao reportDao;
    private PlanetsXMLDao planetsDao;
    private ReferenceDataService referenceDataService;
    private ProfileInstance profileInstance;
    private ProfileSpecWalker specWalker;
    private Future<?> task;
    private AsynchDroid submissionGateway;
    private ProfileWalkerDao profileWalkerDao;
    private ProfileWalkState walkState;
    private boolean inError;
    private PauseAspect pauseControl;
    private Semaphore submitterPermits = new Semaphore(1);
    private ThreadLocal<String> submitterThreadId = new ThreadLocal();
    private volatile String pausedThreadId;

    public ProfileInstanceManagerImpl() {
    }

    public ProfileInstanceManagerImpl(ProfileDao profileDao, ReportDao reportDao, PlanetsXMLDao planetsDao, ReferenceDataService referenceDataService, ProfileInstance profileInstance, ProfileSpecWalker specWalker, AsynchDroid submission, ProfileWalkerDao profileWalkerDao) {
        this.setProfileDao(profileDao);
        this.setReportDao(reportDao);
        this.setPlanetsDao(planetsDao);
        this.setReferenceDataService(referenceDataService);
        this.setProfile(profileInstance);
        this.setSpecWalker(specWalker);
        this.setSubmissionGateway(submission);
        this.setProfileWalkerDao(profileWalkerDao);
    }

    @Override
    public void cancel() {
        this.log.info("**** Profile Cancelled ****");
        this.task.cancel(false);
    }

    @Override
    public void initProfile(URI signatureFileUri) throws SignatureFileException {
        SaxSignatureFileParser sigParser = new SaxSignatureFileParser(signatureFileUri);
        this.profileDao.saveFormat(Format.NULL);
        FormatCallback callback = new FormatCallback(){

            @Override
            public void onFormat(Format format) {
                ProfileInstanceManagerImpl.this.profileDao.saveFormat(format);
            }
        };
        sigParser.formats(callback);
        this.profileDao.initialise();
    }

    @Override
    public void setProfile(ProfileInstance profile) {
        this.profileInstance = profile;
    }

    @Override
    public void pause() {
        this.pauseControl.setThreadWaitingHandler(new ThreadWaitingHandler(){

            public void onThreadWaiting() {
                ProfileInstanceManagerImpl.this.pausedThreadId = (String)ProfileInstanceManagerImpl.this.submitterThreadId.get();
                if (ProfileInstanceManagerImpl.this.profileInstance.getUuid().equals(ProfileInstanceManagerImpl.this.pausedThreadId)) {
                    ProfileInstanceManagerImpl.this.pausedThreadId = (String)ProfileInstanceManagerImpl.this.submitterThreadId.get();
                    ProfileInstanceManagerImpl.this.submitterPermits.release();
                }
            }
        });
        this.pauseControl.pause();
        try {
            this.submitterPermits.acquire();
            this.submissionGateway.awaitIdle();
            this.profileInstance.stop();
            this.submissionGateway.save();
            ProgressState progressState = new ProgressState(this.getProgressMonitor().getTargetCount(), this.getProgressMonitor().getIdentificationCount());
            this.profileInstance.setProgress(progressState);
            this.profileWalkerDao.save(this.walkState);
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            this.submitterPermits.release();
        }
    }

    private void resume() {
        if (this.pausedThreadId != null) {
            this.submitterPermits.acquireUninterruptibly();
        }
        this.profileInstance.start();
        this.pauseControl.resume();
    }

    @Override
    public Future<?> start() throws IOException {
        if (!this.inError && this.walkState != null) {
            this.resume();
        } else {
            if (this.inError) {
                if (this.pausedThreadId != null) {
                    this.submitterPermits.acquireUninterruptibly();
                }
                this.pauseControl.resume();
            }
            this.inError = false;
            this.walkState = this.profileWalkerDao.load();
            this.submissionGateway.replay();
            this.profileInstance.start();
            ProfileSpecJobCounter counter = new ProfileSpecJobCounter(this.profileInstance.getProfileSpec());
            FutureTask<Long> countFuture = new FutureTask<Long>((Callable)counter){

                @Override
                protected void done() {
                    if (!this.isCancelled()) {
                        try {
                            ProfileInstanceManagerImpl.this.specWalker.getProgressMonitor().setTargetCount((Long)this.get());
                        }
                        catch (InterruptedException e) {
                            ProfileInstanceManagerImpl.this.log.debug(e.getMessage(), (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            ProfileInstanceManagerImpl.this.log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(countFuture);
            ExecutorService mainSubmitter = Executors.newSingleThreadExecutor();
            WalkerTask walk = new WalkerTask((Future<Long>)countFuture, counter);
            this.task = mainSubmitter.submit(walk);
            mainSubmitter.shutdown();
        }
        return this.task;
    }

    public void setProfileDao(ProfileDao profileDao) {
        this.profileDao = profileDao;
    }

    @Override
    public List<ProfileResourceNode> findRootProfileResourceNodes() {
        FilterImpl filter = this.profileInstance.getFilter();
        if (filter.isEnabled() && filter.hasCriteria()) {
            return this.findRootProfileResourceNodes(filter);
        }
        LinkedHashMap<URI, ProfileResourceNode> primordialNodes = new LinkedHashMap<URI, ProfileResourceNode>();
        for (AbstractProfileResource resource : this.profileInstance.getProfileSpec().getResources()) {
            ProfileResourceNode primordialNode = new ProfileResourceNode(resource.getUri());
            primordialNode.getMetaData().setResourceType(resource.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
            NodeMetaData metaData = primordialNode.getMetaData();
            metaData.setNodeStatus(NodeStatus.NOT_DONE);
            metaData.setName(resource.getUri().getPath());
            primordialNodes.put(resource.getUri(), primordialNode);
        }
        List<ProfileResourceNode> processedNodes = this.profileDao.findProfileResourceNodes(null);
        for (ProfileResourceNode node : processedNodes) {
            primordialNodes.put(node.getUri(), node);
        }
        return new ArrayList<ProfileResourceNode>(primordialNodes.values());
    }

    private List<ProfileResourceNode> findRootProfileResourceNodes(Filter filter) {
        LinkedHashMap<URI, ProfileResourceNode> primordialNodesAfterFilter = new LinkedHashMap<URI, ProfileResourceNode>();
        List<ProfileResourceNode> processedNodes = this.profileDao.findProfileResourceNodes(null, filter);
        for (ProfileResourceNode node : processedNodes) {
            primordialNodesAfterFilter.put(node.getUri(), node);
        }
        return new ArrayList<ProfileResourceNode>(primordialNodesAfterFilter.values());
    }

    @Override
    public List<ProfileResourceNode> findAllProfileResourceNodes(Long parentId) {
        FilterImpl filter = this.profileInstance.getFilter();
        if (filter.isEnabled() && filter.hasCriteria()) {
            return this.profileDao.findProfileResourceNodes(parentId, filter);
        }
        return this.profileDao.findProfileResourceNodes(parentId);
    }

    ProfileInstance getProfileInstance() {
        return this.profileInstance;
    }

    @Override
    public void setResultsObserver(ProfileResultObserver observer) {
        this.specWalker.getProgressMonitor().setResultObserver(observer);
    }

    @Override
    public List<Format> getAllFormats() {
        return this.profileDao.getAllFormats();
    }

    public void setReferenceDataService(ReferenceDataService referenceDataService) {
        this.referenceDataService = referenceDataService;
    }

    @Override
    public ReferenceData getReferenceData() {
        return this.referenceDataService.getReferenceData();
    }

    @Override
    public void setThrottleValue(int throttleValue) {
        SubmissionThrottle submissionThrottle = this.specWalker.getFileEventHandler().getSubmissionThrottle();
        submissionThrottle.setWaitMilliseconds(throttleValue);
        this.profileInstance.setThrottle(throttleValue);
    }

    @Override
    public ItemReader<ProfileResourceNode> getNodeItemReader() {
        return null;
    }

    @Override
    public PlanetsXMLData getPlanetsData() {
        return this.planetsDao.getDataForPlanetsXML(this.profileInstance.getFilter());
    }

    @Override
    public List<ReportLineItem> getReportData(Criterion filter, ReportFieldEnum reportField, List<GroupByField> groupByFields) {
        return this.reportDao.getReportData(filter, reportField, groupByFields);
    }

    public void setPlanetsDao(PlanetsXMLDao planetsDao) {
        this.planetsDao = planetsDao;
    }

    public void setReportDao(ReportDao reportDao) {
        this.reportDao = reportDao;
    }

    public void setPauseControl(PauseAspect pauseControl) {
        this.pauseControl = pauseControl;
    }

    public void setSubmissionGateway(AsynchDroid submissionGateway) {
        this.submissionGateway = submissionGateway;
    }

    public void setProfileWalkerDao(ProfileWalkerDao profileWalkerDao) {
        this.profileWalkerDao = profileWalkerDao;
    }

    public void setSpecWalker(ProfileSpecWalker specWalker) {
        this.specWalker = specWalker;
    }

    @Override
    public ProgressMonitor getProgressMonitor() {
        return this.specWalker.getProgressMonitor();
    }

    private final class WalkerTask
    implements Runnable {
        private ProfileSpecJobCounter counter;
        private Future<Long> countFuture;

        WalkerTask(Future<Long> countFuture, ProfileSpecJobCounter counter) {
            this.countFuture = countFuture;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                this.preWalk();
                ProfileInstanceManagerImpl.this.specWalker.walk(ProfileInstanceManagerImpl.this.profileInstance.getProfileSpec(), ProfileInstanceManagerImpl.this.walkState);
            }
            catch (InterruptedException e) {
                ProfileInstanceManagerImpl.this.log.debug(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                ProfileInstanceManagerImpl.this.inError = true;
                ProfileInstanceManagerImpl.this.log.error(e.getMessage(), (Throwable)e);
                throw new ProfileException(e);
            }
            finally {
                this.postWalk();
                this.counter.cancel();
                this.countFuture.cancel(false);
                if (!ProfileInstanceManagerImpl.this.inError) {
                    ProfileInstanceManagerImpl.this.profileInstance.finish();
                }
                ProfileInstanceManagerImpl.this.submissionGateway.save();
                ProfileInstanceManagerImpl.this.profileWalkerDao.delete();
            }
        }

        private void preWalk() throws InterruptedException {
            ProfileInstanceManagerImpl.this.submitterThreadId.set(ProfileInstanceManagerImpl.this.profileInstance.getUuid());
            ProfileInstanceManagerImpl.this.submitterPermits.acquire();
            ProgressMonitor progressMonitor = ProfileInstanceManagerImpl.this.specWalker.getProgressMonitor();
            ProgressState progress = ProfileInstanceManagerImpl.this.profileInstance.getProgress();
            if (progress != null) {
                progressMonitor.initialise(progress.getTarget(), progress.getCount());
            }
        }

        private void postWalk() {
            ProfileInstanceManagerImpl.this.submitterPermits.release();
            try {
                ProfileInstanceManagerImpl.this.submissionGateway.awaitFinished();
            }
            catch (InterruptedException e) {
                ProfileInstanceManagerImpl.this.log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }
}

