/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.profile.ProfileContextLocator;
import uk.gov.nationalarchives.droid.profile.ProfileDiskAction;
import uk.gov.nationalarchives.droid.profile.ProfileException;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileInstanceManager;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileManagerException;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileResultObserver;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;
import uk.gov.nationalarchives.droid.profile.ProfileSpecDao;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.profile.referencedata.ReferenceData;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class ProfileManagerImpl
implements ProfileManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ProfileContextLocator profileContextLocator;
    private ProfileSpecDao profileSpecDao;
    private ProfileDiskAction profileSaver;
    private SignatureManager signatureManager;
    private DroidGlobalConfig config;

    public ProfileManagerImpl() {
    }

    public ProfileManagerImpl(ProfileContextLocator contextLocator, ProfileSpecDao profileSpecDao, ProfileDiskAction diskAction, SignatureManager signatureManager, DroidGlobalConfig config) {
        this.setProfileContextLocator(contextLocator);
        this.setProfileSpecDao(profileSpecDao);
        this.setProfileDiskAction(diskAction);
        this.setSignatureManager(signatureManager);
        this.setConfig(config);
    }

    @Override
    public ProfileInstance createProfile(Map<SignatureType, SignatureFileInfo> sigFileInfos) throws ProfileManagerException {
        Map signatures = sigFileInfos;
        if (sigFileInfos == null) {
            try {
                signatures = this.signatureManager.getDefaultSignatures();
            }
            catch (SignatureFileException e) {
                throw new ProfileManagerException(e.getMessage());
            }
        }
        String profileId = String.valueOf(System.currentTimeMillis());
        this.log.info("Creating profile: " + profileId);
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        Path profileHomeDir = this.config.getProfilesDir().resolve(profile.getUuid());
        FileUtil.mkdirsQuietly(profileHomeDir);
        this.createProfileBinarySigFile((SignatureFileInfo)signatures.get(SignatureType.BINARY), profile, profileHomeDir);
        this.createProfileContainerSigFile((SignatureFileInfo)signatures.get(SignatureType.CONTAINER), profile, profileHomeDir);
        this.createProfileTextSigFile((SignatureFileInfo)signatures.get(SignatureType.TEXT), profile, profileHomeDir);
        profile.setUuid(profileId);
        profile.setProfileSpec(new ProfileSpec());
        this.profileSpecDao.saveProfile(profile, profileHomeDir);
        profile.setDirty(false);
        this.profileContextLocator.addProfileContext(profile);
        return profile;
    }

    private void createProfileBinarySigFile(SignatureFileInfo binarySigFile, ProfileInstance profile, Path profileHomeDir) {
        if (binarySigFile != null) {
            profile.setSignatureFileVersion(binarySigFile.getVersion());
            profile.setSignatureFileName(FileUtil.fileName(binarySigFile.getFile()));
            ProfileManagerImpl.copySignatureFile(binarySigFile.getFile(), profileHomeDir);
        }
    }

    private void createProfileContainerSigFile(SignatureFileInfo containerSigFile, ProfileInstance profile, Path profileHomeDir) {
        if (containerSigFile != null) {
            profile.setContainerSignatureFileName(FileUtil.fileName(containerSigFile.getFile()));
            profile.setContainerSignatureFileVersion(containerSigFile.getVersion());
            ProfileManagerImpl.copySignatureFile(containerSigFile.getFile(), profileHomeDir);
        }
    }

    private void createProfileTextSigFile(SignatureFileInfo textSigFile, ProfileInstance profile, Path profileHomeDir) {
        if (textSigFile != null) {
            profile.setTextSignatureFileName(FileUtil.fileName(textSigFile.getFile()));
            profile.setTextSignatureFileVersion(textSigFile.getVersion());
            ProfileManagerImpl.copySignatureFile(textSigFile.getFile(), profileHomeDir);
        }
    }

    private static void copySignatureFile(Path file, Path destDir) {
        try {
            Files.createDirectories(destDir, new FileAttribute[0]);
            Path destFile = destDir.resolve(file.getFileName());
            Files.copy(file, destFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new ProfileException(e.getMessage(), e);
        }
    }

    @Override
    public void closeProfile(String profileName) {
        this.log.info("Closing profile: " + profileName);
        this.profileContextLocator.removeProfileContext(profileName);
        if (!this.config.getProperties().getBoolean(DroidGlobalProperty.DEV_MODE.getName())) {
            Path profileHome = this.config.getProfilesDir().resolve(profileName);
            FileUtil.deleteQuietly(profileHome);
        }
    }

    @Override
    public ProfileInstance openProfile(String profileId) {
        this.log.info("Opening profile: " + profileId);
        if (!this.profileContextLocator.hasProfileContext(profileId)) {
            throw new IllegalArgumentException(String.format("No such profile id [%s]", profileId));
        }
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        this.profileContextLocator.openProfileInstanceManager(profile);
        profile.fireListeners();
        return profile;
    }

    @Override
    public void stop(String profileInstance) {
        this.log.info("Stopping profile: " + profileInstance);
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileInstance);
        profileInstanceManager.pause();
    }

    private ProfileInstanceManager getProfileInstanceManager(String profileInstance) {
        if (profileInstance == null) {
            String message = "Profile instance id was null";
            this.log.error(message);
            throw new ProfileException(message);
        }
        ProfileInstanceManager profileInstanceManager = this.profileContextLocator.openProfileInstanceManager(this.profileContextLocator.getProfileInstance(profileInstance));
        return profileInstanceManager;
    }

    @Override
    public Future<?> start(String profileId) throws IOException {
        this.log.info("Starting profile: " + profileId);
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        return profileInstanceManager.start();
    }

    @Override
    public List<ProfileResourceNode> findProfileResourceNodeAndImmediateChildren(String profileId, Long parentId) {
        this.log.debug(String.format(" **** Called findProfileResourceNodeAndImmediateChildren [%s] ****", profileId));
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        return profileInstanceManager.findAllProfileResourceNodes(parentId);
    }

    @Override
    public List<ProfileResourceNode> findRootNodes(String profileId) {
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        return profileInstanceManager.findRootProfileResourceNodes();
    }

    @Override
    public void setProgressObserver(String profileId, ProgressObserver progressObserver) {
        ProfileInstanceManager profileInstanceManager = this.getProfileInstanceManager(profileId);
        profileInstanceManager.getProgressMonitor().setPercentIncrementObserver(progressObserver);
    }

    public void setProfileSpecDao(ProfileSpecDao profileSpecDao) {
        this.profileSpecDao = profileSpecDao;
    }

    public void setProfileContextLocator(ProfileContextLocator profileContextLocator) {
        this.profileContextLocator = profileContextLocator;
    }

    @Override
    public void setResultsObserver(String profileUuid, ProfileResultObserver observer) {
        this.getProfileInstanceManager(profileUuid).setResultsObserver(observer);
    }

    @Override
    public void updateProfileSpec(String profileId, ProfileSpec profileSpec) {
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        profile.setProfileSpec(profileSpec);
        this.profileSpecDao.saveProfile(profile, this.getProfileHomeDir(profile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInstance save(String profileId, Path destination, ProgressObserver callback) throws IOException {
        this.log.info("Saving profile: " + profileId + " to " + destination.toAbsolutePath().toString());
        this.profileContextLocator.freezeDatabase(profileId);
        ProfileInstance profile = this.profileContextLocator.getProfileInstance(profileId);
        ProfileState oldState = profile.getState();
        profile.changeState(ProfileState.SAVING);
        try {
            Path output = destination != null ? destination : profile.getLoadedFrom();
            this.profileSpecDao.saveProfile(profile, this.getProfileHomeDir(profile));
            this.profileSaver.saveProfile(this.getProfileHomeDir(profile), output, callback);
            profile.setLoadedFrom(output);
            profile.setName(FilenameUtils.getBaseName((String)FileUtil.fileName(output)));
            profile.onSave();
        }
        finally {
            this.profileContextLocator.thawDatabase(profileId);
            profile.changeState(oldState);
        }
        return profile;
    }

    public void setProfileDiskAction(ProfileDiskAction profileDiskAction) {
        this.profileSaver = profileDiskAction;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ProfileInstance open(Path source, ProgressObserver observer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Format> getAllFormats(String profileId) {
        return this.getProfileInstanceManager(profileId).getAllFormats();
    }

    @Override
    public ReferenceData getReferenceData(String profileId) {
        return this.getProfileInstanceManager(profileId).getReferenceData();
    }

    @Override
    public void setThrottleValue(String uuid, int value) {
        this.getProfileInstanceManager(uuid).setThrottleValue(value);
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }

    private Path getProfileHomeDir(ProfileInstance profile) {
        return this.config.getProfilesDir().resolve(profile.getUuid());
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

