/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.datasource;

import com.zaxxer.hikari.HikariConfig;
import java.nio.file.Paths;
import java.sql.DriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import uk.gov.nationalarchives.droid.profile.datasource.DerbyPooledDataSource;

public class DerbyPooledDataSourceFactory
implements FactoryBean<DerbyPooledDataSource> {
    private static final String NO_CREATE_URL = "{none}";
    private String createUrl = "{none}";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HikariConfig config;

    public DerbyPooledDataSourceFactory() {
    }

    public DerbyPooledDataSourceFactory(HikariConfig config) {
        this.setConfig(config);
    }

    public DerbyPooledDataSourceFactory(HikariConfig config, String createUrl) {
        this.setConfig(config);
        this.setCreateUrl(createUrl);
    }

    public DerbyPooledDataSource getObject() throws Exception {
        String droidLogDir = System.getProperty("droidLogDir");
        System.setProperty("derby.stream.error.file", Paths.get(droidLogDir, "derby.log").toAbsolutePath().toString());
        this.log.debug(String.format("Booting database [%s]", this.config.getJdbcUrl()));
        String url = this.getCreateURL();
        String driverClassName = this.getDriverClassName();
        try {
            Class.forName(driverClassName);
            DriverManager.getConnection(url).close();
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Invalid driver class name: %s", driverClassName);
            this.log.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        return new DerbyPooledDataSource(this.config);
    }

    private String getDriverClassName() {
        return this.config.getDriverClassName();
    }

    private String getCreateURL() {
        String url = this.config.getJdbcUrl() + ";create=true";
        if (this.createUrl != null && !this.createUrl.isEmpty() && !NO_CREATE_URL.equals(this.createUrl)) {
            url = url + ";" + this.createUrl;
        }
        return url;
    }

    public void setCreateUrl(String createUrl) {
        this.createUrl = createUrl;
    }

    public void setConfig(HikariConfig config) {
        this.config = config;
    }

    public Class<?> getObjectType() {
        return DerbyPooledDataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

