/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.profile.referencedata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.profile.referencedata.ReferenceDataDao;

public class ReferenceDataDaoImpl
implements ReferenceDataDao {
    private static final String SELECT_FORMATS = "SELECT * FROM FORMAT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DataSource datasource;

    public ReferenceDataDaoImpl() {
    }

    public ReferenceDataDaoImpl(DataSource datasource) {
        this.setDatasource(datasource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Format> getFormats() {
        ArrayList<Format> formats = new ArrayList<Format>(2000);
        ResultSet results = null;
        PreparedStatement loadFormat = null;
        try {
            Connection conn = this.datasource.getConnection();
            try {
                loadFormat = conn.prepareStatement(SELECT_FORMATS);
                results = loadFormat.executeQuery();
                while (results.next()) {
                    formats.add(SqlUtils.buildFormat(results));
                }
            }
            finally {
                results.close();
                loadFormat.close();
                conn.close();
            }
        }
        catch (SQLException e) {
            this.log.error("A database exception occurred getting all formats.", (Throwable)e);
        }
        return formats;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }
}

