/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.results.handlers;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.SqlUtils;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.results.handlers.ResultHandlerDao;

public class JDBCBatchResultHandlerDao
implements ResultHandlerDao {
    public static final int BATCH_LIMIT = 100;
    private static final NodeInfo COMMIT_SO_FAR = new NodeInfo(null, false);
    private static final String INSERT_PROFILE_RESOURCE_NODE = "INSERT INTO PROFILE_RESOURCE_NODE (NODE_ID,EXTENSION_MISMATCH,FINISHED_TIMESTAMP,IDENTIFICATION_COUNT, EXTENSION,HASH,IDENTIFICATION_METHOD,LAST_MODIFIED_DATE,NAME,NODE_STATUS, RESOURCE_TYPE,FILE_SIZE,PARENT_ID,PREFIX,PREFIX_PLUS_ONE,URI) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES ";
    private static final String INSERT_ZERO_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,'')";
    private static final String INSERT_ONE_IDENTIFICATION = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?)";
    private static final String INSERT_TWO_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?)";
    private static final String INSERT_THREE_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?)";
    private static final String INSERT_FOUR_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?)";
    private static final String INSERT_FIVE_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?)";
    private static final String INSERT_SIX_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?)";
    private static final String INSERT_SEVEN_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)";
    private static final String INSERT_EIGHT_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)";
    private static final String INSERT_NINE_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)";
    private static final String INSERT_TEN_IDENTIFICATIONS = "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)";
    private static final String[] INSERT_IDENTIFICATION = new String[]{"INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,'')", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)", "INSERT INTO IDENTIFICATION (NODE_ID,PUID) VALUES (?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?),(?,?)"};
    private static final String UPDATE_NODE_STATUS = "UPDATE PROFILE_RESOURCE_NODE SET NODE_STATUS = ? WHERE NODE_ID = ?";
    private static final String DELETE_NODE = "DELETE FROM PROFILE_RESOURCE_NODE WHERE NODE_ID = ?";
    private static final String SELECT_FORMAT = "SELECT PUID, MIME_TYPE, NAME, VERSION FROM FORMAT WHERE PUID = ?";
    private static final String SELECT_FORMAT_COUNT = "SELECT COUNT('x') AS total FROM FORMAT";
    private static final String SELECT_FORMATS = "SELECT PUID, MIME_TYPE, NAME, VERSION FROM FORMAT";
    private static final String SELECT_PROFILE_RESOURCE_NODE = "SELECT NODE_ID, EXTENSION_MISMATCH, FINISHED_TIMESTAMP, IDENTIFICATION_COUNT, EXTENSION, HASH, IDENTIFICATION_METHOD, LAST_MODIFIED_DATE, NAME, NODE_STATUS, RESOURCE_TYPE, FILE_SIZE, PARENT_ID, PREFIX, PREFIX_PLUS_ONE, TEXT_ENCODING, URI FROM PROFILE_RESOURCE_NODE WHERE NODE_ID = ?";
    private static final String SELECT_IDENTIFICATIONS = "SELECT NODE_ID, PUID FROM IDENTIFICATION WHERE NODE_ID = ?";
    private static final String DELETE_IDENTIFICATIONS = "DELETE FROM IDENTIFICATION WHERE NODE_ID = ?";
    private static final String MAX_NODE_ID_QUERY = "SELECT MAX(NODE_ID) FROM PROFILE_RESOURCE_NODE";
    private static final String CREATE_TABLE_FORMAT = "CREATE TABLE FORMAT (PUID VARCHAR(255) NOT NULL, MIME_TYPE VARCHAR(255), NAME VARCHAR(255), VERSION VARCHAR(255), U_NAME GENERATED ALWAYS AS (UPPER(NAME)), PRIMARY KEY (PUID))";
    private static final String CREATE_TABLE_IDENTIFICATION = "CREATE TABLE IDENTIFICATION (NODE_ID BIGINT NOT NULL, PUID VARCHAR(255) NOT NULL, PRIMARY KEY(NODE_ID, PUID))";
    private static final String CREATE_TABLE_PRN = "CREATE TABLE PROFILE_RESOURCE_NODE (NODE_ID BIGINT NOT NULL, EXTENSION_MISMATCH BOOLEAN NOT NULL, FINISHED_TIMESTAMP TIMESTAMP, IDENTIFICATION_COUNT INTEGER, EXTENSION VARCHAR(255), HASH VARCHAR(64), IDENTIFICATION_METHOD INTEGER, LAST_MODIFIED_DATE TIMESTAMP, NAME VARCHAR(1000) NOT NULL, NODE_STATUS INTEGER, RESOURCE_TYPE INTEGER NOT NULL, FILE_SIZE BIGINT, PARENT_ID BIGINT, PREFIX VARCHAR(255), PREFIX_PLUS_ONE VARCHAR(255), TEXT_ENCODING INTEGER, URI VARCHAR(4000) NOT NULL, U_EXTENSION GENERATED ALWAYS AS (UPPER(EXTENSION)), U_NAME GENERATED ALWAYS AS (UPPER(NAME)), PRIMARY KEY (NODE_ID))";
    private static final String CREATE_IDX_MIME_TYPE_ON_FORMAT = "CREATE INDEX IDX_MIME_TYPE ON FORMAT (MIME_TYPE)";
    private static final String CREATE_IDX_FORMAT_NAME_ON_FORMAT = "CREATE INDEX IDX_FORMAT_NAME ON FORMAT (U_NAME)";
    private static final String CREATE_IDX_ID_COUNT_ON_PRN = "CREATE INDEX IDX_ID_COUNT ON PROFILE_RESOURCE_NODE (IDENTIFICATION_COUNT)";
    private static final String CREATE_IDX_PRN_EXT_ON_PRN = "CREATE INDEX IDX_PRN_EXTENSION ON PROFILE_RESOURCE_NODE (U_EXTENSION)";
    private static final String CREATE_IDX_PRN_ID_METHOD_ON_PRN = "CREATE INDEX IDX_PRN_ID_METHOD ON PROFILE_RESOURCE_NODE (IDENTIFICATION_METHOD)";
    private static final String CREATE_IDX_PRN_LAST_MODIFIED_ON_PRN = "CREATE INDEX IDX_PRN_LAST_MODIFIED ON PROFILE_RESOURCE_NODE (LAST_MODIFIED_DATE)";
    private static final String CREATE_IDX_PRN_NAME_ON_PRN = "CREATE INDEX IDX_PRN_NAME ON PROFILE_RESOURCE_NODE (NAME)";
    private static final String CREATE_IDX_PRN_NODE_STATUS_ON_PRN = "CREATE INDEX IDX_PRN_NODE_STATUS ON PROFILE_RESOURCE_NODE (NODE_STATUS)";
    private static final String CREATE_IDX_ID_RESOURCE_ON_PRN = "CREATE INDEX IDX_PRN_ID_RESOURCETYPE ON PROFILE_RESOURCE_NODE (RESOURCE_TYPE)";
    private static final String CREATE_IDX_PRN_FILE_SIZE_ON_PRN = "CREATE INDEX IDX_PRN_FILE_SIZE ON PROFILE_RESOURCE_NODE (FILE_SIZE)";
    private static final String CREATE_IDX_PARENT_ID_ON_PRN = "CREATE INDEX IDX_PARENT_ID ON PROFILE_RESOURCE_NODE (PARENT_ID)";
    private static final String CREATE_IDX_PREFIX_ON_PRN = "CREATE INDEX IDX_PREFIX ON PROFILE_RESOURCE_NODE (PREFIX)";
    private static final String CREATE_IDX_PREFIX_PLUS_ONE_ON_PRN = "CREATE INDEX IDX_PREFIX_PLUS_ONE ON PROFILE_RESOURCE_NODE (PREFIX_PLUS_ONE)";
    private static final String IDENTIFICATION_CONSTRAINT_1 = "ALTER TABLE IDENTIFICATION ADD CONSTRAINT FK_FH484CCWWL4E5W9QUQKE4N6RI FOREIGN KEY (PUID) REFERENCES FORMAT";
    private static final String IDENTIFICATION_CONSTRAINT_2 = "ALTER TABLE IDENTIFICATION ADD CONSTRAINT FK_TPXMO6PPUXECKDRELN5PT5E39 FOREIGN KEY (NODE_ID) REFERENCES PROFILE_RESOURCE_NODE";
    private static final String CREATE_UCASE_PRN_EXTN_COL = "ALTER TABLE PROFILE_RESOURCE_NODE ADD COLUMN U_EXTENSION GENERATED ALWAYS AS (UPPER(EXTENSION))";
    private static final String CREATE_UCASE_PRN_NAME_COL = "ALTER TABLE PROFILE_RESOURCE_NODE ADD COLUMN U_NAME GENERATED ALWAYS AS (UPPER(NAME))";
    private static final String CREATE_UCASE_FMT_NAME_COL = "ALTER TABLE FORMAT ADD COLUMN U_NAME GENERATED ALWAYS AS (UPPER(NAME))";
    private static final String ALTER_NAME_COLUMN_SIZE = "ALTER TABLE PROFILE_RESOURCE_NODE ALTER COLUMN NAME SET DATA TYPE VARCHAR(1000)";
    private static final int PRN_COL_COUNT_SANS_UCASE_COLS = 17;
    private static final int PRN_COL_COUNT_WITH_UCASE_COLS = 19;
    private static boolean freshTemplate;
    private static final Object LOCKER;
    private static final int BLOCKING_QUEUE_SIZE = 256;
    private static final int MOST_RECENTLY_ADDED_NODE_CACHE_SIZE = 512;
    private static final int PUID_FORMAT_MAP_SIZE = 2500;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DataSource datasource;
    private AtomicLong nodeIds;
    private List<Format> formats;
    private Map<String, Format> puidFormatMap = new HashMap<String, Format>(2500);
    private BlockingQueue<NodeInfo> blockingQueue = new ArrayBlockingQueue<NodeInfo>(256);
    private MostRecentlyAddedNodeCache nodeCache = new MostRecentlyAddedNodeCache(512);
    private Thread databaseWriterThread;
    private DatabaseWriter writer;

    public JDBCBatchResultHandlerDao() {
    }

    public JDBCBatchResultHandlerDao(DataSource datasource) {
        this.setDatasource(datasource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Object object = LOCKER;
        synchronized (object) {
            if (!JDBCBatchResultHandlerDao.getIsFreshTemplate()) {
                this.checkCreateUpperCaseColumns();
                this.setUpFormatsAndDatabaseWriter();
            } else {
                this.createSchemaOnFreshTemplate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialiseForNewTemplate() {
        if (JDBCBatchResultHandlerDao.getIsFreshTemplate()) {
            this.log.error("Cannot initialise the JDBCBatchResultHandlerDao because it is still in fresh template mode and the format reference data has not yet been populated");
            return;
        }
        Object object = LOCKER;
        synchronized (object) {
            boolean alreadyInitialised;
            boolean bl = alreadyInitialised = this.formats != null && this.formats.size() > 0;
            if (!alreadyInitialised) {
                this.setUpFormatsAndDatabaseWriter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCreateUpperCaseColumns() {
        Connection conn = null;
        Statement loadNode = null;
        PreparedStatement createColumn = null;
        ResultSet result = null;
        try {
            conn = this.datasource.getConnection();
            conn.setAutoCommit(false);
            loadNode = conn.prepareStatement("SELECT * FROM PROFILE_RESOURCE_NODE");
            result = loadNode.executeQuery();
            int numberOfColumnsInPrnTable = result.getMetaData().getColumnCount();
            result.close();
            switch (numberOfColumnsInPrnTable) {
                case 17: {
                    String[] statements;
                    for (String s : statements = new String[]{ALTER_NAME_COLUMN_SIZE, CREATE_UCASE_PRN_EXTN_COL, CREATE_UCASE_PRN_NAME_COL, CREATE_UCASE_FMT_NAME_COL}) {
                        try {
                            createColumn = conn.prepareStatement(s);
                            int x = createColumn.executeUpdate();
                        }
                        catch (SQLException ex) {
                            this.log.error(ex.getMessage());
                        }
                        finally {
                            createColumn.close();
                        }
                    }
                    conn.commit();
                    return;
                }
                case 19: {
                    return;
                }
                default: {
                    throw new SQLException("Invalid number of columns in profile_resource_node table!");
                }
            }
        }
        catch (SQLException e) {
            this.log.error(e.getSQLState(), (Throwable)e);
            return;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (result != null) {
                    loadNode.close();
                }
                if (conn != null) {
                    conn.rollback();
                    conn.close();
                }
            }
            catch (SQLException e) {
                this.log.error(e.getSQLState(), (Throwable)e);
            }
        }
    }

    private void setUpFormatsAndDatabaseWriter() {
        this.formats = this.loadAllFormats();
        for (Format format : this.formats) {
            this.puidFormatMap.put(format.getPuid(), format);
        }
        this.nodeIds = new AtomicLong(this.getMaxNodeId() + 1L);
        if (this.formats.size() > 0 && this.writer == null) {
            this.createAndRunDatabaseWriterThread();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSchemaOnFreshTemplate() {
        try {
            PreparedStatement[] statements;
            Connection conn = this.datasource.getConnection();
            PreparedStatement createFormatTable = null;
            PreparedStatement createIdentificationTable = null;
            PreparedStatement createProfileResourceNodeTable = null;
            try {
                createFormatTable = conn.prepareStatement(CREATE_TABLE_FORMAT);
                createFormatTable.execute();
                createIdentificationTable = conn.prepareStatement(CREATE_TABLE_IDENTIFICATION);
                createIdentificationTable.execute();
                createProfileResourceNodeTable = conn.prepareStatement(CREATE_TABLE_PRN);
                createProfileResourceNodeTable.execute();
                ArrayList<String> createIndexesAndConstraints = new ArrayList<String>(19);
                createIndexesAndConstraints.add(CREATE_IDX_MIME_TYPE_ON_FORMAT);
                createIndexesAndConstraints.add(CREATE_IDX_FORMAT_NAME_ON_FORMAT);
                createIndexesAndConstraints.add(CREATE_IDX_ID_COUNT_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PRN_EXT_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PRN_ID_METHOD_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PRN_LAST_MODIFIED_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PRN_NAME_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PRN_NODE_STATUS_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_ID_RESOURCE_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PRN_FILE_SIZE_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PARENT_ID_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PREFIX_ON_PRN);
                createIndexesAndConstraints.add(CREATE_IDX_PREFIX_PLUS_ONE_ON_PRN);
                createIndexesAndConstraints.add(IDENTIFICATION_CONSTRAINT_1);
                createIndexesAndConstraints.add(IDENTIFICATION_CONSTRAINT_2);
                for (String ddlSQL : createIndexesAndConstraints) {
                    PreparedStatement ddlStatement = conn.prepareStatement(ddlSQL);
                    ddlStatement.execute();
                    ddlStatement.close();
                }
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    PreparedStatement[] statements2;
                    for (PreparedStatement a : statements2 = new PreparedStatement[]{createFormatTable, createIdentificationTable, createProfileResourceNodeTable}) {
                        if (a == null) continue;
                        try {
                            a.close();
                        }
                        catch (Exception e2) {
                            this.log.error(e2.getMessage(), (Throwable)e2);
                        }
                    }
                    try {
                        conn.close();
                        throw throwable;
                    }
                    catch (Exception e3) {
                        this.log.error(e3.getMessage(), (Throwable)e3);
                    }
                    throw throwable;
                }
            }
            for (PreparedStatement a : statements = new PreparedStatement[]{createFormatTable, createIdentificationTable, createProfileResourceNodeTable}) {
                if (a == null) continue;
                try {
                    a.close();
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                conn.close();
                return;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return;
            }
        }
        catch (SQLException e) {
            this.log.error("A database exception occurred getting when creating the Derby database for a fresh install.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ProfileResourceNode node, ResourceId parentId) {
        boolean insertNode;
        boolean bl = insertNode = node.getId() == null;
        if (insertNode) {
            this.setNodeIds(node, parentId);
        }
        try {
            MostRecentlyAddedNodeCache mostRecentlyAddedNodeCache = this.nodeCache;
            synchronized (mostRecentlyAddedNodeCache) {
                this.nodeCache.put(node.getId(), node);
            }
            this.blockingQueue.put(new NodeInfo(node, insertNode));
        }
        catch (InterruptedException e) {
            this.log.debug("Saving was interrupted while putting a new node into the queue.", (Throwable)e);
        }
    }

    @Override
    public void commit() {
        try {
            this.blockingQueue.put(COMMIT_SO_FAR);
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted while requesting a commit.", (Throwable)e);
        }
    }

    private void setNodeIds(ProfileResourceNode node, ResourceId parentId) {
        Long nodeId = this.nodeIds.incrementAndGet();
        node.setId(nodeId);
        String parentsPrefixString = "";
        if (parentId != null) {
            parentsPrefixString = parentId.getPath();
            node.setParentId(parentId.getId());
        }
        int parentsPrefixStringLength = parentsPrefixString != null ? parentsPrefixString.length() : 0;
        int buliderBaseSize = 5;
        int nodeValueSize = 5;
        StringBuilder builder = new StringBuilder(5 + parentsPrefixStringLength);
        builder.append(parentsPrefixString);
        char[] nodeValue = new char[5];
        ResourceUtils.getBase128IntegerCharArray((long)nodeId, (char[])nodeValue);
        builder.append(nodeValue);
        node.setPrefix(builder.toString());
        builder.setLength(parentsPrefixStringLength);
        ResourceUtils.getBase128IntegerCharArray((long)(nodeId + 1L), (char[])nodeValue);
        builder.append(nodeValue);
        node.setPrefixPlusOne(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Format loadFormat(String puid) {
        Format format = null;
        try (Connection conn = this.datasource.getConnection();
             PreparedStatement loadFormat = conn.prepareStatement(SELECT_FORMAT);){
            loadFormat.setString(1, puid);
            try (ResultSet results = loadFormat.executeQuery();){
                if (results.next()) {
                    format = SqlUtils.buildFormat(results);
                }
            }
        }
        catch (SQLException e) {
            this.log.error("A database exception occurred loading a format with puid " + puid, (Throwable)e);
        }
        return format;
    }

    @Override
    public List<Format> getAllFormats() {
        return this.formats;
    }

    @Override
    public Map<String, Format> getPUIDFormatMap() {
        return this.puidFormatMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileResourceNode loadNode(Long nodeId) {
        ProfileResourceNode node = null;
        MostRecentlyAddedNodeCache mostRecentlyAddedNodeCache = this.nodeCache;
        synchronized (mostRecentlyAddedNodeCache) {
            node = (ProfileResourceNode)this.nodeCache.get(nodeId);
            if (node != null) {
                node = new ProfileResourceNode(node);
            }
        }
        if (node == null) {
            try (Connection conn = this.datasource.getConnection();
                 PreparedStatement loadNode = conn.prepareStatement(SELECT_PROFILE_RESOURCE_NODE);){
                loadNode.setLong(1, nodeId);
                try (ResultSet nodeResults = loadNode.executeQuery();){
                    if (nodeResults.next()) {
                        PreparedStatement loadIdentifications = conn.prepareStatement(SELECT_IDENTIFICATIONS);
                        loadIdentifications.setLong(1, nodeId);
                        ResultSet idResults = loadIdentifications.executeQuery();
                        node = SqlUtils.buildProfileResourceNode(nodeResults);
                        SqlUtils.addIdentifications(node, idResults, this.puidFormatMap);
                    }
                }
            }
            catch (SQLException e) {
                this.log.error("A database exception occurred loading a node with id " + nodeId, (Throwable)e);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(Long nodeId) {
        try (Connection conn = this.datasource.getConnection();){
            try (PreparedStatement nodeStatement = conn.prepareStatement(DELETE_NODE);){
                nodeStatement.setLong(1, nodeId);
                nodeStatement.execute();
            }
            try (PreparedStatement idStatement = conn.prepareStatement(DELETE_IDENTIFICATIONS);){
                idStatement.setLong(1, nodeId);
                idStatement.execute();
            }
            conn.commit();
        }
        catch (SQLException e) {
            this.log.error("A database exception occurred deleting a node with id " + nodeId, (Throwable)e);
        }
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxNodeId() {
        long maxId = 0L;
        try (Connection conn = this.datasource.getConnection();
             PreparedStatement maxNodes = conn.prepareStatement(MAX_NODE_ID_QUERY);
             ResultSet results = maxNodes.executeQuery();){
            if (results.next()) {
                maxId = results.getLong(1);
            }
        }
        catch (SQLException e) {
            this.log.error("A database exception occurred finding the maximum id in the database", (Throwable)e);
        }
        return maxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Format> loadAllFormats() {
        ArrayList<Format> formatsList = null;
        try (Connection conn = this.datasource.getConnection();){
            PreparedStatement getFormatCount = conn.prepareStatement(SELECT_FORMAT_COUNT);
            ResultSet rsFormatCount = getFormatCount.executeQuery();
            rsFormatCount.next();
            int formatCount = rsFormatCount.getInt("total");
            formatsList = new ArrayList<Format>(formatCount);
            try (PreparedStatement loadFormat = conn.prepareStatement(SELECT_FORMATS);
                 ResultSet results = loadFormat.executeQuery();){
                while (results.next()) {
                    formatsList.add(SqlUtils.buildFormat(results));
                }
            }
        }
        catch (SQLException e) {
            this.log.error("A database exception occurred getting all formats.", (Throwable)e);
        }
        return formatsList;
    }

    private void createAndRunDatabaseWriterThread() {
        this.writer = new DatabaseWriter(this.blockingQueue, this.datasource, 100);
        try {
            this.writer.init();
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not initialise the database writer - fatal error.", e);
        }
        this.databaseWriterThread = new Thread(this.writer);
        try {
            this.databaseWriterThread.join();
            this.databaseWriterThread.start();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
        this.writer.closeResources();
    }

    public static synchronized void setIsFreshTemplate(boolean isFreshTemplate) {
        freshTemplate = isFreshTemplate;
    }

    public static boolean getIsFreshTemplate() {
        return freshTemplate;
    }

    static {
        LOCKER = new Object();
    }

    private static class DatabaseWriter
    implements Runnable {
        private static final int INSERT_NODE_URI_INDEX = 16;
        private static final int INSERT_NODE_PREFIX_PLUS_ONE_INDEX = 15;
        private static final int INSERT_NODE_PREFIX_INDEX = 14;
        private static final int INSERT_NODE_PARENT_ID_INDEX = 13;
        private static final int INSERT_NODE_SIZE_INDEX = 12;
        private static final int INSERT_NODE_RESOURCE_TYPE_INDEX = 11;
        private static final int INSERT_NODE_STATUS_INDEX = 10;
        private static final int INSERT_NODE_NAME_INDEX = 9;
        private static final int INSERT_NODE_MOD_DATE_INDEX = 8;
        private static final int INSERT_NODE_METHOD_INDEX = 7;
        private static final int INSERT_NODE_HASH_INDEX = 6;
        private static final int INSERT_NODE_EXT_INDEX = 5;
        private static final int INSERT_NODE_NUM_IDENTS_INDEX = 4;
        private static final int INSERT_NODE_FINISHED_INDEX = 3;
        private static final int INSERT_NODE_MISMATCH_INDEX = 2;
        private static final int INSERT_NODE_ID_INDEX = 1;
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private BlockingQueue<NodeInfo> blockingQueue;
        private DataSource datasource;
        private Connection connection;
        private PreparedStatement insertNodeStatement;
        private PreparedStatement updateNodeStatement;
        private Map<Integer, PreparedStatement> insertIdentifications;
        private volatile int batchCount;
        private final int batchLimit;

        DatabaseWriter(BlockingQueue<NodeInfo> blockingQueue, DataSource datasource, int batchLimit) {
            this.blockingQueue = blockingQueue;
            this.datasource = datasource;
            this.batchLimit = batchLimit;
        }

        public void init() throws SQLException {
            this.connection = this.datasource.getConnection();
            this.insertNodeStatement = this.connection.prepareStatement(JDBCBatchResultHandlerDao.INSERT_PROFILE_RESOURCE_NODE);
            this.updateNodeStatement = this.connection.prepareStatement(JDBCBatchResultHandlerDao.UPDATE_NODE_STATUS);
            int maxStatements = 64;
            this.insertIdentifications = new HashMap<Integer, PreparedStatement>(64);
            for (int i = 0; i < INSERT_IDENTIFICATION.length; ++i) {
                PreparedStatement insertStatement = this.connection.prepareStatement(INSERT_IDENTIFICATION[i]);
                this.insertIdentifications.put(i, insertStatement);
            }
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        NodeInfo info;
                        if ((info = this.blockingQueue.take()) == COMMIT_SO_FAR) {
                            this.commit();
                            continue;
                        }
                        try {
                            if (info.insertNode) {
                                this.batchInsertNode(info.getNode());
                                continue block4;
                            }
                            this.updateNodeStatus(info.getNode());
                            continue block4;
                        }
                        catch (SQLException e) {
                            this.log.error("A database problem occurred inserting a node: " + info.getNode(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    this.log.debug("The database writer thread was interrupted.", (Throwable)e);
                    System.out.println("Calling closeResources() from  the run method");
                    this.closeResources();
                    return;
                }
            }
        }

        private void closeResources() {
            for (PreparedStatement statement : this.insertIdentifications.values()) {
                try {
                    statement.close();
                }
                catch (SQLException s) {
                    this.log.error("A problem occurred closing an identification prepared statement.", (Throwable)s);
                }
            }
            try {
                this.insertNodeStatement.close();
            }
            catch (SQLException s) {
                this.log.error("A problem occurred closing a node insert prepared statement.", (Throwable)s);
            }
            try {
                this.connection.close();
            }
            catch (SQLException s) {
                this.log.error("A problem occurred closing a database connection", (Throwable)s);
            }
        }

        private void batchInsertNode(ProfileResourceNode node) throws SQLException {
            long nodeId = node.getId();
            NodeMetaData metadata = node.getMetaData();
            String uri = node.getUri().toString();
            Date finished = new Date(new java.util.Date().getTime());
            boolean mismatch = node.getExtensionMismatch();
            String name = metadata.getName();
            String hash = metadata.getHash();
            Long size = metadata.getSize();
            NodeStatus nodeStatus = metadata.getNodeStatus();
            ResourceType resourceType = metadata.getResourceType();
            String extension = metadata.getExtension();
            Integer numIdentifications = node.getIdentificationCount();
            java.util.Date modDate = metadata.getLastModifiedDate();
            IdentificationMethod method = metadata.getIdentificationMethod();
            Long nodeParentId = node.getParentId();
            String nodePrefix = node.getPrefix();
            String nodePrefixPlusOne = node.getPrefixPlusOne();
            PreparedStatement insertNode = this.insertNodeStatement;
            insertNode.setLong(1, nodeId);
            insertNode.setBoolean(2, mismatch);
            SqlUtils.setNullableTimestamp(3, finished, insertNode);
            SqlUtils.setNullableInteger(4, numIdentifications, insertNode);
            SqlUtils.setNullableString(5, extension, insertNode);
            SqlUtils.setNullableString(6, hash, insertNode);
            SqlUtils.setNullableEnumAsInt(7, (Enum)method, insertNode);
            SqlUtils.setNullableTimestamp(8, modDate, insertNode);
            insertNode.setString(9, name);
            SqlUtils.setNullableEnumAsInt(10, (Enum)nodeStatus, insertNode);
            SqlUtils.setNullableEnumAsInt(11, (Enum)resourceType, insertNode);
            SqlUtils.setNullableLong(12, size, insertNode);
            SqlUtils.setNullableLong(13, nodeParentId, insertNode);
            SqlUtils.setNullableString(14, nodePrefix, insertNode);
            SqlUtils.setNullableString(15, nodePrefixPlusOne, insertNode);
            insertNode.setString(16, uri);
            insertNode.addBatch();
            int identifications = numIdentifications == null ? 0 : numIdentifications;
            PreparedStatement statement = this.getIdentificationStatement(identifications);
            if (identifications == 0) {
                statement.setLong(1, nodeId);
            } else {
                int parameterCount = 1;
                for (Format format : node.getFormatIdentifications()) {
                    statement.setLong(parameterCount++, nodeId);
                    String p = format.getPuid();
                    statement.setString(parameterCount++, p == null ? "" : p);
                }
            }
            statement.addBatch();
            this.commitBatchIfLargeEnough();
        }

        private void updateNodeStatus(ProfileResourceNode node) throws SQLException {
            Long nodeId = node.getId();
            if (nodeId != null) {
                NodeMetaData nm = node.getMetaData();
                if (nm != null) {
                    SqlUtils.setNullableEnumAsInt(1, (Enum)nm.getNodeStatus(), this.updateNodeStatement);
                    this.updateNodeStatement.setLong(2, nodeId);
                    this.updateNodeStatement.addBatch();
                    this.commitBatchIfLargeEnough();
                } else {
                    this.log.error("A node was flagged for status update, but had no status metadata. Node id was: " + nodeId);
                }
            } else {
                this.log.error("A node was flagged for status update, but it did not have an id already.  Parent id was: " + node.getParentId());
            }
        }

        private void commitBatchIfLargeEnough() {
            if (this.batchCount++ >= this.batchLimit) {
                this.batchCount = 0;
                try {
                    this.insertNodeStatement.executeBatch();
                    this.updateNodeStatement.executeBatch();
                    for (PreparedStatement identifications : this.insertIdentifications.values()) {
                        identifications.executeBatch();
                    }
                    this.connection.commit();
                }
                catch (SQLException e) {
                    this.log.error("A problem occurred attempting to batch commit nodes into the database. ", (Throwable)e);
                }
            }
        }

        public void commit() {
            this.batchCount = 100;
            this.commitBatchIfLargeEnough();
        }

        private PreparedStatement getIdentificationStatement(int numIdentifications) throws SQLException {
            PreparedStatement statement = this.insertIdentifications.get(numIdentifications);
            if (statement == null) {
                String newIdentificationSQL = this.buildInsertIdentificationString(numIdentifications);
                statement = this.connection.prepareStatement(newIdentificationSQL);
                this.insertIdentifications.put(numIdentifications, statement);
            }
            return statement;
        }

        private String buildInsertIdentificationString(int numIdentifications) {
            int baseInsertStatementSize = 60;
            int sizeForEachIdentification = 6;
            StringBuilder builder = new StringBuilder(60 + numIdentifications * 6);
            builder.append(JDBCBatchResultHandlerDao.INSERT_IDENTIFICATIONS);
            for (int i = 0; i < numIdentifications - 1; ++i) {
                builder.append("(?,?),");
            }
            builder.append("(?,?)");
            return builder.toString();
        }
    }

    private final class MostRecentlyAddedNodeCache
    extends LinkedHashMap<Long, ProfileResourceNode> {
        private static final float LOAD_FACTOR = 1.1f;
        private final int capacity;

        private MostRecentlyAddedNodeCache(int capacity) {
            super(capacity + 1, 1.1f, false);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, ProfileResourceNode> eldest) {
            return this.size() > this.capacity;
        }
    }

    private static class NodeInfo {
        private ProfileResourceNode node;
        private boolean insertNode;

        public NodeInfo(ProfileResourceNode node, boolean insertNode) {
            this.node = node;
            this.insertNode = insertNode;
        }

        public ProfileResourceNode getNode() {
            return this.node;
        }

        public boolean isInsertNode() {
            return this.insertNode;
        }
    }
}

