/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signature;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ErrorCode;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.profile.referencedata.Format;
import uk.gov.nationalarchives.droid.signature.FormatCallback;
import uk.gov.nationalarchives.droid.signature.SignatureParser;

public class SaxSignatureFileParser
implements SignatureParser {
    private static final String INVALID_SIGNATURE_FILE = "Invalid signature file [%s]";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Path file;

    public SaxSignatureFileParser(URI filePath) throws SignatureFileException {
        this.file = this.openFile(filePath);
    }

    @Override
    public void formats(FormatCallback callback) throws SignatureFileException {
        FileFormatHandler handler = new FileFormatHandler(callback);
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(this.file.toFile(), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new SignatureFileException(String.format(INVALID_SIGNATURE_FILE, this.file.toUri()), (Throwable)e, ErrorCode.INVALID_SIGNATURE_FILE);
        }
        catch (IOException | ParserConfigurationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Path openFile(URI filePath) throws SignatureFileException {
        Path f = Paths.get(filePath);
        if (!Files.exists(f, new LinkOption[0])) {
            throw new SignatureFileException(String.format("Signature file does not exist [%s]", filePath), ErrorCode.FILE_NOT_FOUND);
        }
        if (!Files.isRegularFile(f, new LinkOption[0])) {
            throw new SignatureFileException(String.format(INVALID_SIGNATURE_FILE, filePath), ErrorCode.INVALID_SIGNATURE_FILE);
        }
        return f;
    }

    private static final class FileFormatHandler
    extends DefaultHandler {
        private final FormatCallback callback;

        public FileFormatHandler(FormatCallback callback) {
            this.callback = callback;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("FileFormat".equals(qName)) {
                Format format = new Format();
                format.setPuid(this.notNull(attributes.getValue("PUID")));
                format.setName(this.notNull(attributes.getValue("Name")));
                format.setMimeType(this.notNull(attributes.getValue("MIMEType")));
                format.setVersion(this.notNull(attributes.getValue("Version")));
                this.callback.onFormat(format);
            }
        }

        private String notNull(String value) {
            return value == null ? "" : value;
        }
    }
}

