/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signature;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ErrorCode;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ProxySettings;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ProxySubscriber;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManagerException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureServiceException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureUpdateService;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class SignatureManagerImpl
implements SignatureManager {
    private static final String INVALID_SIGNATURE_FILE = "Invalid signature file [%s]";
    private static Map<SignatureType, DroidGlobalProperty> defaultVersionProperties = new HashMap<SignatureType, DroidGlobalProperty>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DroidGlobalConfig config;
    private Map<SignatureType, SignatureUpdateService> signatureUpdateServices;
    private ProxySettings proxySettings = new ProxySettings();

    public SignatureManagerImpl() {
    }

    public SignatureManagerImpl(DroidGlobalConfig config, Map<SignatureType, SignatureUpdateService> updateServices) {
        this.setConfig(config);
        this.setSignatureUpdateServices(updateServices);
    }

    public void init() {
        this.config.getProperties().addConfigurationListener((ConfigurationListener)this.proxySettings);
        PropertiesConfiguration configuration = this.config.getProperties();
        this.proxySettings = new ProxySettings();
        this.proxySettings.setEnabled(configuration.getBoolean(DroidGlobalProperty.UPDATE_USE_PROXY.getName()));
        this.proxySettings.setProxyHost(configuration.getString(DroidGlobalProperty.UPDATE_PROXY_HOST.getName()));
        this.proxySettings.setProxyPort(configuration.getInt(DroidGlobalProperty.UPDATE_PROXY_PORT.getName()));
        this.proxySettings.setEnabled(configuration.getBoolean(DroidGlobalProperty.UPDATE_USE_PROXY.getName()));
        this.config.getProperties().addConfigurationListener((ConfigurationListener)this.proxySettings);
        for (SignatureUpdateService subscriber : this.signatureUpdateServices.values()) {
            subscriber.init(this.config);
            this.proxySettings.addProxySubscriber((ProxySubscriber)subscriber);
            this.config.getProperties().addConfigurationListener((ConfigurationListener)subscriber);
        }
        this.proxySettings.notifyProxySubscribers();
    }

    public Map<SignatureType, SortedMap<String, SignatureFileInfo>> getAvailableSignatureFiles() {
        Path binSigFileDir = this.config.getSignatureFileDir();
        Path containerSigFileDir = this.config.getContainerSignatureDir();
        DirectoryStream.Filter<Path> xmlExtensionFilter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return !Files.isDirectory(path, new LinkOption[0]) && FileUtil.fileName(path).endsWith(".xml");
            }
        };
        HashMap<SignatureType, SortedMap<String, SignatureFileInfo>> availableSigFiles = new HashMap<SignatureType, SortedMap<String, SignatureFileInfo>>();
        SignatureInfoParser parser = new SignatureInfoParser();
        String errorMessagePattern = "Unreadable signature file [%s]";
        TreeMap<String, SignatureFileInfo> binSigFiles = new TreeMap<String, SignatureFileInfo>();
        for (Path file : FileUtil.listFilesQuietly(binSigFileDir, false, xmlExtensionFilter)) {
            String fileName = FilenameUtils.getBaseName((String)FileUtil.fileName(file));
            try {
                binSigFiles.put(fileName, SignatureManagerImpl.forBinarySigFile(file, parser));
            }
            catch (SignatureFileException e) {
                this.log.warn(String.format("Unreadable signature file [%s]", file));
            }
        }
        TreeMap<String, SignatureFileInfo> containerSigFiles = new TreeMap<String, SignatureFileInfo>();
        for (Path file : FileUtil.listFilesQuietly(containerSigFileDir, false, xmlExtensionFilter)) {
            String fileName = FilenameUtils.getBaseName((String)FileUtil.fileName(file));
            try {
                containerSigFiles.put(fileName, SignatureManagerImpl.forSimpleVersionedFile(file, SignatureType.CONTAINER));
            }
            catch (SignatureFileException e) {
                this.log.warn(String.format("Unreadable signature file [%s]", file));
            }
        }
        availableSigFiles.put(SignatureType.BINARY, binSigFiles);
        availableSigFiles.put(SignatureType.CONTAINER, containerSigFiles);
        return availableSigFiles;
    }

    private static SignatureFileInfo forBinarySigFile(Path file, SignatureInfoParser parser) throws SignatureFileException {
        SignatureFileInfo signatureFileInfo = parser.parse(file);
        signatureFileInfo.setFile(file);
        return signatureFileInfo;
    }

    private static SignatureFileInfo forSimpleVersionedFile(Path file, SignatureType type) throws SignatureFileException {
        String filename = FilenameUtils.getBaseName((String)FileUtil.fileName(file));
        try {
            int version = Integer.valueOf(StringUtils.substringAfterLast((String)filename, (String)"-"));
            SignatureFileInfo signatureFileInfo = new SignatureFileInfo(version, false, type);
            signatureFileInfo.setFile(file);
            return signatureFileInfo;
        }
        catch (NumberFormatException e) {
            String message = String.format("Invalid signature filename [%s]", FileUtil.fileName(file));
            throw new SignatureFileException(message, (Throwable)e, ErrorCode.INVALID_SIGNATURE_FILE);
        }
    }

    public void setConfig(DroidGlobalConfig config) {
        this.config = config;
    }

    public Map<SignatureType, SignatureFileInfo> getLatestSignatureFiles() {
        PropertiesConfiguration properties = this.config.getProperties();
        properties.setProperty(DroidGlobalProperty.LAST_UPDATE_CHECK.getName(), (Object)System.currentTimeMillis());
        HashMap<SignatureType, SignatureFileInfo> latestSigFiles = new HashMap<SignatureType, SignatureFileInfo>();
        Map<SignatureType, SortedMap<String, SignatureFileInfo>> availableSignatureFiles = this.getAvailableSignatureFiles();
        for (Map.Entry<SignatureType, SignatureUpdateService> entry : this.signatureUpdateServices.entrySet()) {
            SignatureType type = entry.getKey();
            SignatureUpdateService updateService = entry.getValue();
            Map signaturesForType = availableSignatureFiles.get(type);
            try {
                int latestVersionForType = this.getLatestVersionForType(type, signaturesForType);
                SignatureFileInfo latestUpdate = updateService.getLatestVersion(latestVersionForType);
                if (latestUpdate == null || latestUpdate.getVersion() <= 0 || signaturesForType.containsValue(latestUpdate)) continue;
                latestSigFiles.put(type, latestUpdate);
            }
            catch (SignatureServiceException e) {
                latestSigFiles.put(type, new SignatureFileInfo(e));
            }
        }
        return latestSigFiles;
    }

    private int getLatestVersionForType(SignatureType type, Map<String, SignatureFileInfo> signatures) {
        int result = 0;
        for (String key : signatures.keySet()) {
            SignatureFileInfo info = signatures.get(key);
            if (info.getVersion() <= result) continue;
            result = info.getVersion();
        }
        return result;
    }

    public void setSignatureUpdateServices(Map<SignatureType, SignatureUpdateService> signatureUpdateServices) {
        this.signatureUpdateServices = signatureUpdateServices;
    }

    public SignatureFileInfo downloadLatest(SignatureType type) throws SignatureManagerException {
        Path sigFileDir;
        switch (type) {
            case BINARY: {
                sigFileDir = this.config.getSignatureFileDir();
                break;
            }
            case CONTAINER: {
                sigFileDir = this.config.getContainerSignatureDir();
                break;
            }
            case TEXT: {
                sigFileDir = this.config.getTextSignatureFileDir();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid signature type : " + type);
            }
        }
        try {
            SignatureFileInfo info = this.signatureUpdateServices.get(type).importSignatureFile(sigFileDir);
            boolean autoSetDefaultSigFile = this.config.getBooleanProperty(DroidGlobalProperty.UPDATE_AUTOSET_DEFAULT);
            if (autoSetDefaultSigFile) {
                PropertiesConfiguration props = this.config.getProperties();
                props.setProperty(defaultVersionProperties.get(type).getName(), (Object)FilenameUtils.getBaseName((String)FileUtil.fileName(info.getFile())));
                try {
                    this.config.getProperties().save();
                }
                catch (ConfigurationException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    throw new SignatureManagerException((Throwable)e);
                }
            }
            return info;
        }
        catch (SignatureServiceException e) {
            throw new SignatureManagerException((Throwable)e);
        }
    }

    public Map<SignatureType, SignatureFileInfo> getDefaultSignatures() throws SignatureFileException {
        HashMap<SignatureType, SignatureFileInfo> defaultSignatures = new HashMap<SignatureType, SignatureFileInfo>();
        Map<SignatureType, SortedMap<String, SignatureFileInfo>> availableSignatureFiles = this.getAvailableSignatureFiles();
        String errorMessagePattern = "Default signature file %s could not be found. Please check your signature settings.";
        for (Map.Entry<SignatureType, SortedMap<String, SignatureFileInfo>> sigFileEntry : availableSignatureFiles.entrySet()) {
            SignatureType type = sigFileEntry.getKey();
            Map sigs = sigFileEntry.getValue();
            DroidGlobalProperty defaultSigFile = defaultVersionProperties.get(type);
            String defaultSigFileKey = this.config.getProperties().getString(defaultSigFile.getName());
            if (!StringUtils.isNotBlank((String)defaultSigFileKey)) continue;
            SignatureFileInfo sigFileInfo = (SignatureFileInfo)sigs.get(defaultSigFileKey);
            if (sigFileInfo == null) {
                String errorMessage = String.format("Default signature file %s could not be found. Please check your signature settings.", this.config.getProperties().getString(defaultVersionProperties.get(type).getName()));
                throw new SignatureFileException(errorMessage, ErrorCode.FILE_NOT_FOUND);
            }
            defaultSignatures.put(type, sigFileInfo);
        }
        return defaultSignatures;
    }

    public SignatureFileInfo install(SignatureType type, Path signatureFile, boolean setDefault) throws SignatureFileException {
        SignatureInfoParser parser = new SignatureInfoParser();
        SignatureFileInfo sigFileInfo = SignatureManagerImpl.forBinarySigFile(signatureFile, parser);
        try {
            Path newSignatureFile = Files.copy(signatureFile, Paths.get(this.config.getSignatureFileDir().toString(), signatureFile.getFileName().toString()), new CopyOption[0]);
            sigFileInfo.setFile(newSignatureFile);
            if (setDefault) {
                this.config.getProperties().setProperty(defaultVersionProperties.get(type).getName(), (Object)FilenameUtils.getBaseName((String)FileUtil.fileName(newSignatureFile)));
            }
            return sigFileInfo;
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new SignatureFileException(e.getMessage(), (Throwable)e, ErrorCode.FILE_NOT_FOUND);
        }
    }

    static {
        defaultVersionProperties.put(SignatureType.BINARY, DroidGlobalProperty.DEFAULT_BINARY_SIG_FILE_VERSION);
        defaultVersionProperties.put(SignatureType.CONTAINER, DroidGlobalProperty.DEFAULT_CONTAINER_SIG_FILE_VERSION);
        defaultVersionProperties.put(SignatureType.TEXT, DroidGlobalProperty.DEFAULT_TEXT_SIG_FILE_VERSION);
    }

    private static final class ValidSignatureFileException
    extends RuntimeException {
        private static final long serialVersionUID = 5955330716555328779L;
        private final SignatureFileInfo info;

        ValidSignatureFileException(SignatureFileInfo info) {
            this.info = info;
        }

        public SignatureFileInfo getInfo() {
            return this.info;
        }
    }

    private static final class SignatureFileVersionHandler
    extends DefaultHandler {
        private static final String ROOT_ELEMENT = "FFSignatureFile";

        private SignatureFileVersionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (ROOT_ELEMENT.equals(qName)) {
                int version = Integer.valueOf(attributes.getValue("Version"));
                SignatureFileInfo info = new SignatureFileInfo(version, false, SignatureType.BINARY);
                throw new ValidSignatureFileException(info);
            }
            throw new SAXException(String.format("Invalid signature file - root element was not [%s]", ROOT_ELEMENT));
        }
    }

    private static final class SignatureInfoParser {
        private SignatureInfoParser() {
        }

        SignatureFileInfo parse(Path sigFile) throws SignatureFileException {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SignatureFileVersionHandler handler = new SignatureFileVersionHandler();
            try {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                saxParser.parse(sigFile.toFile(), (DefaultHandler)handler);
                throw new SignatureFileException(String.format(SignatureManagerImpl.INVALID_SIGNATURE_FILE, sigFile), ErrorCode.INVALID_SIGNATURE_FILE);
            }
            catch (ValidSignatureFileException e) {
                return e.getInfo();
            }
            catch (SAXException e) {
                throw new SignatureFileException(String.format(SignatureManagerImpl.INVALID_SIGNATURE_FILE, sigFile), (Throwable)e, ErrorCode.INVALID_SIGNATURE_FILE);
            }
            catch (IOException | ParserConfigurationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

