/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationErrorType;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.profile.throttle.SubmissionThrottle;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class FileEventHandler {
    private static final int URI_STRING_BUILDER_CAPACITY = 1024;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AsynchDroid droidCore;
    private ResultHandler resultHandler;
    private IdentificationRequestFactory<Path> requestFactory;
    private SubmissionThrottle submissionThrottle;
    private StringBuilder uriStringBuilder = new StringBuilder(1024);

    public FileEventHandler() {
    }

    public FileEventHandler(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public FileEventHandler(AsynchDroid droidCore, ResultHandler resultHandler, IdentificationRequestFactory<Path> requestFactory, SubmissionThrottle submissionThrottle) {
        this.setDroidCore(droidCore);
        this.setResultHandler(resultHandler);
        this.setRequestFactory(requestFactory);
        this.setSubmissionThrottle(submissionThrottle);
    }

    public void onEvent(Path file, ResourceId parentId, ResourceId nodeId) {
        FileTime lastModified = FileUtil.lastModifiedQuietly(file);
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(FileUtil.sizeQuietly(file)), Long.valueOf(lastModified == null ? new Date(0L).getTime() : new Date(lastModified.toMillis()).getTime()), FileUtil.fileName(file));
        RequestIdentifier identifier = new RequestIdentifier(file.toUri());
        identifier.setParentResourceId(parentId);
        identifier.setResourceId(nodeId);
        IdentificationRequest request = this.requestFactory.newRequest(metaData, identifier);
        try {
            request.open((Object)file);
            this.droidCore.submit(request);
            this.submissionThrottle.apply();
        }
        catch (IOException e) {
            IdentificationErrorType error;
            IdentificationErrorType identificationErrorType = error = Files.exists(file, new LinkOption[0]) ? IdentificationErrorType.ACCESS_DENIED : IdentificationErrorType.FILE_NOT_FOUND;
            if (error.equals((Object)IdentificationErrorType.ACCESS_DENIED)) {
                this.log.warn(String.format("Access was denied to the file: [%s]", file.toAbsolutePath().toString()));
            } else {
                this.log.warn(String.format("File not found: [%s]", file.toAbsolutePath().toString()));
            }
            this.resultHandler.handleError(new IdentificationException(request, error, (Throwable)e));
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted while throttle active.", (Throwable)e);
        }
    }

    public SubmissionThrottle getSubmissionThrottle() {
        return this.submissionThrottle;
    }

    public void setSubmissionThrottle(SubmissionThrottle submissionThrottle) {
        this.submissionThrottle = submissionThrottle;
    }

    public void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void setRequestFactory(IdentificationRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }
}

