/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.submitter.FileWalkerHandler;
import uk.gov.nationalarchives.droid.submitter.SubmitterUtils;
import uk.gov.nationalarchives.droid.util.FileUtil;

@XmlAccessorType(value=XmlAccessType.NONE)
public class FileWalker {
    private static final String FILE_SYSTEM_UNAVAILABLE = "File system appears to be unavailable for file: [%s]";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private URI root;
    @XmlAttribute(name="Recursive")
    private boolean recursive;
    @XmlElementWrapper(name="Progress")
    @XmlElement(name="ProgressEntry")
    private Deque<ProgressEntry> progress;
    private String topLevelAbsolutePath;
    private FileWalkerHandler fileHandler;
    private FileWalkerHandler directoryHandler;
    private FileWalkerHandler restrictedDirectoryHandler;
    private boolean fastForward;
    private List<ProgressEntry> recoveryRoad;

    FileWalker() {
    }

    public FileWalker(URI root, boolean recursive) {
        this.recursive = recursive;
        this.setRootUri(root);
    }

    public FileWalker(URI root, boolean recursive, FileWalkerHandler fileHandler, FileWalkerHandler directoryHandler, FileWalkerHandler restrictedDirectoryHandler) {
        this.recursive = recursive;
        this.setRootUri(root);
        this.setFileHandler(fileHandler);
        this.setDirectoryHandler(directoryHandler);
        this.setRestrictedDirectoryHandler(restrictedDirectoryHandler);
    }

    @XmlElement(name="RootUri")
    public URI getRootUri() {
        return this.root;
    }

    public void setRootUri(URI rootUri) {
        this.root = rootUri;
        this.topLevelAbsolutePath = Paths.get(this.root).toAbsolutePath().toString();
    }

    public void walk() throws IOException {
        if (this.progress != null) {
            this.fastForward = true;
            this.recoveryRoad = FileWalker.reverseProgress(this.progress);
        } else {
            this.progress = new ArrayDeque<ProgressEntry>();
        }
        this.walk(Paths.get(this.root), 0);
    }

    private static List<ProgressEntry> reverseProgress(Deque<ProgressEntry> progress) {
        ArrayList<ProgressEntry> reversed = new ArrayList<ProgressEntry>();
        Iterator<ProgressEntry> it = progress.descendingIterator();
        while (it.hasNext()) {
            ProgressEntry entry = it.next();
            reversed.add(entry);
        }
        return reversed;
    }

    private void walk(Path directory, int depth) throws IOException {
        if (this.handleDirectory(directory, depth)) {
            List<Path> children = FileUtil.listFiles(directory, false, (DirectoryStream.Filter<Path>)null);
            this.handleDirectoryStart(directory, depth, children.toArray(new Path[children.size()]));
            if (this.recursive || depth == 0) {
                int childDepth = depth + 1;
                for (Path child : children) {
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        this.walk(child, childDepth);
                        continue;
                    }
                    this.handleFile(child, childDepth);
                }
            }
            this.handleDirectoryEnd(directory, depth);
        } else {
            this.handleRestrictedDirectory(directory, depth);
        }
    }

    protected boolean handleDirectory(Path dir, int depth) throws IOException {
        boolean processDir = true;
        if (!Files.isReadable(dir)) {
            return false;
        }
        if (!SubmitterUtils.isFileSystemAvailable(dir, this.topLevelAbsolutePath)) {
            this.log.error(String.format(FILE_SYSTEM_UNAVAILABLE, dir.toAbsolutePath().toString()));
            throw new IOException(dir.toAbsolutePath().toString());
        }
        if (this.fastForward && (depth >= this.recoveryRoad.size() || !this.recoveryRoad.get(depth).getFile().equals(dir))) {
            if (this.recoveryRoad.get(depth - 1).containsChild(dir)) {
                this.fastForward = false;
            } else {
                processDir = false;
            }
        }
        return processDir;
    }

    protected void handleDirectoryStart(Path directory, int depth, Path[] children) throws IOException {
        if (this.fastForward) {
            return;
        }
        ProgressEntry parent = this.progress.peek();
        ResourceId directoryId = this.directoryHandler.handle(directory, depth, parent);
        this.progress.push(new ProgressEntry(directory, directoryId, children));
    }

    protected void handleFile(Path file, int depth) throws IOException {
        if (!SubmitterUtils.isFileSystemAvailable(file, this.topLevelAbsolutePath)) {
            this.log.error(String.format(FILE_SYSTEM_UNAVAILABLE, file.toAbsolutePath().toString()));
            throw new IOException(file.toAbsolutePath().toString());
        }
        if (this.fastForward) {
            if (this.recoveryRoad.get(depth - 1).containsChild(file)) {
                this.fastForward = false;
            } else {
                return;
            }
        }
        ProgressEntry progressEntry = this.progress.peek();
        if (!Files.isDirectory(file, new LinkOption[0])) {
            this.fileHandler.handle(file, depth, progressEntry);
        }
        progressEntry.removeChild(file);
    }

    protected void handleDirectoryEnd(Path directory, int depth) {
        if (this.fastForward) {
            this.fastForward = false;
            while (this.progress.size() - 1 > depth) {
                this.progress.pop();
            }
        }
        this.progress.pop();
        if (!this.progress.isEmpty()) {
            this.progress.peek().removeChild(directory);
        }
    }

    private void handleRestrictedDirectory(Path directory, int depth) throws IOException {
        if (this.fastForward) {
            return;
        }
        ProgressEntry parent = this.progress.peek();
        this.restrictedDirectoryHandler.handle(directory, depth, parent);
        if (!this.progress.isEmpty()) {
            this.progress.peek().removeChild(directory);
        }
    }

    public void setFileHandler(FileWalkerHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setDirectoryHandler(FileWalkerHandler directoryHandler) {
        this.directoryHandler = directoryHandler;
    }

    public void setRestrictedDirectoryHandler(FileWalkerHandler restrictedDirectoryHandler) {
        this.restrictedDirectoryHandler = restrictedDirectoryHandler;
    }

    Deque<ProgressEntry> progress() {
        return this.progress;
    }

    void setProgress(Deque<ProgressEntry> progress) {
        this.progress = progress;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class ProgressEntry {
        @XmlAttribute(name="Id")
        private long id;
        @XmlAttribute(name="Prefix")
        private String prefix;
        private Path directory;
        private Path[] children;

        ProgressEntry() {
        }

        ProgressEntry(Path directory, long id, String prefix, Path[] children) {
            this.directory = directory;
            this.id = id;
            this.prefix = prefix;
            this.children = children;
        }

        ProgressEntry(Path directory, ResourceId resourceId, Path[] children) {
            if (resourceId == null) {
                throw new IllegalArgumentException("Cannot construct a ProgressEntry with a null ResourceId");
            }
            this.directory = directory;
            this.id = resourceId.getId();
            this.prefix = resourceId.getPath();
            this.children = children;
        }

        @XmlElement(name="Uri")
        public URI getUri() {
            return this.directory.toUri();
        }

        public void setUri(URI theDirectory) {
            this.directory = Paths.get(theDirectory);
        }

        @XmlElementWrapper(name="Children")
        @XmlElement(name="ChildUri")
        public List<URI> getChildUri() {
            ArrayList<URI> result = new ArrayList<URI>();
            if (this.children != null) {
                for (Path child : this.children) {
                    if (child == null) continue;
                    result.add(child.toUri());
                }
            }
            return result;
        }

        public void setChildUri(List<URI> childURIs) {
            if (childURIs != null) {
                this.children = new Path[childURIs.size()];
                for (int i = 0; i < childURIs.size(); ++i) {
                    this.children[i] = Paths.get(childURIs.get(i));
                }
            }
        }

        public long getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ResourceId getResourceId() {
            return new ResourceId(this.id, this.prefix);
        }

        public Path getFile() {
            return this.directory;
        }

        private void removeChild(Path child) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!child.equals(this.children[i])) continue;
                    this.children[i] = null;
                    break;
                }
            }
        }

        public boolean containsChild(Path child) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!child.equals(this.children[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

