/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.submitter.SubmissionQueue;
import uk.gov.nationalarchives.droid.submitter.SubmissionQueueData;

public class JaxBSubmissionQueueDao
implements SubmissionQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String targetFileName;
    private final JAXBContext context;
    private SubmissionQueueData queue = new SubmissionQueueData();

    public JaxBSubmissionQueueDao() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{SubmissionQueueData.class});
    }

    @Override
    public SubmissionQueueData list() {
        Path in = Paths.get(this.targetFileName, new String[0]);
        if (Files.exists(in, new LinkOption[0])) {
            try {
                Unmarshaller unmarshaller = this.context.createUnmarshaller();
                return (SubmissionQueueData)unmarshaller.unmarshal(in.toFile());
            }
            catch (JAXBException e) {
                this.log.error(e.getErrorCode(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public synchronized void save() {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.queue, Paths.get(this.targetFileName, new String[0]).toFile());
        }
        catch (JAXBException e) {
            this.log.error(e.getErrorCode(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    @Override
    public synchronized void add(RequestIdentifier request) {
        this.queue.add(request);
    }

    @Override
    public synchronized void remove(RequestIdentifier request) {
        this.queue.remove(request);
    }
}

