/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.submitter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.submitter.ProfileWalkState;
import uk.gov.nationalarchives.droid.util.FileUtil;

public class ProfileWalkerDao {
    private static final String FILE_WALKER_XML = "profile_progress.xml";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final JAXBContext context;
    private Path profileHomeDir;

    public ProfileWalkerDao() throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{ProfileWalkState.class});
    }

    public ProfileWalkerDao(Path profileHomeDir) throws JAXBException {
        this.setProfileHomeDir(profileHomeDir);
        this.context = JAXBContext.newInstance((Class[])new Class[]{ProfileWalkState.class});
    }

    public ProfileWalkState load() {
        Path xml = this.profileHomeDir.resolve(FILE_WALKER_XML);
        if (Files.exists(xml, new LinkOption[0])) {
            try {
                Unmarshaller unmarshaller = this.context.createUnmarshaller();
                ProfileWalkState walkState = (ProfileWalkState)unmarshaller.unmarshal(xml.toFile());
                return walkState;
            }
            catch (JAXBException e) {
                this.log.error(e.getErrorCode(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new ProfileWalkState();
    }

    public void save(ProfileWalkState walkState) {
        Path xml = this.profileHomeDir.resolve(FILE_WALKER_XML);
        try {
            Marshaller m = this.context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)walkState, xml.toFile());
        }
        catch (PropertyException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            this.log.error(e.getErrorCode(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        Path xml = this.profileHomeDir.resolve(FILE_WALKER_XML);
        if (!FileUtil.deleteQuietly(xml)) {
            String message = String.format("Could not delete file walker xml file: %s. Will try to delete on exit.", xml.toAbsolutePath().toString());
            this.log.warn(message);
            xml.toFile().deleteOnExit();
        }
    }

    public void setProfileHomeDir(Path profileHomeDir) {
        this.profileHomeDir = profileHomeDir;
    }
}

