/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.byteseek.compiler.CompileException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceAnchor;
import uk.gov.nationalarchives.droid.core.signature.compiler.ByteSequenceCompiler;
import uk.gov.nationalarchives.droid.core.signature.compiler.SignatureType;
import uk.gov.nationalarchives.droid.tools.SigUtils;

public final class SigTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SigTool.class);
    private static final String PRONOM_OPTION = "p";
    private static final String BINARY_OPTION = "b";
    private static final String SPACE_OPTION = "s";
    private static final String FILE_OPTION = "f";
    private static final String NOTABS_OPTION = "n";
    private static final String ANCHOR_OPTION = "a";
    private static final String HELP_OPTION = "h";
    private static final String XML_OPTION = "x";
    private static final String EXPRESSION_OUTPUT = "e";
    private static final String EXPRESSION_OPTION = "e";
    private static final String CONTAINER_OPTION = "c";
    private static final String DROID_OPTION = "d";
    private static final String MATCH_OPTION = "m";
    private static final String OUTPUT_FILE = "o";
    private static final String INTERNAL_FILE = "i";
    private static final int SUCCESS = 0;
    private static final int FAILED_TO_PARSE_ARGUMENTS = 1;
    private static final int ANCHOR_VALUE_INCORRECT = 2;
    private static final int IO_EXCEPTION = 3;
    private static final int PARSE_ERROR = 4;
    private static final int COMPILE_ERROR = 5;

    private SigTool() {
    }

    public static void main(String[] args) {
        int returnCode = SigTool.executeArguments(args);
        System.exit(returnCode);
    }

    private static int executeArguments(String[] args) {
        int exitCode;
        DefaultParser parser = new DefaultParser();
        try {
            Options options = SigTool.createOptions();
            if (args.length == 0) {
                SigTool.printHelp(options);
                exitCode = 0;
            } else {
                CommandLine cli = parser.parse(options, args);
                exitCode = SigTool.processCommands(cli, options);
            }
        }
        catch (ParseException e) {
            System.err.println("ERROR: " + e.getMessage());
            exitCode = 1;
        }
        return exitCode;
    }

    private static int processCommands(CommandLine cli, Options options) {
        ByteSequenceAnchor anchorType;
        int exitCode = 0;
        if (cli.hasOption(HELP_OPTION)) {
            SigTool.printHelp(options);
        }
        ByteSequenceCompiler.CompileType compileType = cli.hasOption(PRONOM_OPTION) ? ByteSequenceCompiler.CompileType.PRONOM : ByteSequenceCompiler.CompileType.DROID;
        SignatureType sigType = cli.hasOption(BINARY_OPTION) ? SignatureType.BINARY : SignatureType.CONTAINER;
        boolean spaceElements = cli.hasOption(SPACE_OPTION);
        boolean processSigFiles = cli.hasOption(FILE_OPTION);
        boolean outputFile = cli.hasOption(OUTPUT_FILE);
        boolean noTabs = cli.hasOption(NOTABS_OPTION);
        ByteSequenceAnchor byteSequenceAnchor = anchorType = cli.hasOption(ANCHOR_OPTION) ? SigTool.getAnchor(cli.getOptionValue(ANCHOR_OPTION)) : ByteSequenceAnchor.BOFOffset;
        if (anchorType == null) {
            System.err.println("The value provided for the --anchor " + cli.getOptionValue(ANCHOR_OPTION) + " is not recognised.  Must be bofoffset, eofoffset or variable.");
            exitCode = 2;
        } else {
            try {
                SigTool.processCommands(outputFile, cli, processSigFiles, compileType, sigType, anchorType, spaceElements, noTabs);
            }
            catch (IOException e) {
                exitCode = 3;
                System.err.println("IO ERROR: " + e.getMessage());
            }
            catch (SignatureParseException e) {
                exitCode = 4;
                System.err.println("PARSE ERROR: " + e.getMessage());
            }
            catch (CompileException e) {
                exitCode = 5;
                System.err.println("COMPILE ERROR: " + e.getMessage());
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(boolean outputFile, CommandLine cli, boolean processSigFiles, ByteSequenceCompiler.CompileType compileType, SignatureType sigType, ByteSequenceAnchor anchorType, boolean spaceElements, boolean noTabs) throws IOException, SignatureParseException, CompileException {
        try (PrintStream output = outputFile ? SigTool.createOutputFile(cli.getOptionValue(OUTPUT_FILE)) : System.out;){
            if (processSigFiles) {
                SigTool.processSigFiles(cli, output, sigType, spaceElements, noTabs);
            } else if (cli.hasOption(MATCH_OPTION)) {
                SigTool.matchFiles(cli, output, anchorType);
            } else if (cli.hasOption("e")) {
                SigUtils.convertExpressionSyntax(output, cli.getArgList(), sigType, spaceElements, noTabs);
            } else {
                SigUtils.convertExpressionsToXML(output, cli.getArgList(), compileType, sigType, anchorType, noTabs);
            }
        }
    }

    private static void processSigFiles(CommandLine cli, PrintStream output, SignatureType sigType, boolean spaceElements, boolean noTabs) throws IOException, SignatureParseException {
        if (cli.hasOption("e")) {
            SigUtils.summariseSignatures(output, cli.getOptionValue(FILE_OPTION), sigType, spaceElements, noTabs);
        } else {
            SigUtils.convertSignatureFileToNewFormat(output, cli.getOptionValue(FILE_OPTION), sigType, spaceElements);
        }
    }

    private static void matchFiles(CommandLine cli, PrintStream output, ByteSequenceAnchor anchorType) throws IOException, CompileException, SignatureParseException {
        if (cli.hasOption(INTERNAL_FILE)) {
            if (cli.getArgList().size() == 0) {
                throw new SignatureParseException("No container signature specified.");
            }
            String signature = (String)cli.getArgList().get(0);
            SigUtils.matchContainerFile(output, signature, cli.getOptionValue(INTERNAL_FILE), anchorType, cli.getOptionValue(MATCH_OPTION));
        } else {
            SigUtils.matchExpressions(output, cli.getArgList(), anchorType, cli.getOptionValue(MATCH_OPTION));
        }
    }

    private static PrintStream createOutputFile(String filename) throws FileNotFoundException {
        File file = new File(filename);
        FileOutputStream fos = new FileOutputStream(file);
        return new PrintStream(fos);
    }

    private static ByteSequenceAnchor getAnchor(String anchorText) {
        ByteSequenceAnchor anchor;
        switch (anchorText.toLowerCase()) {
            case "bofoffset": {
                anchor = ByteSequenceAnchor.BOFOffset;
                break;
            }
            case "eofoffset": {
                anchor = ByteSequenceAnchor.EOFOffset;
                break;
            }
            default: {
                anchor = ByteSequenceAnchor.VariableOffset;
            }
        }
        return anchor;
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(new Option(HELP_OPTION, "help", false, "Prints help on commands."));
        options.addOption(new Option(SPACE_OPTION, "spaces", false, "Signature elements have spaces between them."));
        options.addOption(new Option(NOTABS_OPTION, "notabs", false, "Don't include tab separated metadata - just output the expressions."));
        options.addOption(new Option(ANCHOR_OPTION, "anchor", true, "Where a signature is anchored - BOFoffset, EOFoffset or Variable.Defaults to BOFoffset if not set."));
        options.addOption(new Option(OUTPUT_FILE, "output", true, "Specifies a file to output the results to.  If not specified, will output to console."));
        options.addOption(new Option(INTERNAL_FILE, "internal", true, "The path of an internal file if matching container signatures."));
        SigTool.addOptionGroups(options, SigTool.buildFileOptions(), SigTool.buildOutputOptions(), SigTool.buildSignatureOptions(), SigTool.buildCompileOptions());
        return options;
    }

    private static OptionGroup buildCompileOptions() {
        OptionGroup compileTypeOptions = new OptionGroup();
        Option droidCompile = new Option(DROID_OPTION, "droid", false, "Signatures are compiled for DROID.");
        Option pronomCompile = new Option(PRONOM_OPTION, "pronom", false, "Signatures are compiled for PRONOM.");
        compileTypeOptions.addOption(droidCompile);
        compileTypeOptions.addOption(pronomCompile);
        return compileTypeOptions;
    }

    private static OptionGroup buildSignatureOptions() {
        OptionGroup sigTypeOptions = new OptionGroup();
        Option binarySignatures = new Option(BINARY_OPTION, "binary", false, "Signatures are in binary syntax.");
        Option containerSignatures = new Option(CONTAINER_OPTION, "container", false, "Signatures are in container syntax.");
        sigTypeOptions.addOption(binarySignatures);
        sigTypeOptions.addOption(containerSignatures);
        return sigTypeOptions;
    }

    private static OptionGroup buildOutputOptions() {
        OptionGroup outputOptions = new OptionGroup();
        Option xmlOutput = new Option(XML_OPTION, "xml", false, "Output is in XML format");
        Option expressionOutput = new Option("e", "expression", false, "Output is a regular expression");
        outputOptions.addOption(xmlOutput);
        outputOptions.addOption(expressionOutput);
        return outputOptions;
    }

    private static OptionGroup buildFileOptions() {
        OptionGroup fileOptions = new OptionGroup();
        Option fileInput = new Option(FILE_OPTION, "file", true, "Filename of signature file to process.");
        Option matchFile = new Option(MATCH_OPTION, "match", true, "Filename of a file to match the signature against.");
        fileOptions.addOption(fileInput);
        fileOptions.addOption(matchFile);
        return fileOptions;
    }

    private static void addOptionGroups(Options options, OptionGroup ... groups) {
        for (OptionGroup group : groups) {
            options.addOptionGroup(group);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("sigTool [Options] {expressions|filename}", options);
    }
}

