/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.awt.Frame;
import java.util.Map;
import javax.swing.JOptionPane;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;

public final class DialogUtils {
    private static final String SIGNATURE_UPDATE = "Signature update";

    private DialogUtils() {
    }

    static int showUpdateAvailableDialog(Frame parent, SignatureFileInfo sigFileInfo) {
        return JOptionPane.showConfirmDialog(parent, String.format("%s signature update v.%s is available. Do you want to download it?", sigFileInfo.getType(), sigFileInfo.getVersion()), SIGNATURE_UPDATE, 0, 3);
    }

    public static void showUpdateSuccessfulDialog(Frame parent, Map<SignatureType, SignatureFileInfo> signatureFileInfo) {
        StringBuilder sb = new StringBuilder();
        for (SignatureFileInfo info : signatureFileInfo.values()) {
            sb.append(String.format("Signature file %s downloaded successfully.\n", info));
        }
        JOptionPane.showMessageDialog(parent, sb.toString(), SIGNATURE_UPDATE, 1);
    }

    static void showNothingIsSelectedForRemoveDialog(Frame parent) {
        JOptionPane.showMessageDialog(parent, "Nothing is selected to remove.", "Nothing selected to remove.", 1);
    }

    static void showUpdateUnavailableDialog(Frame parent) {
        JOptionPane.showMessageDialog(parent, "No new signature files are available.", SIGNATURE_UPDATE, 1);
    }

    public static void showSignatureUpdateErrorDialog(Frame parent, Throwable e) {
        JOptionPane.showMessageDialog(parent, "Error occurred while establishing a connection to Pronom server.\nCheck URL and proxy setting in Tools -> Preferences -> Signature Updates\nError detail : " + e.getLocalizedMessage(), SIGNATURE_UPDATE, 0);
    }

    public static void showGeneralErrorDialog(Frame parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }
}

