/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.SwingHelpUtilities;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.joda.time.DateTime;
import org.openide.util.NbBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.config.RuntimeConfig;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;
import uk.gov.nationalarchives.droid.gui.DialogUtils;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ExitListener;
import uk.gov.nationalarchives.droid.gui.FileSystemSelectionValidator;
import uk.gov.nationalarchives.droid.gui.GlobalContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.SaveAllProfilesDialog;
import uk.gov.nationalarchives.droid.gui.SpringGuiContext;
import uk.gov.nationalarchives.droid.gui.action.ActionDoneCallback;
import uk.gov.nationalarchives.droid.gui.action.ActionFactory;
import uk.gov.nationalarchives.droid.gui.action.AddFilesAndFoldersAction;
import uk.gov.nationalarchives.droid.gui.action.ApplyFilterToTreeTableAction;
import uk.gov.nationalarchives.droid.gui.action.ExitAction;
import uk.gov.nationalarchives.droid.gui.action.LoadProfileWorker;
import uk.gov.nationalarchives.droid.gui.action.NewProfileAction;
import uk.gov.nationalarchives.droid.gui.action.OpenContainingFolderAction;
import uk.gov.nationalarchives.droid.gui.action.RemoveFilesAndFoldersAction;
import uk.gov.nationalarchives.droid.gui.action.StopRunningProfilesAction;
import uk.gov.nationalarchives.droid.gui.config.ConfigDialog;
import uk.gov.nationalarchives.droid.gui.config.InstallSignatureFileAction;
import uk.gov.nationalarchives.droid.gui.config.SignatureInstallDialog;
import uk.gov.nationalarchives.droid.gui.event.ButtonManager;
import uk.gov.nationalarchives.droid.gui.export.ExportAction;
import uk.gov.nationalarchives.droid.gui.export.ExportDialog;
import uk.gov.nationalarchives.droid.gui.export.ExportFileChooser;
import uk.gov.nationalarchives.droid.gui.export.ExportProgressDialog;
import uk.gov.nationalarchives.droid.gui.filechooser.ProfileFileChooser;
import uk.gov.nationalarchives.droid.gui.filechooser.ResourceSelectorDialog;
import uk.gov.nationalarchives.droid.gui.filter.FilterDialog;
import uk.gov.nationalarchives.droid.gui.filter.FilterFileChooser;
import uk.gov.nationalarchives.droid.gui.report.ReportAction;
import uk.gov.nationalarchives.droid.gui.report.ReportDialog;
import uk.gov.nationalarchives.droid.gui.report.ReportProgressDialog;
import uk.gov.nationalarchives.droid.gui.report.ReportViewFrame;
import uk.gov.nationalarchives.droid.gui.signature.CheckSignatureUpdateAction;
import uk.gov.nationalarchives.droid.gui.signature.UpdateSignatureAction;
import uk.gov.nationalarchives.droid.planets.gui.PlanetXMLFileFilter;
import uk.gov.nationalarchives.droid.planets.gui.PlanetXMLProgressDialog;
import uk.gov.nationalarchives.droid.profile.FilterImpl;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileManagerException;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileState;
import uk.gov.nationalarchives.droid.report.ReportTransformer;
import uk.gov.nationalarchives.droid.report.ReportTransformerImpl;

public class DroidMainFrame
extends JFrame {
    private static final String ERROR_TITLE = "Error";
    private static final String STATE = "state";
    private static final long serialVersionUID = 8170787911864425667L;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ProfileManager profileManager;
    private DroidUIContext droidContext;
    private JFileChooser profileFileChooser = new ProfileFileChooser();
    private JFileChooser filterFileChooser;
    private ResourceSelectorDialog resourceFileChooser;
    private ButtonManager buttonManager;
    private ConfigDialog configDialog;
    private GlobalContext globalContext;
    private JFileChooser exportFileChooser;
    private SignatureInstallDialog signatureInstallDialog;
    private ReportDialog reportDialog;
    private Set<ExitListener> exitListeners = new HashSet<ExitListener>();
    private JToolBar droidToolBar;
    private JCheckBoxMenuItem filterEnabledMenuItem;
    private JMenuItem generateReportMenuItem;
    private JMenuItem helpMenuItem;
    protected JButton jButtonAddFile;
    private JButton jButtonExport;
    private JButton jButtonFilter;
    private JButton jButtonNewProfile;
    protected JButton jButtonOpenProfile;
    protected JButton jButtonRemoveFilesAndFolder;
    private JButton jButtonReport;
    protected JButton jButtonSaveProfile;
    protected JButton jButtonStart;
    private JButton jButtonStop;
    private JCheckBox jFilterOnCheckBox;
    private JMenuBar jMenuBar1;
    private JMenu jMenuEdit;
    private JMenuItem jMenuEditFilter;
    private JMenu jMenuFile;
    private JMenu jMenuFilter;
    protected JMenuItem jMenuItemAddFileOrFolders;
    private JMenuItem jMenuItemCopyFilterToAll;
    private JMenuItem jMenuItemCopyToClipboard;
    private JMenuItem jMenuItemExpandChildren;
    private JMenuItem jMenuItemExpandNextThree;
    protected JMenuItem jMenuItemExport;
    protected JMenuItem jMenuItemNew;
    protected JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemOpenFolder;
    protected JMenuItem jMenuItemRemoveFolder;
    protected JMenuItem jMenuItemStart;
    protected JMenuItem jMenuItemStop;
    private JMenuItem jMenuQuit;
    private JMenu jMenuReport;
    private JMenu jMenuRun;
    protected JMenuItem jMenuSave;
    protected JMenuItem jMenuSaveAs;
    private JMenu jMenuTools;
    private JPanel jPanel1;
    private JTabbedPane jProfilesTabbedPane;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator12;
    private JToolBar.Separator jSeparator13;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JMenu jhelp;
    private JMenuItem settingsMenuItem;
    private JMenuItem signatureInstallMenuItem;
    private JMenuItem updateNowMenuItem;

    public static void main(String[] args) {
        RuntimeConfig.configureRuntimeEnvironment();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame.setDefaultLookAndFeelDecorated(true);
                DroidMainFrame main = new DroidMainFrame();
                main.setVisible(false);
                main.init();
                main.setVisible(true);
                main.checkSignatureUpdates();
                main.createDefaultProfile();
            }
        });
    }

    void checkSignatureUpdates() {
        PropertiesConfiguration properties = this.globalContext.getGlobalConfig().getProperties();
        boolean autoCheck = properties.getBoolean(DroidGlobalProperty.UPDATE_AUTO_CHECK.getName());
        boolean checkNow = properties.getBoolean(DroidGlobalProperty.UPDATE_ON_STARTUP.getName());
        if (autoCheck) {
            String logMessage = "Checking for new signature updates on startup.";
            if (!checkNow) {
                long lastUpdated = properties.getLong(DroidGlobalProperty.LAST_UPDATE_CHECK.getName());
                int updateInterval = properties.getInt(DroidGlobalProperty.UPDATE_FREQUENCY_DAYS.getName());
                DateTime lastUpdateTime = new DateTime(lastUpdated);
                checkNow = lastUpdateTime.plusDays(updateInterval).isBeforeNow();
                logMessage = String.format("Checking for new signature updates -last update check was on: %s", lastUpdateTime.toString("E yyyy-MM-dd"));
            }
            if (checkNow) {
                this.log.info(logMessage);
                ActionFactory actionFactory = this.globalContext.getActionFactory();
                CheckSignatureUpdateAction checkUpdatedSignatureAction = actionFactory.newCheckSignatureUpdateAction();
                checkUpdatedSignatureAction.start(this);
                Map<SignatureType, SignatureFileInfo> availableUpdates = checkUpdatedSignatureAction.getSignatureFileInfos();
                if (!checkUpdatedSignatureAction.hasError() && availableUpdates != null && !availableUpdates.isEmpty()) {
                    Collection<SignatureFileInfo> filesToUpdate;
                    boolean showPrompt = properties.getBoolean("update.downloadPrompt");
                    Collection<SignatureFileInfo> collection = filesToUpdate = showPrompt ? this.promptForUpdate(availableUpdates.values()) : availableUpdates.values();
                    if (!filesToUpdate.isEmpty()) {
                        UpdateSignatureAction downloadAction = actionFactory.newSignaureUpdateAction();
                        downloadAction.setUpdates(filesToUpdate);
                        downloadAction.start(this);
                    }
                }
                properties.setProperty(DroidGlobalProperty.LAST_UPDATE_CHECK.getName(), (Object)System.currentTimeMillis());
                try {
                    properties.save();
                }
                catch (ConfigurationException e) {
                    this.log.warn("Could not save the last update check time to the file: " + properties.getPath());
                }
            }
        }
    }

    private List<SignatureFileInfo> promptForUpdate(Collection<SignatureFileInfo> signatureFileInfos) {
        ArrayList<SignatureFileInfo> filesToUpdate = new ArrayList<SignatureFileInfo>();
        for (SignatureFileInfo sigFileInfo : signatureFileInfos) {
            if (sigFileInfo.hasError()) {
                DialogUtils.showSignatureUpdateErrorDialog(this, (Throwable)sigFileInfo.getError());
                continue;
            }
            if (DialogUtils.showUpdateAvailableDialog(this, sigFileInfo) != 0) continue;
            filesToUpdate.add(sigFileInfo);
        }
        return filesToUpdate;
    }

    private void createDefaultProfile() {
        final NewProfileAction newProfileAction = new NewProfileAction(this.droidContext, this.profileManager, this.jProfilesTabbedPane);
        newProfileAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DroidMainFrame.STATE.equals(evt.getPropertyName()) && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                    DroidMainFrame.this.exitListeners.remove(newProfileAction);
                }
            }
        });
        this.exitListeners.add(newProfileAction);
        ProfileForm profileForm = new ProfileForm(this, this.droidContext, this.buttonManager);
        try {
            newProfileAction.init(profileForm);
            newProfileAction.execute();
        }
        catch (ProfileManagerException e) {
            DialogUtils.showGeneralErrorDialog(this, ERROR_TITLE, e.getMessage());
        }
    }

    private void init() {
        this.log.info("Starting DROID.");
        URL icon = this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/DROID16.gif");
        this.setIconImage(new ImageIcon(icon).getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DroidMainFrame.this.exit();
            }
        });
        this.initComponents();
        this.setLocationRelativeTo(null);
        try {
            SwingHelpUtilities.setContentViewerUI((String)"uk.gov.nationalarchives.droid.gui.help.ExternalLinkContentViewerUI");
            HelpSet hs = this.getHelpSet("helpset.hs");
            HelpBroker hb = hs.createHelpBroker();
            CSH.setHelpIDString((Component)this.helpMenuItem, (String)"Welcome to DROID");
            this.helpMenuItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
        }
        catch (HelpSetException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.globalContext = new SpringGuiContext();
        this.profileManager = this.globalContext.getProfileManager();
        this.configDialog = new ConfigDialog((Frame)this, this.globalContext);
        this.droidContext = new DroidUIContext(this.jProfilesTabbedPane, this.profileManager);
        this.exportFileChooser = new ExportFileChooser();
        this.filterFileChooser = new FilterFileChooser(this.globalContext.getGlobalConfig().getFilterDir().toFile());
        this.signatureInstallDialog = new SignatureInstallDialog((Window)this);
        this.resourceFileChooser = new ResourceSelectorDialog((Window)this);
        this.resourceFileChooser.setModal(true);
        this.reportDialog = new ReportDialog(this);
        this.initButtons();
    }

    private HelpSet getHelpSet(String helpsetfile) throws HelpSetException {
        HelpSet hs = null;
        ClassLoader cl = this.getClass().getClassLoader();
        URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetfile);
        hs = new HelpSet(null, hsURL);
        return hs;
    }

    private void initButtons() {
        this.buttonManager = new ButtonManager(this.droidContext);
        this.buttonManager.addCreateComponent(this.jButtonNewProfile);
        this.buttonManager.addCreateComponent(this.jMenuItemNew);
        this.buttonManager.addLoadComponent(this.jButtonOpenProfile);
        this.buttonManager.addLoadComponent(this.jMenuItemOpen);
        this.buttonManager.addSaveComponent(this.jButtonSaveProfile);
        this.buttonManager.addSaveComponent(this.jMenuSave);
        this.buttonManager.addSaveAsComponent(this.jMenuSaveAs);
        this.buttonManager.addRunComponent(this.jButtonStart);
        this.buttonManager.addRunComponent(this.jMenuItemStart);
        this.buttonManager.addStopComponent(this.jButtonStop);
        this.buttonManager.addStopComponent(this.jMenuItemStop);
        this.buttonManager.addResourceComponent(this.jButtonAddFile);
        this.buttonManager.addResourceComponent(this.jButtonRemoveFilesAndFolder);
        this.buttonManager.addResourceComponent(this.jMenuItemAddFileOrFolders);
        this.buttonManager.addResourceComponent(this.jMenuItemRemoveFolder);
        this.buttonManager.addExportComponent(this.jMenuItemExport);
        this.buttonManager.addExportComponent(this.jButtonExport);
        this.buttonManager.addFilterComponent(this.jMenuEditFilter);
        this.buttonManager.addFilterComponent(this.filterEnabledMenuItem);
        this.buttonManager.addFilterComponent(this.jButtonFilter);
        this.buttonManager.addFilterComponent(this.jMenuItemCopyFilterToAll);
        this.buttonManager.addFilterEnabledComponent(this.jFilterOnCheckBox);
        this.buttonManager.addReportComponent(this.jButtonReport);
        this.buttonManager.addReportComponent(this.generateReportMenuItem);
        this.buttonManager.fireEvent(null);
    }

    private void initComponents() {
        this.jProfilesTabbedPane = new JTabbedPane();
        this.droidToolBar = new JToolBar();
        this.jButtonNewProfile = new JButton();
        this.jButtonOpenProfile = new JButton();
        this.jButtonSaveProfile = new JButton();
        this.jButtonExport = new JButton();
        this.jSeparator13 = new JToolBar.Separator();
        this.jButtonAddFile = new JButton();
        this.jButtonRemoveFilesAndFolder = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.jButtonStart = new JButton();
        this.jButtonStop = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.jButtonFilter = new JButton();
        this.jPanel1 = new JPanel();
        this.jFilterOnCheckBox = new JCheckBox();
        this.jSeparator10 = new JToolBar.Separator();
        this.jButtonReport = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemNew = new JMenuItem();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuSave = new JMenuItem();
        this.jMenuSaveAs = new JMenuItem();
        this.jMenuItemExport = new JMenuItem();
        this.jMenuQuit = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMenuEdit = new JMenu();
        this.jMenuItemAddFileOrFolders = new JMenuItem();
        this.jMenuItemRemoveFolder = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemOpenFolder = new JMenuItem();
        this.jMenuItemCopyToClipboard = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemExpandChildren = new JMenuItem();
        this.jMenuItemExpandNextThree = new JMenuItem();
        this.jMenuRun = new JMenu();
        this.jMenuItemStart = new JMenuItem();
        this.jMenuItemStop = new JMenuItem();
        this.jMenuFilter = new JMenu();
        this.filterEnabledMenuItem = new JCheckBoxMenuItem();
        this.jSeparator8 = new JSeparator();
        this.jMenuEditFilter = new JMenuItem();
        this.jMenuItemCopyFilterToAll = new JMenuItem();
        this.jMenuReport = new JMenu();
        this.generateReportMenuItem = new JMenuItem();
        this.jMenuTools = new JMenu();
        this.jSeparator7 = new JSeparator();
        this.updateNowMenuItem = new JMenuItem();
        this.signatureInstallMenuItem = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.settingsMenuItem = new JMenuItem();
        this.jhelp = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle(NbBundle.getMessage(DroidMainFrame.class, (String)"main.title"));
        this.jProfilesTabbedPane.setTabLayoutPolicy(1);
        this.jProfilesTabbedPane.setAutoscrolls(true);
        this.jProfilesTabbedPane.setMaximumSize(null);
        this.jProfilesTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DroidMainFrame.this.jProfilesTabbedPaneStateChanged(evt);
            }
        });
        this.droidToolBar.setFloatable(false);
        this.droidToolBar.setRollover(true);
        this.droidToolBar.setMargin(new Insets(4, 4, 4, 4));
        this.droidToolBar.setMaximumSize(new Dimension(0, 0));
        this.droidToolBar.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DroidMainFrame.this.droidToolBarPropertyChange(evt);
            }
        });
        this.jButtonNewProfile.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/New.png")));
        this.jButtonNewProfile.setText("New");
        this.jButtonNewProfile.setToolTipText("Create new profile");
        this.jButtonNewProfile.setFocusable(false);
        this.jButtonNewProfile.setHorizontalTextPosition(0);
        this.jButtonNewProfile.setVerticalTextPosition(3);
        this.jButtonNewProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonNewProfileActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonNewProfile);
        this.jButtonOpenProfile.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Open file.png")));
        this.jButtonOpenProfile.setText("Open");
        this.jButtonOpenProfile.setToolTipText("Open existing profile");
        this.jButtonOpenProfile.setFocusable(false);
        this.jButtonOpenProfile.setHorizontalTextPosition(0);
        this.jButtonOpenProfile.setVerticalTextPosition(3);
        this.jButtonOpenProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonOpenProfileActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonOpenProfile);
        this.jButtonSaveProfile.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save.png")));
        this.jButtonSaveProfile.setText("Save");
        this.jButtonSaveProfile.setToolTipText("Save profile");
        this.jButtonSaveProfile.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save disabled.png")));
        this.jButtonSaveProfile.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save disabled.png")));
        this.jButtonSaveProfile.setFocusable(false);
        this.jButtonSaveProfile.setHorizontalTextPosition(0);
        this.jButtonSaveProfile.setVerticalTextPosition(3);
        this.jButtonSaveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonSaveProfileActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonSaveProfile);
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Export.png")));
        this.jButtonExport.setText("Export");
        this.jButtonExport.setToolTipText("Export results");
        this.jButtonExport.setFocusable(false);
        this.jButtonExport.setHorizontalTextPosition(0);
        this.jButtonExport.setVerticalTextPosition(3);
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonExportActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonExport);
        this.jSeparator13.setSeparatorSize(new Dimension(20, 40));
        this.droidToolBar.add(this.jSeparator13);
        this.jButtonAddFile.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add.png")));
        this.jButtonAddFile.setText("Add");
        this.jButtonAddFile.setToolTipText("Add files or folders to profile");
        this.jButtonAddFile.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add disabled.png")));
        this.jButtonAddFile.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add disabled.png")));
        this.jButtonAddFile.setFocusable(false);
        this.jButtonAddFile.setHorizontalTextPosition(0);
        this.jButtonAddFile.setVerticalTextPosition(3);
        this.jButtonAddFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonAddFileActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonAddFile);
        this.jButtonRemoveFilesAndFolder.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove.png")));
        this.jButtonRemoveFilesAndFolder.setText("Remove");
        this.jButtonRemoveFilesAndFolder.setToolTipText("Remove files/folders from profile");
        this.jButtonRemoveFilesAndFolder.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove disabled.png")));
        this.jButtonRemoveFilesAndFolder.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove disabled.png")));
        this.jButtonRemoveFilesAndFolder.setFocusable(false);
        this.jButtonRemoveFilesAndFolder.setHorizontalTextPosition(0);
        this.jButtonRemoveFilesAndFolder.setVerticalTextPosition(3);
        this.jButtonRemoveFilesAndFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonRemoveFilesAndFolderActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonRemoveFilesAndFolder);
        this.jSeparator12.setSeparatorSize(new Dimension(20, 40));
        this.droidToolBar.add(this.jSeparator12);
        this.jButtonStart.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Play.png")));
        this.jButtonStart.setText("Start");
        this.jButtonStart.setToolTipText("Run identification");
        this.jButtonStart.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Play disabled.png")));
        this.jButtonStart.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Play disabled.png")));
        this.jButtonStart.setFocusable(false);
        this.jButtonStart.setHorizontalTextPosition(0);
        this.jButtonStart.setVerticalTextPosition(3);
        this.jButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonStartActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonStart);
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Pause.png")));
        this.jButtonStop.setText("Pause");
        this.jButtonStop.setToolTipText("Pause identification");
        this.jButtonStop.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Pause disabled.png")));
        this.jButtonStop.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Pause disabled.png")));
        this.jButtonStop.setFocusable(false);
        this.jButtonStop.setHorizontalTextPosition(0);
        this.jButtonStop.setVerticalTextPosition(3);
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonStopActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonStop);
        this.jSeparator11.setSeparatorSize(new Dimension(20, 40));
        this.droidToolBar.add(this.jSeparator11);
        this.jButtonFilter.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/Filter.png")));
        this.jButtonFilter.setText("Filter");
        this.jButtonFilter.setToolTipText("Define and apply filter to results");
        this.jButtonFilter.setFocusable(false);
        this.jButtonFilter.setHorizontalTextPosition(0);
        this.jButtonFilter.setVerticalTextPosition(3);
        this.jButtonFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonFilterActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonFilter);
        this.jPanel1.setMaximumSize(new Dimension(30, 60));
        this.jPanel1.setMinimumSize(new Dimension(30, 60));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(30, 60));
        this.jFilterOnCheckBox.setText("On");
        this.jFilterOnCheckBox.setFocusable(false);
        this.jFilterOnCheckBox.setHorizontalTextPosition(0);
        this.jFilterOnCheckBox.setInheritsPopupMenu(true);
        this.jFilterOnCheckBox.setMaximumSize(new Dimension(30, 55));
        this.jFilterOnCheckBox.setMinimumSize(new Dimension(30, 55));
        this.jFilterOnCheckBox.setPreferredSize(new Dimension(30, 55));
        this.jFilterOnCheckBox.setVerticalAlignment(3);
        this.jFilterOnCheckBox.setVerticalTextPosition(3);
        this.jFilterOnCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jFilterOnCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jFilterOnCheckBox, -1, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jFilterOnCheckBox, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.droidToolBar.add(this.jPanel1);
        this.jSeparator10.setSeparatorSize(new Dimension(20, 40));
        this.droidToolBar.add(this.jSeparator10);
        this.jButtonReport.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Report.png")));
        this.jButtonReport.setText("Report");
        this.jButtonReport.setToolTipText("Generate a statistical report over the open profiles");
        this.jButtonReport.setFocusable(false);
        this.jButtonReport.setHorizontalTextPosition(0);
        this.jButtonReport.setVerticalTextPosition(3);
        this.jButtonReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jButtonReportActionPerformed(evt);
            }
        });
        this.droidToolBar.add(this.jButtonReport);
        this.jMenuBar1.setPreferredSize(new Dimension(100, 25));
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuFile.setActionCommand("file");
        this.jMenuFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuFileActionPerformed(evt);
            }
        });
        this.jMenuItemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItemNew.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/New small.png")));
        this.jMenuItemNew.setText("New");
        this.jMenuItemNew.setToolTipText("New profile");
        this.jMenuItemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemNewActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemNew);
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpen.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Open file small.png")));
        this.jMenuItemOpen.setText("Open");
        this.jMenuItemOpen.setToolTipText("Open a profile");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuSave.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save small.png")));
        this.jMenuSave.setText("Save");
        this.jMenuSave.setToolTipText("Save a profile");
        this.jMenuSave.setActionCommand("save");
        this.jMenuSave.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/Save Blue 16 d g.gif")));
        this.jMenuSave.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/Save Blue 16 d g.gif")));
        this.jMenuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuSaveActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSave);
        this.jMenuSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.jMenuSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save As small.png")));
        this.jMenuSaveAs.setText("Save As...");
        this.jMenuSaveAs.setToolTipText("Save a profile to a specified file");
        this.jMenuSaveAs.setActionCommand("save");
        this.jMenuSaveAs.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save As small disabled.png")));
        this.jMenuSaveAs.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Save As small disabled.png")));
        this.jMenuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuSaveAsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveAs);
        this.jMenuItemExport.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItemExport.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Export small.png")));
        this.jMenuItemExport.setText("Export all...");
        this.jMenuItemExport.setToolTipText("Export profiles");
        this.jMenuItemExport.setActionCommand("export");
        this.jMenuItemExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemExportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExport);
        this.jMenuQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuQuit.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Quit Small.png")));
        this.jMenuQuit.setText("Quit");
        this.jMenuQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuQuitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuQuit);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuEdit.setMnemonic('E');
        this.jMenuEdit.setText("Edit");
        this.jMenuEdit.setActionCommand("edit");
        this.jMenuEdit.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                DroidMainFrame.this.jMenuEditMenuSelected(evt);
            }
        });
        this.jMenuItemAddFileOrFolders.setAccelerator(KeyStroke.getKeyStroke(107, 2));
        this.jMenuItemAddFileOrFolders.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add small.png")));
        this.jMenuItemAddFileOrFolders.setText("Add file/folders");
        this.jMenuItemAddFileOrFolders.setToolTipText("Add files or folders to a profile");
        this.jMenuItemAddFileOrFolders.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add small disabled.png")));
        this.jMenuItemAddFileOrFolders.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Add small disabled.png")));
        this.jMenuItemAddFileOrFolders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemAddFileOrFoldersActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemAddFileOrFolders);
        this.jMenuItemRemoveFolder.setAccelerator(KeyStroke.getKeyStroke(109, 2));
        this.jMenuItemRemoveFolder.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove small.png")));
        this.jMenuItemRemoveFolder.setText("Remove files/folders");
        this.jMenuItemRemoveFolder.setToolTipText("Remove files or folders from a profile");
        this.jMenuItemRemoveFolder.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove small disabled.png")));
        this.jMenuItemRemoveFolder.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Remove small disabled.png")));
        this.jMenuItemRemoveFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemRemoveFolderActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemRemoveFolder);
        this.jMenuEdit.add(this.jSeparator1);
        this.jMenuItemOpenFolder.setAccelerator(KeyStroke.getKeyStroke(10, 2));
        this.jMenuItemOpenFolder.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/icons/Icon_External_Link.png")));
        this.jMenuItemOpenFolder.setText("Open containing folder...");
        this.jMenuItemOpenFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.OpenContainingFolder(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemOpenFolder);
        this.jMenuItemCopyToClipboard.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItemCopyToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Clipboard small.png")));
        this.jMenuItemCopyToClipboard.setText("Copy to clipboard");
        this.jMenuItemCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemCopyToClipboardActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemCopyToClipboard);
        this.jMenuEdit.add(this.jSeparator2);
        this.jMenuItemExpandChildren.setText("Expand");
        this.jMenuItemExpandChildren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemExpandChildrenActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemExpandChildren);
        this.jMenuItemExpandNextThree.setText("Expand next three levels");
        this.jMenuItemExpandNextThree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemExpandNextThreeActionPerformed(evt);
            }
        });
        this.jMenuEdit.add(this.jMenuItemExpandNextThree);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuRun.setMnemonic('R');
        this.jMenuRun.setText("Run");
        this.jMenuRun.setActionCommand("run");
        this.jMenuItemStart.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.jMenuItemStart.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Play small.png")));
        this.jMenuItemStart.setText("Start identification");
        this.jMenuItemStart.setToolTipText("Start identifying files in the profile");
        this.jMenuItemStart.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Play small disabled.png")));
        this.jMenuItemStart.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Play small disabled.png")));
        this.jMenuItemStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemStartActionPerformed(evt);
            }
        });
        this.jMenuRun.add(this.jMenuItemStart);
        this.jMenuItemStop.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jMenuItemStop.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Pause small.png")));
        this.jMenuItemStop.setText("Pause identification");
        this.jMenuItemStop.setToolTipText("Pause identification in the profile");
        this.jMenuItemStop.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Pause small disabled.png")));
        this.jMenuItemStop.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Pause small disabled.png")));
        this.jMenuItemStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemStopActionPerformed(evt);
            }
        });
        this.jMenuRun.add(this.jMenuItemStop);
        this.jMenuBar1.add(this.jMenuRun);
        this.jMenuFilter.setMnemonic('l');
        this.jMenuFilter.setText("Filter");
        this.jMenuFilter.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                DroidMainFrame.this.jMenuFilterMenuSelected(evt);
            }
        });
        this.filterEnabledMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.filterEnabledMenuItem.setText("Filter on");
        this.filterEnabledMenuItem.setToolTipText("Toggles filtering on or off in the profile");
        this.filterEnabledMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.filterEnabledMenuItemActionPerformed(evt);
            }
        });
        this.jMenuFilter.add(this.filterEnabledMenuItem);
        this.jMenuFilter.add(this.jSeparator8);
        this.jMenuEditFilter.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.jMenuEditFilter.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Filter small.png")));
        this.jMenuEditFilter.setText("Edit filter...");
        this.jMenuEditFilter.setToolTipText("Edit the filter for a profile");
        this.jMenuEditFilter.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Filter small disabled.png")));
        this.jMenuEditFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuEditFilterActionPerformed(evt);
            }
        });
        this.jMenuFilter.add(this.jMenuEditFilter);
        this.jMenuItemCopyFilterToAll.setText("Copy filter to all profiles...");
        this.jMenuItemCopyFilterToAll.setToolTipText("Copies the filter in the current profile to all open profiles");
        this.jMenuItemCopyFilterToAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuItemCopyFilterToAllActionPerformed(evt);
            }
        });
        this.jMenuFilter.add(this.jMenuItemCopyFilterToAll);
        this.jMenuBar1.add(this.jMenuFilter);
        this.jMenuReport.setMnemonic('p');
        this.jMenuReport.setText("Report");
        this.jMenuReport.setActionCommand("report");
        this.generateReportMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.generateReportMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Report small.png")));
        this.generateReportMenuItem.setText("Generate Report...");
        this.generateReportMenuItem.setToolTipText("Generates a report in DROID XML format");
        this.generateReportMenuItem.setDisabledIcon(new ImageIcon(this.getClass().getResource("/uk/gov/nationalarchives/droid/OldIcons/Report small disabled.png")));
        this.generateReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.generateReportMenuItemActionPerformed(evt);
            }
        });
        this.jMenuReport.add(this.generateReportMenuItem);
        this.jMenuBar1.add(this.jMenuReport);
        this.jMenuTools.setMnemonic('T');
        this.jMenuTools.setText("Tools");
        this.jMenuTools.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.jMenuToolsActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jSeparator7);
        this.updateNowMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.updateNowMenuItem.setText("Check for signature updates...");
        this.updateNowMenuItem.setToolTipText("Checks to see if there are updated signatures");
        this.updateNowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.updateNowMenuItemActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.updateNowMenuItem);
        this.signatureInstallMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 3));
        this.signatureInstallMenuItem.setText("Install signature file...");
        this.signatureInstallMenuItem.setToolTipText("Installs a signature file from your local file system");
        this.signatureInstallMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.signatureInstallMenuItemActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.signatureInstallMenuItem);
        this.jMenuTools.add(this.jSeparator6);
        this.settingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.settingsMenuItem.setText("Preferences...");
        this.settingsMenuItem.setToolTipText("Set the DROID preferences");
        this.settingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DroidMainFrame.this.settingsMenuItemActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.settingsMenuItem);
        this.jMenuBar1.add(this.jMenuTools);
        this.jhelp.setMnemonic('H');
        this.jhelp.setText("Help");
        this.jhelp.setActionCommand("help");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.helpMenuItem.setText("Help");
        this.jhelp.add(this.helpMenuItem);
        this.jMenuBar1.add(this.jhelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.droidToolBar, -1, 751, Short.MAX_VALUE).addComponent(this.jProfilesTabbedPane, -1, 751, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.droidToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProfilesTabbedPane, -1, 415, Short.MAX_VALUE)));
        this.pack();
    }

    private void OpenContainingFolder(ActionEvent evt) {
        OpenContainingFolderAction openFolders = new OpenContainingFolderAction();
        openFolders.open(this.getSelectedNodes());
    }

    private void jMenuItemCopyToClipboardActionPerformed(ActionEvent evt) {
        ProfileForm selectedProfile = this.droidContext.getSelectedProfile();
        selectedProfile.copySelectedToClipboard();
    }

    private void jMenuEditMenuSelected(MenuEvent evt) {
        ProfileForm selectedProfile = this.droidContext.getSelectedProfile();
        this.jMenuItemOpenFolder.setEnabled(selectedProfile.anyRowsSelected());
        this.jMenuItemCopyToClipboard.setEnabled(selectedProfile.anyRowsSelected());
    }

    private void jMenuItemExpandChildrenActionPerformed(ActionEvent evt) {
        ProfileForm selectedProfile = this.droidContext.getSelectedProfile();
        selectedProfile.expandSelectedNodes(false);
    }

    private void jMenuItemExpandNextThreeActionPerformed(ActionEvent evt) {
        ProfileForm selectedProfile = this.droidContext.getSelectedProfile();
        selectedProfile.expandSelectedNodes(true);
    }

    private List<ProfileResourceNode> getSelectedNodes() {
        ProfileForm selectedProfile = this.droidContext.getSelectedProfile();
        return selectedProfile.getSelectedNodes();
    }

    private void generateReportMenuItemActionPerformed(ActionEvent evt) {
        this.generateReport();
    }

    private void generateReport() {
        this.reportDialog.showDialog();
        if (this.reportDialog.isApproved()) {
            ReportAction action = this.globalContext.getActionFactory().newReportAction();
            action.setReportSpec(this.reportDialog.getSelectedReportSpec());
            action.setProfileIds(this.reportDialog.getSelectedProfileIds());
            ReportProgressDialog reportProgressDialog = new ReportProgressDialog(this, action);
            ReportViewFrame reportViewDialog = new ReportViewFrame(this);
            ReportTransformerImpl transformer = new ReportTransformerImpl();
            transformer.setConfig(this.globalContext.getGlobalConfig());
            reportViewDialog.setReportTransformer((ReportTransformer)transformer);
            action.setProgressDialog(reportProgressDialog);
            action.setViewDialog(reportViewDialog);
            action.execute();
            reportProgressDialog.showDialog();
        }
    }

    private void jFilterOnCheckBoxActionPerformed(ActionEvent evt) {
        this.setFilterStatus(this.jFilterOnCheckBox.isSelected());
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void jButtonReportActionPerformed(ActionEvent evt) {
        this.generateReport();
    }

    private void jMenuSaveAsActionPerformed(ActionEvent evt) {
        this.saveProfileAsAction(evt);
    }

    private void jMenuQuitActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void filterEnabledMenuItemActionPerformed(ActionEvent evt) {
        this.setFilterStatus(this.filterEnabledMenuItem.isSelected());
    }

    private void setFilterStatus(boolean filterStatus) {
        FilterImpl filter = this.getFilter();
        if (filter != null) {
            filter.setEnabled(filterStatus);
        }
        ProfileForm profileToFilter = this.droidContext.getSelectedProfile();
        ApplyFilterToTreeTableAction applyFilter = new ApplyFilterToTreeTableAction(profileToFilter, this.profileManager);
        applyFilter.applyFilter();
        this.updateFilterControls();
    }

    private FilterImpl getFilter() {
        ProfileInstance instance;
        FilterImpl result = null;
        ProfileForm form = this.droidContext.getSelectedProfile();
        if (form != null && (instance = form.getProfile()) != null) {
            result = instance.getFilter();
        }
        return result;
    }

    public void updateFilterControls() {
        FilterImpl filter = this.getFilter();
        if (filter == null || !filter.hasCriteria()) {
            this.filterEnabledMenuItem.setSelected(false);
            this.filterEnabledMenuItem.setEnabled(false);
            this.jFilterOnCheckBox.setSelected(false);
            this.jFilterOnCheckBox.setEnabled(false);
        } else {
            this.filterEnabledMenuItem.setSelected(filter.isEnabled());
            this.jFilterOnCheckBox.setSelected(filter.isEnabled());
        }
    }

    private void jMenuFilterMenuSelected(MenuEvent evt) {
        FilterImpl filter = this.getFilter();
        if (filter == null || !filter.hasCriteria()) {
            this.filterEnabledMenuItem.setSelected(false);
            this.filterEnabledMenuItem.setEnabled(false);
            this.jFilterOnCheckBox.setSelected(false);
            this.jFilterOnCheckBox.setEnabled(false);
        } else {
            this.filterEnabledMenuItem.setEnabled(true);
            if (filter.isEnabled()) {
                this.filterEnabledMenuItem.setSelected(true);
                this.jFilterOnCheckBox.setSelected(true);
            } else {
                this.filterEnabledMenuItem.setSelected(false);
                this.jFilterOnCheckBox.setSelected(false);
            }
        }
    }

    private void signatureInstallMenuItemActionPerformed(ActionEvent evt) {
        this.signatureInstallDialog.setLocationRelativeTo(this);
        this.signatureInstallDialog.setVisible(true);
        if (this.signatureInstallDialog.getResponse() == 1) {
            InstallSignatureFileAction action = this.globalContext.getActionFactory().newInstallSignatureFileAction();
            action.setFileName(this.signatureInstallDialog.getSignatureFilename());
            action.setUseAsDefault(this.signatureInstallDialog.isDefault());
            action.execute(this);
        }
    }

    private void jMenuEditFilterActionPerformed(ActionEvent evt) {
        FilterImpl filter = this.getFilter();
        FilterDialog dialog = new FilterDialog(this, true, filter, this.droidContext, this.profileManager, this.filterFileChooser);
        dialog.setVisible(true);
        this.updateFilterControls();
    }

    private void jButtonOpenProfileActionPerformed(ActionEvent evt) {
        this.openProfileAction(evt);
        this.updateFilterControls();
    }

    private void jMenuItemNewActionPerformed(ActionEvent evt) {
        this.jButtonNewProfileActionPerformed(evt);
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        this.openProfileAction(evt);
        this.updateFilterControls();
    }

    private void jMenuSaveActionPerformed(ActionEvent evt) {
        this.saveProfileAction(evt);
    }

    private void jMenuItemExportActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void jMenuExitActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void jMenuItemStartActionPerformed(ActionEvent evt) {
        this.startProfile();
    }

    private void jMenuItemStopActionPerformed(ActionEvent evt) {
        this.stopProfile();
    }

    private void jMenuItemAddFileOrFoldersActionPerformed(ActionEvent evt) {
        this.jButtonAddFileActionPerformed(evt);
    }

    private void jMenuItemRemoveFolderActionPerformed(ActionEvent evt) {
        this.jButtonRemoveFilesAndFolderActionPerformed(evt);
    }

    private void jButtonSaveProfileActionPerformed(ActionEvent evt) {
        this.saveProfileAction(evt);
    }

    private void jProfilesTabbedPaneStateChanged(ChangeEvent evt) {
        ProfileForm profileForm = this.droidContext.getSelectedProfile();
        this.buttonManager.fireEvent(profileForm == null ? null : profileForm.getProfile());
        this.updateFilterControls();
    }

    private void droidToolBarPropertyChange(PropertyChangeEvent evt) {
    }

    private void jMenuFileActionPerformed(ActionEvent evt) {
    }

    private void jButtonFilterActionPerformed(ActionEvent evt) {
        FilterImpl filter = this.getFilter();
        FilterDialog dialog = new FilterDialog(this, true, filter, this.droidContext, this.profileManager, this.filterFileChooser);
        dialog.setVisible(true);
        this.updateFilterControls();
    }

    private void jMenuItemCopyFilterToAllActionPerformed(ActionEvent evt) {
        FilterImpl filter = this.getFilter();
        Collection<ProfileForm> profileForms = this.droidContext.allProfiles();
        for (ProfileForm profileForm : profileForms) {
            profileForm.getProfile().setFilter((FilterImpl)filter.clone());
            ApplyFilterToTreeTableAction filterProfile = new ApplyFilterToTreeTableAction(profileForm, this.profileManager);
            filterProfile.applyFilter();
        }
    }

    private void settingsMenuItemActionPerformed(ActionEvent evt) {
        Map settings = this.globalContext.getGlobalConfig().getPropertiesMap();
        this.configDialog.init(settings);
        this.configDialog.setVisible(true);
        if (this.configDialog.getResponse() == 1) {
            try {
                this.globalContext.getGlobalConfig().update(this.configDialog.getGlobalConfig());
            }
            catch (ConfigurationException e) {
                this.log.error("Error updating properties: " + e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this.configDialog, NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.error.text"), NbBundle.getMessage(ConfigDialog.class, (String)"ConfigDialog.error.title"), 0);
            }
        }
    }

    private void jMenuToolsActionPerformed(ActionEvent evt) {
    }

    private void updateNowMenuItemActionPerformed(ActionEvent evt) {
        ActionFactory actionFactory = this.globalContext.getActionFactory();
        CheckSignatureUpdateAction checkUpdatedSignatureAction = actionFactory.newCheckSignatureUpdateAction();
        checkUpdatedSignatureAction.start(this);
        Map<SignatureType, SignatureFileInfo> availableUpdates = checkUpdatedSignatureAction.getSignatureFileInfos();
        if (!checkUpdatedSignatureAction.hasError() && !checkUpdatedSignatureAction.isCancelled()) {
            if (!availableUpdates.isEmpty()) {
                if (!this.promptForUpdate(availableUpdates.values()).isEmpty()) {
                    UpdateSignatureAction downloadAction = actionFactory.newSignaureUpdateAction();
                    downloadAction.setUpdates(availableUpdates.values());
                    downloadAction.start(this);
                }
            } else {
                DialogUtils.showUpdateUnavailableDialog(this);
            }
        }
    }

    private void jMenuPlanetsXMLActionPerformed(ActionEvent evt) {
        String profileId = this.droidContext.getSelectedProfile().getProfile().getUuid();
        if (this.droidContext.getSelectedProfile().getProfile().getState().equals((Object)ProfileState.FINISHED) || this.droidContext.getSelectedProfile().getProfile().getState().equals((Object)ProfileState.STOPPED)) {
            String filePath = "";
            JFileChooser c = new JFileChooser();
            c.setDialogTitle("Please provide name of the file.");
            PlanetXMLFileFilter fileFilter = new PlanetXMLFileFilter("xml", "Planet XML");
            c.addChoosableFileFilter(fileFilter);
            int rVal = c.showSaveDialog(this);
            if (rVal == 0) {
                filePath = fileFilter.getExtension(c.getSelectedFile()) == null ? c.getCurrentDirectory().toString() + File.separator + c.getSelectedFile().getName() + ".xml" : c.getSelectedFile().getPath();
                if (!new File(filePath).isFile()) {
                    PlanetXMLProgressDialog planetXMLProgressDialog = new PlanetXMLProgressDialog(this, true, filePath, profileId, this.globalContext.getReportManager());
                    planetXMLProgressDialog.show();
                } else if (JOptionPane.showConfirmDialog(this, "File already exists. Do you want to overwrite.", "File already exists", 0) == 0) {
                    PlanetXMLProgressDialog planetXMLProgressDialog = new PlanetXMLProgressDialog(this, true, filePath, profileId, this.globalContext.getReportManager());
                    planetXMLProgressDialog.setLocationRelativeTo(this);
                    planetXMLProgressDialog.show();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Selected profile not paused or finished.", "Profile state error", 0);
        }
    }

    private void jButtonNewProfileActionPerformed(ActionEvent evt) {
        final NewProfileAction newProfileAction = new NewProfileAction(this.droidContext, this.profileManager, this.jProfilesTabbedPane);
        newProfileAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DroidMainFrame.STATE.equals(evt.getPropertyName()) && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                    DroidMainFrame.this.exitListeners.remove(newProfileAction);
                }
            }
        });
        this.exitListeners.add(newProfileAction);
        try {
            newProfileAction.init(new ProfileForm(this, this.droidContext, this.buttonManager));
            newProfileAction.execute();
        }
        catch (ProfileManagerException e) {
            DialogUtils.showGeneralErrorDialog(this, ERROR_TITLE, e.getMessage());
        }
    }

    public void jButtonAddFileActionPerformed(ActionEvent evt) {
        int returnVal = this.resourceFileChooser.showDialog(this);
        if (returnVal == 0) {
            List<File> selectedFiles = this.resourceFileChooser.getSelectedFiles();
            this.addFilesAndFolders(selectedFiles);
        }
    }

    public void addFilesAndFolders(List<File> files) {
        FileSystemSelectionValidator validator = new FileSystemSelectionValidator(files);
        if (!validator.isSelectionValid()) {
            String error = validator.getErrorMessage();
            DialogUtils.showGeneralErrorDialog(this, ERROR_TITLE, error);
            return;
        }
        AddFilesAndFoldersAction action = new AddFilesAndFoldersAction(this.droidContext, this.profileManager);
        action.add(files, this.resourceFileChooser.isSelectionRecursive());
    }

    public void jButtonRemoveFilesAndFolderActionPerformed(ActionEvent evt) {
        if (this.droidContext.getSelectedProfile().getResultsOutline().getSelectedRows().length == 0) {
            DialogUtils.showNothingIsSelectedForRemoveDialog(this);
        }
        RemoveFilesAndFoldersAction removeAction = new RemoveFilesAndFoldersAction(this.droidContext, this.profileManager);
        removeAction.remove();
    }

    public boolean getAddEnabled() {
        return this.jMenuItemAddFileOrFolders.isEnabled();
    }

    public boolean getRemoveEnabled() {
        return this.jMenuItemRemoveFolder.isEnabled();
    }

    private void jButtonStartActionPerformed(ActionEvent evt) {
        this.startProfile();
    }

    private void jButtonStopActionPerformed(ActionEvent evt) {
        this.stopProfile();
    }

    private void openProfileAction(ActionEvent event) {
        Path selectedFile;
        int result = this.profileFileChooser.showOpenDialog(this);
        if (result == 0 && !this.droidContext.selectProfileWithSource(selectedFile = this.profileFileChooser.getSelectedFile().toPath())) {
            LoadProfileWorker worker = new LoadProfileWorker(this.profileManager, this.droidContext, this.jProfilesTabbedPane);
            worker.setProfileFile(selectedFile);
            worker.init(new ProfileForm(this, this.droidContext, this.buttonManager));
            worker.execute();
        }
    }

    private void saveProfileAction(ActionEvent event) {
        ProfileForm profileForm = this.droidContext.getSelectedProfile();
        profileForm.saveProfile(false);
    }

    private void saveProfileAsAction(ActionEvent event) {
        ProfileForm profileForm = this.droidContext.getSelectedProfile();
        profileForm.saveProfile(true);
    }

    private void startProfile() {
        ProfileForm profileForm = this.droidContext.getSelectedProfile();
        if (profileForm.getProfile().getFilter().isEnabled()) {
            profileForm.getProfile().getFilter().setEnabled(false);
            ApplyFilterToTreeTableAction refreshTreeTable = new ApplyFilterToTreeTableAction(profileForm, this.profileManager);
            refreshTreeTable.applyFilter();
            this.updateFilterControls();
        }
        profileForm.start();
    }

    private void stopProfile() {
        ProfileForm profileForm = this.droidContext.getSelectedProfile();
        profileForm.stop();
    }

    private void export() {
        int response;
        ExportDialog exportOptions = new ExportDialog(this);
        if (this.globalContext.getGlobalConfig().getBooleanProperty(DroidGlobalProperty.CSV_EXPORT_ROW_PER_FORMAT)) {
            exportOptions.setExportOptions(ExportOptions.ONE_ROW_PER_FORMAT);
        } else {
            exportOptions.setExportOptions(ExportOptions.ONE_ROW_PER_FILE);
        }
        exportOptions.showDialog();
        if (exportOptions.isApproved() && (response = this.exportFileChooser.showSaveDialog(this)) == 0) {
            ArrayList<String> profileIds = new ArrayList<String>();
            profileIds.addAll(exportOptions.getSelectedProfileIds());
            ExportAction exportAction = this.globalContext.getActionFactory().newExportAction();
            final ExportProgressDialog exportDialog = new ExportProgressDialog((Frame)this, exportAction);
            exportAction.setDestination(this.exportFileChooser.getSelectedFile());
            exportAction.setProfileIds(profileIds);
            exportAction.setExportOptions(exportOptions.getExportOptions());
            exportAction.setOutputEncoding(exportOptions.getOutputEncoding());
            exportAction.setBom(exportOptions.isBom());
            exportAction.setCallback(new ActionDoneCallback<ExportAction>(){

                @Override
                public void done(ExportAction action) {
                    try {
                        exportDialog.setVisible(false);
                        exportDialog.dispose();
                        action.get();
                        JOptionPane.showMessageDialog(DroidMainFrame.this, "Export Complete.", "Export Complete", 1);
                    }
                    catch (ExecutionException e) {
                        DialogUtils.showGeneralErrorDialog(DroidMainFrame.this, "Export Error", e.getCause().getMessage());
                    }
                    catch (InterruptedException e) {
                        DialogUtils.showGeneralErrorDialog(DroidMainFrame.this, "Export Interrupted", e.getCause().getMessage());
                    }
                    catch (CancellationException e) {
                        DroidMainFrame.this.log.info("Export cancelled");
                    }
                }
            });
            exportAction.execute();
            exportDialog.setVisible(true);
        }
    }

    private void exit() {
        for (ExitListener exitListener : this.exitListeners) {
            exitListener.onExit();
        }
        StopRunningProfilesAction stopRunningAction = new StopRunningProfilesAction(this.profileManager, this.droidContext, this);
        if (stopRunningAction.execute()) {
            SaveAllProfilesDialog dialog = new SaveAllProfilesDialog((Frame)this, this.droidContext.allDirtyProfiles());
            final ExitAction action = new ExitAction(this.droidContext, dialog, this.profileManager);
            action.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (DroidMainFrame.STATE.equals(evt.getPropertyName()) && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE) && !action.isCancelled()) {
                        DroidMainFrame.this.setVisible(false);
                        DroidMainFrame.this.log.info("Closing DROID.");
                        Path tempDir = DroidMainFrame.this.globalContext.getGlobalConfig().getTempDir();
                        ResourceUtils.attemptToDeleteTempFiles((Path)tempDir);
                        System.exit(0);
                    }
                }
            });
            action.start();
        }
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public JFileChooser getProfileFileChooser() {
        return this.profileFileChooser;
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public DroidUIContext getDroidContext() {
        return this.droidContext;
    }
}

