/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JTabbedPane;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.gui.filechooser.ProfileFileChooser;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileState;

public class DroidUIContext {
    private Map<String, ProfileForm> profiles = new HashMap<String, ProfileForm>();
    private JTabbedPane tabbedPane;
    private ProfileManager profileManager;
    private JFileChooser profileFileChooser = new ProfileFileChooser();

    public DroidUIContext(JTabbedPane tabbedPane, ProfileManager profileManager) {
        this.tabbedPane = tabbedPane;
        this.profileManager = profileManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    public ProfileForm getSelectedProfile() {
        return (ProfileForm)this.tabbedPane.getSelectedComponent();
    }

    public void addProfileForm(String profileId, ProfileForm profileForm) {
        this.profiles.put(profileId, profileForm);
    }

    public void remove(String profileId) {
        this.tabbedPane.remove(this.profiles.remove(profileId));
    }

    public boolean isSelected(String profileId) {
        return this.getSelectedProfile().getProfile().getUuid().equals(profileId);
    }

    public boolean selectProfileWithSource(Path selectedFile) {
        for (ProfileForm profileForm : this.profiles.values()) {
            if (!selectedFile.equals(profileForm.getProfile().getLoadedFrom())) continue;
            this.tabbedPane.setSelectedComponent(profileForm);
            return true;
        }
        return false;
    }

    public List<ProfileForm> allDirtyProfiles() {
        ArrayList<ProfileForm> dirtyProfiles = new ArrayList<ProfileForm>();
        for (ProfileForm profile : this.profiles.values()) {
            ProfileInstance profileInstance = profile.getProfile();
            if (!profileInstance.isDirty()) continue;
            dirtyProfiles.add(profile);
        }
        return Collections.unmodifiableList(dirtyProfiles);
    }

    public JFileChooser getProfileFileChooser() {
        return this.profileFileChooser;
    }

    public Collection<ProfileForm> allProfiles() {
        return Collections.unmodifiableCollection(this.profiles.values());
    }

    public ProfileForm getProfile(String profileId) {
        return this.profiles.get(profileId);
    }

    public List<ProfileForm> allRunningProfiles() {
        ArrayList<ProfileForm> runningProfiles = new ArrayList<ProfileForm>();
        for (ProfileForm profile : this.profiles.values()) {
            ProfileInstance profileInstance = profile.getProfile();
            if (!profileInstance.getState().equals((Object)ProfileState.RUNNING)) continue;
            runningProfiles.add(profile);
        }
        return Collections.unmodifiableList(runningProfiles);
    }
}

