/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceType;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.AbstractProfileResource;
import uk.gov.nationalarchives.droid.profile.DirectoryProfileResource;
import uk.gov.nationalarchives.droid.profile.FileProfileResource;
import uk.gov.nationalarchives.droid.profile.NodeMetaData;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProfileSpec;

public class AddFilesAndFoldersAction {
    private DroidUIContext droidContext;
    private ProfileManager profileManager;

    public AddFilesAndFoldersAction(DroidUIContext context, ProfileManager profileManager) {
        this.droidContext = context;
        this.profileManager = profileManager;
    }

    public void add(Collection<File> selectedFiles, boolean recursive) {
        ProfileForm selectedProfile = this.droidContext.getSelectedProfile();
        DefaultTreeModel treeModel = selectedProfile.getTreeModel();
        ProfileInstance profile = selectedProfile.getProfile();
        ProfileSpec profileSpec = profile.getProfileSpec();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
        for (File selectedFile : selectedFiles) {
            boolean isShortcut = !selectedFile.toURI().getPath().endsWith("/");
            Object newResource = selectedFile.isDirectory() && !isShortcut ? new DirectoryProfileResource(Paths.get(selectedFile.toURI()), recursive) : new FileProfileResource(Paths.get(selectedFile.toURI()));
            if (!profile.addResource((AbstractProfileResource)newResource)) continue;
            ProfileResourceNode primordialNode = new ProfileResourceNode(newResource.getUri());
            NodeMetaData metaData = primordialNode.getMetaData();
            metaData.setName(Paths.get(newResource.getUri()).toString());
            metaData.setNodeStatus(NodeStatus.NOT_DONE);
            metaData.setResourceType(newResource.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(primordialNode, false);
            int index = rootNode.getChildCount();
            treeModel.insertNodeInto(node, rootNode, index);
        }
        this.profileManager.updateProfileSpec(profile.getUuid(), profileSpec);
    }
}

