/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.swing.outline.Outline;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;

public class ApplyFilterToTreeTableAction {
    private ProfileManager profileManager;
    private ProfileForm profileToFilter;

    public ApplyFilterToTreeTableAction(ProfileForm profile, ProfileManager profileManager) {
        this.profileToFilter = profile;
        this.profileManager = profileManager;
    }

    public void applyFilter() {
        DefaultTreeModel treeMdl = this.profileToFilter.getTreeModel();
        Outline outline = this.profileToFilter.getResultsOutline();
        for (int i = outline.getRowCount(); i > 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)outline.getValueAt(i - 1, 0);
            if (node.isRoot()) continue;
            treeMdl.removeNodeFromParent(node);
        }
        treeMdl.reload();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeMdl.getRoot();
        String profileId = this.profileToFilter.getProfile().getUuid();
        List childNodes = this.profileManager.findRootNodes(profileId);
        for (ProfileResourceNode profileNode : childNodes) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(profileNode);
            treeNode.setAllowsChildren(profileNode.allowsChildren());
            rootNode.add(treeNode);
        }
        treeMdl.reload();
    }
}

