/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.NodeStatus;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileResourceNode;
import uk.gov.nationalarchives.droid.profile.ProgressState;
import uk.gov.nationalarchives.droid.results.handlers.ProgressObserver;

public class LoadProfileWorker
extends SwingWorker<ProfileInstance, Void> {
    private static final int UNITY_PERCENT = 100;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ProfileManager profileManager;
    private DroidUIContext context;
    private JTabbedPane tabbedPane;
    private ProgressObserver observer;
    private Path profileFile;
    private ProfileForm profilePanel;

    public LoadProfileWorker(ProfileManager profileManager, DroidUIContext context, JTabbedPane tabbedPane) {
        this.profileManager = profileManager;
        this.context = context;
        this.tabbedPane = tabbedPane;
    }

    public void init(ProfileForm parent) {
        this.profilePanel = parent;
        this.profilePanel.setName(FilenameUtils.getBaseName((String)this.profileFile.getFileName().toString()));
        final JProgressBar statusProgressBar = this.profilePanel.getStatusProgressBar();
        final JLabel statusLabel = this.profilePanel.getStatusLabel();
        statusProgressBar.setVisible(true);
        statusProgressBar.setIndeterminate(false);
        statusProgressBar.setIndeterminate(false);
        statusLabel.setText("Loading profile...");
        this.observer = new ProgressObserver(){

            public void onProgress(Integer progress) {
                LoadProfileWorker.this.setProgress(progress);
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    statusProgressBar.setValue((Integer)evt.getNewValue());
                    if (LoadProfileWorker.this.getProgress() == 100) {
                        statusProgressBar.setIndeterminate(true);
                        statusLabel.setText("Initialising profile...");
                    }
                }
            }
        });
        this.tabbedPane.add(this.profilePanel);
        this.tabbedPane.setSelectedComponent(this.profilePanel);
        this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfComponent(this.profilePanel), this.profilePanel.getProfileTab());
        JProgressBar progressBar = this.profilePanel.getProfileProgressBar();
        progressBar.setValue(0);
        this.profilePanel.getProgressPanel().setVisible(false);
    }

    @Override
    protected void done() {
        try {
            ProfileInstance profile = (ProfileInstance)this.get();
            ProgressState prog = profile.getProgress();
            int progress = prog == null ? 0 : (int)(100L * prog.getCount() / prog.getTarget());
            this.profilePanel.getProfileProgressBar().setValue(progress);
            this.profilePanel.setProfile(profile);
            this.profilePanel.getStatusLabel().setText("Profile Loaded OK.");
            this.profilePanel.setName(profile.getName());
            this.context.addProfileForm(profile.getUuid(), this.profilePanel);
            DefaultTreeModel treeModel = this.profilePanel.getTreeModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeModel.getRoot();
            for (ProfileResourceNode profileNode : this.profileManager.findRootNodes(profile.getUuid())) {
                boolean allowsChildren = profileNode.allowsChildren() && !NodeStatus.NOT_DONE.equals((Object)profileNode.getMetaData().getNodeStatus());
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(profileNode, allowsChildren);
                rootNode.add(treeNode);
            }
            treeModel.reload();
            this.profilePanel.afterLoad();
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            this.log.error(e.getCause().toString(), (Throwable)e);
            JOptionPane.showMessageDialog(this.profilePanel, String.format("Error opening profile %s", this.profileFile), "Error", 0);
            this.tabbedPane.remove(this.profilePanel);
        }
    }

    @Override
    protected ProfileInstance doInBackground() throws IOException {
        return this.profileManager.open(this.profileFile, this.observer);
    }

    public void setProfileFile(Path profileFile) {
        this.profileFile = profileFile;
    }
}

