/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.gui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;
import uk.gov.nationalarchives.droid.gui.DroidUIContext;
import uk.gov.nationalarchives.droid.gui.ExitListener;
import uk.gov.nationalarchives.droid.gui.ProfileForm;
import uk.gov.nationalarchives.droid.profile.ProfileInstance;
import uk.gov.nationalarchives.droid.profile.ProfileManager;
import uk.gov.nationalarchives.droid.profile.ProfileManagerException;
import uk.gov.nationalarchives.droid.profile.ProfileState;

public class NewProfileAction
extends SwingWorker<Void, Void>
implements ExitListener {
    private static int count = 1;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DroidUIContext droidContext;
    private ProfileManager profileManager;
    private JTabbedPane tabbedPane;
    private String profileName;
    private ProfileInstance profile;
    private ProfileForm profileForm;
    private Map<SignatureType, SignatureFileInfo> signatures;

    public NewProfileAction(DroidUIContext context, ProfileManager profileManager, JTabbedPane tabbedPane) {
        this.droidContext = context;
        this.profileManager = profileManager;
        this.tabbedPane = tabbedPane;
    }

    public void init(ProfileForm parent) throws ProfileManagerException {
        this.profileForm = parent;
        this.profile = this.profileManager.createProfile(this.signatures);
        this.profileForm.setProfile(this.profile);
        this.profileName = "Untitled-" + count++;
        this.profileForm.setName(this.profileName);
        this.profile.setName(this.profileName);
        this.tabbedPane.add(this.profileForm);
        this.tabbedPane.setSelectedComponent(this.profileForm);
        this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfComponent(this.profileForm), this.profileForm.getProfileTab());
        JProgressBar progressBar = this.profileForm.getProfileProgressBar();
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        this.profileForm.getStatusLabel().setText("Initialising profile...");
        this.profileForm.getStatusProgressBar().setIndeterminate(true);
        this.profileForm.getStatusProgressBar().setVisible(true);
        progressBar.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    ((JProgressBar)evt.getSource()).setValue((Integer)evt.getNewValue());
                }
            }
        });
        this.droidContext.addProfileForm(this.profile.getUuid(), this.profileForm);
    }

    @Override
    protected void done() {
        try {
            if (!this.isCancelled()) {
                this.get();
            }
        }
        catch (InterruptedException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.profile.changeState(ProfileState.VIRGIN);
            this.profileForm.afterCreate();
            this.profileForm.getStatusLabel().setVisible(false);
            this.profileForm.getStatusProgressBar().setIndeterminate(false);
            this.profileForm.getStatusProgressBar().setVisible(false);
        }
    }

    @Override
    protected Void doInBackground() {
        this.profileManager.openProfile(this.profile.getUuid());
        return null;
    }

    public void setSignatures(Map<SignatureType, SignatureFileInfo> signatures) {
        this.signatures = signatures;
    }

    @Override
    public void onExit() {
        this.cancel(true);
    }
}

